# 画面設計書 265-ラベル新規作成

## 概要

本ドキュメントは、GitLab管理者エリアにおける「ラベル新規作成」画面の設計を記載したものです。システム全体で使用されるデフォルトラベル（テンプレートラベル）を新規作成するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：組織全体で統一された課題管理を行うためには、共通のラベル体系が必要です。管理者は、新規プロジェクト作成時に自動的に追加されるデフォルトラベルを定義することで、組織横断的な分類の標準化を実現できます。本画面は、新しいテンプレートラベルの作成インターフェースを提供します。

**画面へのアクセス方法**：管理者エリア > ラベル一覧 > 「New label」ボタン、または `/admin/labels/new` に直接アクセスします。管理者権限が必要です。

**主要な操作・処理内容**：
1. ラベル名の入力（必須）
2. ラベルの説明文の入力（任意）
3. ラベルの背景色の選択（カラーピッカーまたはプリセット）
4. ラベルの作成・保存

**画面遷移**：
- 遷移元：ラベル一覧画面
- 遷移先：ラベル一覧画面（作成成功後）、同一画面（バリデーションエラー時）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 120 | ラベル管理 | 主機能 | システムラベルの新規作成 |
| 40 | ラベル管理 | 補助機能 | ラベルの基本機能 |

## 画面種別

登録

## URL/ルーティング

- URL: `/admin/labels/new`
- HTTPメソッド: GET（フォーム表示）、POST（作成実行）
- コントローラー: `Admin::LabelsController#new`, `Admin::LabelsController#create`

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| タイトル | title | String | 必須 | 255 | ラベルの表示名 |
| 説明 | description | Text | - | 512KB | ラベルの説明文 |
| 背景色 | color | String | 必須 | 7 | HEX形式の色コード（例：#428BCA） |

### カラープリセット

共有フォームで提供されるプリセット色：
- 青系：#428BCA, #44AD8E, #A8D695
- 赤系：#D10069, #CC0033
- 黄系：#FFECDB, #FFD700
- その他：多数のカラーパレット

## 表示項目

### フォーム構成

| セクション | 内容 |
|-----------|------|
| ページヘッダー | "New label" |
| タイトル入力 | テキストフィールド（必須） |
| 説明入力 | テキストエリア（4行） |
| 色選択 | カラーピッカー + プリセット色 |
| アクション | 「Create label」ボタン、「Cancel」ボタン |

## イベント仕様

### 1-ラベル作成

**トリガー**: 「Create label」ボタン押下

**処理フロー**:
1. フォームデータをPOSTで `/admin/labels` に送信
2. `Labels::CreateService` でラベルを作成
3. `template: true` と `organization_id: Current.organization.id` を設定
4. バリデーション実行
5. 成功時：成功メッセージをフラッシュに設定し、ラベル一覧にリダイレクト
6. 失敗時：エラーメッセージを表示し、フォームを再表示

### 2-カラー選択

**トリガー**: カラーピッカーまたはプリセット色のクリック

**処理フロー**:
1. 選択された色コードをカラーフィールドに設定
2. プレビュー用の色表示を更新

### 3-キャンセル

**トリガー**: 「Cancel」ボタン押下

**処理フロー**:
1. ラベル一覧画面（`/admin/labels`）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ラベル作成 | labels | INSERT | 新規テンプレートラベルを作成 |

### テーブル別更新項目詳細

#### labels

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | フォーム入力値 | 必須、一意性チェック（group_id, project_idごと） |
| INSERT | description | フォーム入力値 | |
| INSERT | color | フォーム入力値 | HEX形式 |
| INSERT | template | true | テンプレートラベルフラグ |
| INSERT | organization_id | Current.organization.id | 所属組織 |
| INSERT | created_at | 現在時刻 | |
| INSERT | updated_at | 現在時刻 | |

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|----------|
| 成功 | ラベル作成成功 | "Label was created" |
| エラー | タイトル未入力 | "Title can't be blank" |
| エラー | タイトル重複 | "Title has already been taken" |
| エラー | 色形式不正 | "Color must be a valid color code" |
| ヒント | 色選択 | "Select a color from the color picker or from the presets below." |

## 例外処理

| 状態 | 処理 |
|------|------|
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 権限不足 | アクセス拒否画面にリダイレクト |

## 備考

- ラベルフォームは `shared/labels/_form.html.haml` を共有
- `Labels::CreateService` を使用してラベルを作成
- テンプレートラベルはプロジェクト・グループに紐付かない（project_id, group_id は null）
- カラー選択UIはJavaScriptで実装（`.label-color-preview`）
- ページ固有スタイル `page_bundles/labels` を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.rb | `app/models/label.rb` | Labelモデルの属性、バリデーション |
| 1-2 | base_label.rb | `app/models/concerns/base_label.rb` | 共通ラベル機能、色のバリデーション |

**読解のコツ**: `validates`メソッドでバリデーションルールを確認。`color`属性のフォーマットバリデーションに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | labels_controller.rb | `app/controllers/admin/labels_controller.rb` | newとcreateアクション |

**主要処理フロー**:
1. **行15-17**: `new` - 空のLabelインスタンスを作成
2. **行21-28**: `create` - CreateServiceを使用してラベルを作成
3. **行65-67**: `label_params` - 許可されたパラメータの定義

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/admin/labels/new.html.haml` | 新規作成画面のレイアウト |
| 3-2 | _form.html.haml | `app/views/shared/labels/_form.html.haml` | 共有フォームコンポーネント |

**主要処理フロー**:
- **行5-6**: ページヘッダーとフォームのレンダリング
- フォーム：タイトル、説明、カラー選択のUI

#### Step 4: サービスクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | create_service.rb | `app/services/labels/create_service.rb` | ラベル作成ロジック |

### プログラム呼び出し階層図

```
Admin::LabelsController#new
    │
    └─ @label = Label.new

Admin::LabelsController#create
    │
    └─ Labels::CreateService.new(label_params)
           │
           └─ execute(template: true, organization_id: Current.organization.id)
                  │
                  ├─ Label.new(params.merge(options))
                  └─ label.save
```

### データフロー図

```
[入力]                   [処理]                         [出力]

フォーム入力 ───────────▶ label_params ──────────────▶ CreateService
                              │
                              └─ title, description, color

CreateService ─────────▶ Label.new + save ──────────▶ @label
                              │
                              └─ template: true
                              └─ organization_id: Current.organization.id
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| labels_controller.rb | `app/controllers/admin/labels_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/admin/labels/new.html.haml` | テンプレート | 画面表示 |
| _form.html.haml | `app/views/shared/labels/_form.html.haml` | パーシャル | フォームコンポーネント |
| label.rb | `app/models/label.rb` | モデル | ラベルデータモデル |
| create_service.rb | `app/services/labels/create_service.rb` | サービス | 作成ロジック |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
| labels.scss | `app/assets/stylesheets/page_bundles/labels.scss` | スタイル | ラベル表示用CSS |
