# 画面設計書 268-使用トレンド

## 概要

本ドキュメントは、GitLab管理者エリアにおける「使用トレンド」画面の設計を記載したものです。GitLabインスタンス全体の使用状況をグラフ形式で可視化するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：GitLabインスタンスの管理者は、プラットフォームの利用状況を把握し、成長トレンドやリソース計画に役立てる必要があります。本画面は、ユーザー数、プロジェクト数、グループ数、課題数、マージリクエスト数など、主要なエンティティの時系列推移を可視化し、インスタンスの健全性と成長を監視できるようにします。

**画面へのアクセス方法**：管理者エリア > 分析 > 使用トレンド、または `/admin/usage_trends` に直接アクセスします。管理者権限が必要です。

**主要な操作・処理内容**：
1. 各種エンティティの総数表示
2. 時系列グラフによるトレンド表示
3. 日次/週次/月次のグラフ粒度切り替え

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドバーナビゲーション
- 遷移先：（本画面内での操作が中心）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 126 | リポジトリアナリティクス | 主機能 | 使用状況トレンドの表示 |
| 8 | プロジェクト統計 | 補助機能 | プロジェクト関連統計 |

## 画面種別

分析 / ダッシュボード

## URL/ルーティング

- URL: `/admin/usage_trends`
- HTTPメソッド: GET
- コントローラー: `Admin::UsageTrendsController#index`

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### 統計サマリー

| 項目名 | 説明 |
|--------|------|
| Users | 登録ユーザー総数 |
| Projects | プロジェクト総数 |
| Groups | グループ総数 |
| Issues | 課題総数 |
| Merge requests | マージリクエスト総数 |
| Pipelines | パイプライン総数 |

### トレンドグラフ

| グラフ種別 | 説明 |
|-----------|------|
| Users | ユーザー数の時系列推移 |
| Projects | プロジェクト数の時系列推移 |
| Groups | グループ数の時系列推移 |
| Issues | 課題数の時系列推移 |
| Merge requests | マージリクエスト数の時系列推移 |
| Pipelines | パイプライン数の時系列推移 |

## イベント仕様

### 1-統計データ取得

**トリガー**: 画面表示時

**処理フロー**:
1. VueコンポーネントがGraphQL APIを呼び出し
2. `UsageTrendsMeasurement` からデータを取得
3. グラフコンポーネントにデータを渡す
4. Chart.jsでグラフを描画

### 2-イベントトラッキング

**トリガー**: 画面表示時

**処理フロー**:
1. `ProductAnalyticsTracking`モジュールでイベント送信
2. `i_analytics_instance_statistics` イベントを記録
3. Redis HLLとSnowplowに送信

### 3-ページ表示イベント

**トリガー**: ページロード完了時

**処理フロー**:
1. `event_tracking_load` データ属性でイベント発火
2. `view_admin_usage_trends_pageload` イベントを送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 統計表示 | analytics_usage_trends_measurements | SELECT | トレンドデータを取得 |

### テーブル別更新項目詳細

#### analytics_usage_trends_measurements（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | identifier | 各エンティティタイプ | users, projects等 |
| SELECT | count | 各時点でのカウント | |
| SELECT | recorded_at | 記録日時 | 時系列グラフ用 |

## メッセージ仕様

本画面にはユーザー向けメッセージは特にありません。

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | アクセス拒否画面にリダイレクト |
| GraphQLエラー | エラーメッセージを表示 |
| データなし | 空のグラフを表示 |

## 備考

- 画面全体がVueコンポーネント（`#js-usage-trends-app`）で実装されている
- データはGraphQL API経由で取得される
- グラフ描画にはChart.jsを使用
- トレンドデータは定期的なバックグラウンドジョブで集計・保存される
- イベントトラッキング: `view_admin_usage_trends_pageload`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | usage_trends_measurement.rb | `app/models/analytics/usage_trends_measurement.rb` | 統計データモデル |

**読解のコツ**: `identifier`カラムで統計の種類（users, projects等）を識別。`recorded_at`で時系列データを管理。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | usage_trends_controller.rb | `app/controllers/admin/usage_trends_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行16**: `index` - 空のアクション（Vueに委譲）
2. **行6-10**: イベントトラッキングの設定

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/usage_trends/index.html.haml` | Vueマウントポイント |

**主要処理フロー**:
- **行4**: イベントトラッキング用データ属性
- **行6**: `#js-usage-trends-app` - Vueコンポーネントのマウントポイント

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | usage_trends_app.vue | `app/assets/javascripts/analytics/usage_trends/usage_trends_app.vue` | メインVueコンポーネント |
| 4-2 | graphql queries | `app/assets/javascripts/analytics/usage_trends/graphql/` | データ取得クエリ |

### プログラム呼び出し階層図

```
Admin::UsageTrendsController#index
    │
    └─ (Vueコンポーネントをレンダリング)
           │
           └─ UsageTrendsApp.vue
                  │
                  ├─ GraphQL Query (usageTrendsMeasurements)
                  │      └─ Analytics::UsageTrendsMeasurement
                  │
                  └─ Chart.js (グラフ描画)
```

### データフロー図

```
[入力]                   [処理]                         [出力]

ページリクエスト ────▶ Controller#index ─────────▶ Vue mount

Vue mounted ─────────▶ GraphQL Query ────────────▶ 統計データ

統計データ ──────────▶ Chart.js ─────────────────▶ グラフ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| usage_trends_controller.rb | `app/controllers/admin/usage_trends_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/admin/usage_trends/index.html.haml` | テンプレート | Vueマウント |
| usage_trends_measurement.rb | `app/models/analytics/usage_trends_measurement.rb` | モデル | 統計データ |
| usage_trends_app.vue | `app/assets/javascripts/analytics/usage_trends/usage_trends_app.vue` | Vue | メインコンポーネント |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
