# 画面設計書 269-DevOpsレポート

## 概要

本ドキュメントは、GitLab管理者エリアにおける「DevOpsレポート」画面の設計を記載したものです。GitLabインスタンスにおけるDevOps実践度を評価・表示するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：DevOpsの成熟度を測定することは、組織の開発プロセス改善において重要です。本画面は、GitLabが提供するDevOpsスコアを表示し、組織がどの程度DevOpsプラクティスを採用しているかを可視化します。CI/CD、コードレビュー、デプロイメントなどの各領域でのスコアを確認でき、改善が必要な領域を特定できます。

**画面へのアクセス方法**：管理者エリア > 分析 > DevOps adoption、または `/admin/dev_ops_reports` に直接アクセスします。管理者権限が必要です。

**主要な操作・処理内容**：
1. DevOpsスコアの総合評価表示
2. 各DevOpsカテゴリのスコア表示
3. サービスPing有効時のスコアメトリクス表示
4. サービスPing無効時の有効化案内表示

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドバーナビゲーション
- 遷移先：設定画面（サービスPing有効化用）

**権限による表示制御**：管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 127 | CI/CDアナリティクス | 主機能 | DevOpsスコアの表示 |
| 143 | ヘルスチェック | 補助機能 | サービス状態の確認 |

## 画面種別

分析 / ダッシュボード

## URL/ルーティング

- URL: `/admin/dev_ops_reports`（旧: `/admin/dev_ops_report`）
- HTTPメソッド: GET
- コントローラー: `Admin::DevOpsReportController#show`

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### サービスPing有効時

| 項目名 | 説明 |
|--------|------|
| DevOpsスコア | 総合的なDevOps成熟度スコア |
| カテゴリ別スコア | 各DevOps領域のスコア |
| 比較データ | 他のGitLabインスタンスとの比較（オプション） |

### サービスPing無効時

| 項目名 | 説明 |
|--------|------|
| 空状態イラスト | サービスPing無効を示すイラスト |
| 有効化案内 | サービスPingの有効化手順 |
| ドキュメントリンク | サービスPingに関する詳細ドキュメント |

### DevOpsスコアカテゴリ

| カテゴリ | 評価対象 |
|---------|----------|
| Issues | 課題管理の活用度 |
| MRs | マージリクエストの活用度 |
| CI Pipelines | CI/CDパイプラインの活用度 |
| Deployments | デプロイメントの実施状況 |
| Environments | 環境管理の活用度 |
| Monitoring | モニタリングの活用度 |
| Code review | コードレビューの実施状況 |

## イベント仕様

### 1-DevOpsスコア取得

**トリガー**: 画面表示時

**処理フロー**:
1. `DevOpsReport::Metric` から最新のメトリクスを取得
2. `present` メソッドでPresenterオブジェクトを生成
3. サービスPingの有効状態を確認
4. 状態に応じたUIコンポーネントを表示

### 2-イベントトラッキング

**トリガー**: 画面表示時（サービスPing有効時のみ）

**処理フロー**:
1. `track_internal_event`でイベント送信
2. `i_analytics_dev_ops_score` イベントを記録
3. `should_track_devops_score?`で条件チェック

### 3-ページ表示イベント

**トリガー**: ページロード完了時

**処理フロー**:
1. `event_tracking_load` データ属性でイベント発火
2. `view_admin_dev_ops_reports_pageload` イベントを送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スコア表示 | dev_ops_report_metrics | SELECT | 最新のDevOpsメトリクスを取得 |

### テーブル別更新項目詳細

#### dev_ops_report_metrics（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | ORDER BY created_at DESC LIMIT 1 | 最新レコードを取得 |

## メッセージ仕様

本画面にはユーザー向けメッセージは特にありません。

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | アクセス拒否画面にリダイレクト |
| メトリクスデータなし | 空のスコアを表示 |
| サービスPing無効 | 有効化案内を表示 |

## 備考

- サービスPing（Usage Ping）の有効/無効で表示内容が大きく異なる
- EE版では追加のDevOps Adoptionタブが表示される
- ページ固有スタイル `page_bundles/dev_ops_reports` を使用
- 旧URL `/admin/dev_ops_report` は `/admin/dev_ops_reports` にリダイレクト
- イベントトラッキング: `view_admin_dev_ops_reports_pageload`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | metric.rb | `app/models/dev_ops_report/metric.rb` | DevOpsメトリクスモデル |

**読解のコツ**: メトリクスの各カテゴリスコアがどのように格納されているかを確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dev_ops_report_controller.rb | `app/controllers/admin/dev_ops_report_controller.rb` | showアクション |

**主要処理フロー**:
1. **行18-20**: `show` - 最新メトリクスの取得とPresenter化
2. **行23-25**: `show_adoption?` - EE版のタブ表示判定
3. **行27-29**: `should_track_devops_score?` - イベントトラッキング条件

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/dev_ops_report/show.html.haml` | メインレイアウト |
| 3-2 | _score.html.haml | `app/views/admin/dev_ops_report/_score.html.haml` | スコア表示コンポーネント |

**主要処理フロー**:
- **行4**: イベントトラッキング用データ属性
- **行5-8**: サービスPing有効時/無効時の表示分岐

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | js-devops-service-ping-disabled | Vueコンポーネント | サービスPing無効時のUI |
| 4-2 | js-devops-score | Vueコンポーネント | スコア表示UI |

### プログラム呼び出し階層図

```
Admin::DevOpsReportController#show
    │
    └─ DevOpsReport::Metric.order(:created_at).last
           │
           └─ &.present (Presenter化)
                  │
                  └─ devops_score_metrics ヘルパー
```

### データフロー図

```
[入力]                   [処理]                         [出力]

ページリクエスト ────▶ show アクション ──────────────▶ @metric

@metric ─────────────▶ service_ping_enabled? ────────▶ 表示分岐
                              │
                              ├─ true: スコア表示
                              │
                              └─ false: 有効化案内
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dev_ops_report_controller.rb | `app/controllers/admin/dev_ops_report_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/admin/dev_ops_report/show.html.haml` | テンプレート | メイン画面 |
| _score.html.haml | `app/views/admin/dev_ops_report/_score.html.haml` | パーシャル | スコア表示 |
| metric.rb | `app/models/dev_ops_report/metric.rb` | モデル | メトリクスデータ |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
| dev_ops_reports.scss | `app/assets/stylesheets/page_bundles/dev_ops_reports.scss` | スタイル | 画面固有CSS |
