# 画面設計書 270-Gitalyサーバー一覧

## 概要

本ドキュメントは、GitLab管理者エリアにおける「Gitalyサーバー一覧」画面の設計を記載したものです。GitLabのGitストレージを管理するGitalyサーバーの状態を監視するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：Gitalyは、GitLabがGitリポジトリにアクセスするためのサービスです。大規模なGitLabインスタンスでは、複数のGitalyサーバーが稼働しており、その健全性を監視することは運用上不可欠です。本画面は、全てのGitalyストレージの接続状態、バージョン情報を一覧表示し、管理者がインフラストラクチャの状態を迅速に把握できるようにします。

**画面へのアクセス方法**：管理者エリア > 監視 > Gitalyサーバー、または `/admin/gitaly_servers` に直接アクセスします。管理者権限が必要です。

**主要な操作・処理内容**：
1. 設定されている全Gitalyストレージの一覧表示
2. 各サーバーの接続状態（アドレス）の確認
3. Gitalyサーバーバージョンの確認
4. Gitバイナリバージョンの確認
5. サーバーが最新バージョンかどうかの確認

**画面遷移**：
- 遷移元：管理者ダッシュボード、サイドバーナビゲーション
- 遷移先：（本画面は表示のみ）

**権限による表示制御**：管理者権限（read_admin_gitaly_servers）を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | Gitalyサーバー状態の表示 |

## 画面種別

一覧 / 監視

## URL/ルーティング

- URL: `/admin/gitaly_servers`
- HTTPメソッド: GET
- コントローラー: `Admin::GitalyServersController#index`

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### Gitalyサーバー一覧テーブル

| 項目名 | 物理名 | 説明 |
|--------|--------|------|
| Storage | storage | ストレージ名（gitlab.yml で設定された名前） |
| Address | address | Gitalyサーバーのアドレス（TCP/Unix socket） |
| Server version | server_version | Gitalyサーバーのバージョン |
| Git version | git_binary_version | Gitバイナリのバージョン |
| Up to date | up_to_date? | バージョンが最新かどうか（アイコン表示） |

### ヘッダー情報

| 項目名 | 説明 |
|--------|------|
| ページタイトル | "Gitaly servers" |
| サーバー数 | 設定されているGitalyストレージの総数 |

## イベント仕様

### 1-サーバー情報取得

**トリガー**: 画面表示時

**処理フロー**:
1. `Gitaly::Server.all` で全ストレージを取得
2. 各ストレージに対してGitalyサーバー情報を取得
3. gRPCを通じてサーバーバージョン情報を取得
4. テーブル形式で表示

### 2-イベントトラッキング

**トリガー**: ページロード完了時

**処理フロー**:
1. `event_tracking_load` データ属性でイベント発火
2. `view_admin_gitaly_servers_pageload` イベントを送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | なし | - | データベースへのアクセスなし |

### 備考

本画面はデータベースにアクセスせず、`gitlab.yml` の設定とGitaly gRPC APIからデータを取得します。

## メッセージ仕様

| 種別 | 条件 | メッセージ |
|------|------|----------|
| 警告 | Gitaly接続失敗 | "No connection could be made to a Gitaly server, please check your logs!" |

## 例外処理

| 状態 | 処理 |
|------|------|
| 権限不足 | アクセス拒否画面にリダイレクト |
| Gitaly接続失敗 | 空のバージョン情報で表示（エラーはログに記録） |
| gRPCタイムアウト | 空のバージョン情報で表示 |

## 備考

- Gitalyストレージは `gitlab.yml` の `repositories.storages` で設定
- バージョン確認は gRPC (`Gitlab::GitalyClient::ServerService`) で実行
- 接続エラー時（GRPC::Unavailable, GRPC::DeadlineExceeded）はエラートラッキングに送信
- `up_to_date?` は `Gitlab::GitalyClient.expected_server_version` との比較で判定
- SHA形式のバージョンも対応（開発版ビルド）
- イベントトラッキング: `view_admin_gitaly_servers_pageload`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | server.rb | `lib/gitaly/server.rb` | Gitalyサーバー情報の取得 |

**読解のコツ**: `Server.all`でストレージ一覧を取得。各メソッド（`server_version`, `git_binary_version`等）でgRPCを呼び出してサーバー情報を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gitaly_servers_controller.rb | `app/controllers/admin/gitaly_servers_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行5**: `authorize!` - 権限チェック
2. **行7-8**: `index` - `Gitaly::Server.all` でサーバー一覧を取得

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/gitaly_servers/index.html.haml` | テーブル表示 |

**主要処理フロー**:
- **行4**: イベントトラッキング用データ属性
- **行6-8**: CrudComponentでテーブルラッパー
- **行11-35**: テーブル構造（レスポンシブ対応）

#### Step 4: Gitaly通信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | server_service.rb | `lib/gitlab/gitaly_client/server_service.rb` | gRPC呼び出し |

### プログラム呼び出し階層図

```
Admin::GitalyServersController#index
    │
    └─ Gitaly::Server.all
           │
           └─ Gitlab.config.repositories.storages.keys.map
                  │
                  └─ Gitaly::Server.new(storage)
                         │
                         ├─ info (gRPC)
                         │      └─ ServerService.new.info
                         │
                         ├─ address
                         │      └─ Gitlab::GitalyClient.address
                         │
                         └─ up_to_date?
                                └─ expected_version比較
```

### データフロー図

```
[入力]                   [処理]                         [出力]

gitlab.yml ────────────▶ Gitlab.config.repositories ─▶ storage名一覧
                              │
storage名 ─────────────▶ Gitaly::Server.new ─────────▶ サーバーオブジェクト
                              │
gRPC呼び出し ──────────▶ ServerService.info ─────────▶ バージョン情報
                              │
expected_version ──────▶ up_to_date? ────────────────▶ 最新判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gitaly_servers_controller.rb | `app/controllers/admin/gitaly_servers_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/admin/gitaly_servers/index.html.haml` | テンプレート | 画面表示 |
| server.rb | `lib/gitaly/server.rb` | ライブラリ | Gitalyサーバー情報 |
| server_service.rb | `lib/gitlab/gitaly_client/server_service.rb` | クライアント | gRPC呼び出し |
| gitaly_client.rb | `lib/gitlab/gitaly_client.rb` | クライアント | Gitaly接続管理 |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
