# 画面設計書 272-バックグラウンドマイグレーション一覧

## 概要

本ドキュメントは、GitLab管理者画面における「バックグラウンドマイグレーション一覧」画面の設計書です。GitLabのアップグレード時に実行されるバックグラウンドマイグレーションの状態を管理者が監視・管理するための画面仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：GitLabのバージョンアップグレード時、データベースのマイグレーションが長時間かかる場合があります。ユーザー操作に影響を与えないよう、GitLabではこれらのマイグレーションをバックグラウンドで非同期実行します。管理者はこの画面でマイグレーションの進捗を確認し、必要に応じて一時停止、再開、リトライなどの操作を行うことができます。

**画面へのアクセス方法**：管理者エリア > モニタリング > バックグラウンドマイグレーション（Admin Area > Monitoring > Background migrations）からアクセスします。管理者権限を持つユーザーのみがアクセス可能です。

**主要な操作・処理内容**：
1. バックグラウンドマイグレーションの一覧表示
2. タブによる状態別フィルタリング（Queued/Finalizing/Failed/Finished）
3. マイグレーションの一時停止（Pause）
4. マイグレーションの再開（Resume）
5. 失敗したマイグレーションのリトライ（Retry）
6. 複数データベース環境でのデータベース切り替え
7. マイグレーション詳細画面への遷移

**画面遷移**：管理者ダッシュボードから遷移。各マイグレーション行をクリックするとマイグレーション詳細画面（273）へ遷移します。

**権限による表示制御**：管理者（admin）権限を持つユーザーのみがアクセス可能です。`authorize! :read_admin_background_migrations`による権限チェックが行われます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | バックグラウンドジョブ監視 | 主機能 | バックグラウンドマイグレーション一覧の表示・管理 |

## 画面種別

一覧

## URL/ルーティング

```
GET /admin/background_migrations
GET /admin/background_migrations?tab=queued
GET /admin/background_migrations?tab=finalizing
GET /admin/background_migrations?tab=failed
GET /admin/background_migrations?tab=finished
GET /admin/background_migrations?database=main
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| tab | 入力（URL） | String | - | 表示タブ（queued/finalizing/failed/finished） |
| database | 入力（URL） | String | - | 対象データベース名 |
| page | 入力（URL） | Integer | - | ページ番号 |

## 表示項目

### タブカウンター

| 項目名 | 説明 |
|--------|------|
| Queued | キューに入っているマイグレーション数 |
| Finalizing | ファイナライズ中のマイグレーション数 |
| Failed | 失敗したマイグレーション数 |
| Finished | 完了したマイグレーション数 |

### マイグレーション一覧テーブル

| 項目名 | 説明 |
|--------|------|
| Migration | マイグレーション名（ジョブクラス名とテーブル名） |
| Progress | 進捗状況（パーセンテージ） |
| Status | ステータス（paused/active/finished/failed/finalizing/finalized） |
| Actions | 操作ボタン（Pause/Resume/Retry/View） |

## イベント仕様

### 1-タブ切り替え

**トリガー**: タブ（Queued/Finalizing/Failed/Finished）クリック

**処理フロー**:
1. 選択されたタブに対応するURLへ遷移
2. 該当ステータスのマイグレーション一覧を取得
3. テーブル再描画

### 2-マイグレーション一時停止

**トリガー**: 「Pause」ボタン押下

**処理フロー**:
1. POST `/admin/background_migrations/:id/pause` へリクエスト
2. BatchedMigration#pause! を実行
3. ステータスを`paused`に変更
4. 元の画面にリダイレクト

### 3-マイグレーション再開

**トリガー**: 「Resume」ボタン押下

**処理フロー**:
1. POST `/admin/background_migrations/:id/resume` へリクエスト
2. BatchedMigration#execute! を実行
3. ステータスを`active`に変更
4. 元の画面にリダイレクト

### 4-マイグレーションリトライ

**トリガー**: 「Retry」ボタン押下（Failed状態のマイグレーションのみ）

**処理フロー**:
1. POST `/admin/background_migrations/:id/retry` へリクエスト
2. BatchedMigration#retry_failed_jobs! を実行
3. 失敗したジョブを分割してリトライ
4. ステータスを`active`に変更
5. 元の画面にリダイレクト

### 5-データベース切り替え

**トリガー**: データベースリストボックスで選択変更

**処理フロー**:
1. 選択されたデータベースをURLパラメータに付与
2. ページを再読み込み
3. 選択されたデータベースのマイグレーション一覧を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | batched_background_migrations | SELECT | マイグレーション一覧取得 |
| 一覧表示 | batched_background_migration_jobs | SELECT | 成功行数カウント |
| Pause | batched_background_migrations | UPDATE | statusをpausedに更新 |
| Resume | batched_background_migrations | UPDATE | statusをactiveに更新、started_atを設定 |
| Retry | batched_background_migrations | UPDATE | statusをactiveに更新 |
| Retry | batched_background_migration_jobs | UPDATE | 失敗ジョブのattemptsを0にリセット |

### テーブル別更新項目詳細

#### batched_background_migrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| Pause | status | 0 (paused) | state_machineによる状態遷移 |
| Resume | status | 1 (active) | |
| Resume | started_at | 現在日時 | before_transition any => :active |
| Retry | status | 1 (active) | |
| 完了時 | finished_at | 現在日時 | before_transition any => :finished |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | No background migrations | 該当タブにマイグレーションがない場合 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 管理者権限なし | 404エラーページを表示 |
| マイグレーションID不正 | ActiveRecord::RecordNotFound、404エラー |
| データベース接続不正 | 該当データベースへの接続エラー |

## 備考

- 複数データベース環境（main, ci等）に対応
- `Gitlab::Database::SharedModel.using_connection`で動的にデータベース接続を切り替え
- ページネーション対応（Kaminariによる）
- マイグレーションの進捗は`total_tuple_count`と`migrated_tuple_count`から計算
- 状態管理にはstate_machineを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バックグラウンドマイグレーションのデータモデルと状態遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | batched_migration.rb | `lib/gitlab/database/background_migration/batched_migration.rb` | マイグレーションモデル、state_machine、スコープ定義 |
| 1-2 | batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | ジョブモデル、状態遷移、リトライロジック |

**読解のコツ**:
- state_machine定義（88-127行目）でステータスの状態遷移を確認
- scope定義（35-44行目）で各タブの取得条件を確認
- `successful_rows_counts`メソッド（156-162行目）で進捗計算ロジックを確認

#### Step 2: エントリーポイントを理解する

ルーティングとコントローラの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin.rb | `config/routes/admin.rb` | バックグラウンドマイグレーションのルーティング（112-120行目） |
| 2-2 | background_migrations_controller.rb | `app/controllers/admin/background_migrations_controller.rb` | コントローラの各アクション |

**主要処理フロー**:
1. **8行目**: `support_multiple_databases`でDB接続を動的に切り替え
2. **11-23行目**: `index`アクションでタブごとの一覧取得
3. **31-35行目**: `pause`アクションでマイグレーション一時停止
4. **37-42行目**: `resume`アクションでマイグレーション再開
5. **44-49行目**: `retry`アクションで失敗ジョブのリトライ

#### Step 3: ビューを理解する

画面表示とタブ構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/background_migrations/index.html.haml` | 一覧画面テンプレート |

**主要処理フロー**:
- **8-10行目**: ページヘッダーとイベントトラッキング
- **12-26行目**: タブナビゲーション（Queued/Finalizing/Failed/Finished）
- **29-43行目**: マイグレーション一覧テーブルまたは空状態表示

### プログラム呼び出し階層図

```
Admin::BackgroundMigrationsController#index
    │
    ├─ support_multiple_databases (around_action)
    │      └─ Gitlab::Database::SharedModel.using_connection
    │
    ├─ batched_migration_class.queued / finalizing / failed / finished
    │      └─ BatchedMigration スコープ
    │
    ├─ batched_migration_class.successful_rows_counts
    │      └─ BatchedJob.with_status(:succeeded).sum(:batch_size)
    │
    └─ render index.html.haml
           ├─ gl_tabs_nav
           ├─ _migration パーシャル（各行）
           └─ paginate_collection
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───▶ BackgroundMigrationsController#index
(tab, database)           │
                          ├─▶ base_model（DB接続選択）
                          │
                          ├─▶ @relations_by_tab（タブごとの件数）
                          │
                          ├─▶ @migrations（ページネーション適用）
                          │
                          └─▶ @successful_rows_counts ───▶ 画面表示
                                  （進捗計算用）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| batched_migration.rb | `lib/gitlab/database/background_migration/batched_migration.rb` | モデル | マイグレーションデータモデル |
| batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | モデル | ジョブデータモデル |
| background_migrations_controller.rb | `app/controllers/admin/background_migrations_controller.rb` | コントローラ | 一覧・操作処理 |
| index.html.haml | `app/views/admin/background_migrations/index.html.haml` | ビュー | 一覧画面テンプレート |
| _migration.html.haml | `app/views/admin/background_migrations/_migration.html.haml` | ビュー | マイグレーション行パーシャル |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
