# 画面設計書 273-バックグラウンドマイグレーション詳細

## 概要

本ドキュメントは、GitLab管理者画面における「バックグラウンドマイグレーション詳細」画面の設計書です。個別のバックグラウンドマイグレーションの詳細情報と、関連する失敗ジョブの一覧を管理者が確認するための画面仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：バックグラウンドマイグレーションに問題が発生した場合、管理者は詳細情報を確認して原因を特定し、適切な対応（リトライや設定変更）を行う必要があります。本画面では、マイグレーションの実行パラメータと失敗したジョブの情報を確認できます。

**画面へのアクセス方法**：管理者エリア > モニタリング > バックグラウンドマイグレーション > 一覧から特定のマイグレーションをクリックしてアクセスします。

**主要な操作・処理内容**：
1. マイグレーションの詳細情報表示（ID、Min/Max Value、バッチサイズ、サブバッチサイズ、間隔、ポーズ時間、作成日時、更新日時、ステータス）
2. 失敗したジョブの一覧表示
3. 失敗ジョブの詳細画面（274）への遷移

**画面遷移**：バックグラウンドマイグレーション一覧（272）から遷移。失敗ジョブ行クリックでバッチジョブ詳細（274）へ遷移します。

**権限による表示制御**：管理者（admin）権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | バックグラウンドジョブ監視 | 主機能 | バックグラウンドマイグレーション詳細の表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /admin/background_migrations/:id
GET /admin/background_migrations/:id?database=main
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| id | 入力（URL） | Integer | 必須 | マイグレーションID |
| database | 入力（URL） | String | - | 対象データベース名 |
| page | 入力（URL） | Integer | - | 失敗ジョブ一覧のページ番号 |

## 表示項目

### マイグレーション基本情報

| 項目名 | 説明 |
|--------|------|
| ページタイトル | ジョブクラス名 : テーブル名 |
| Id | マイグレーションID |
| Min Value | 処理対象の最小値 |
| Max Value | 処理対象の最大値 |
| Batch size | バッチサイズ |
| Sub-batch size | サブバッチサイズ |
| Interval | 実行間隔 |
| Pause time (ms) | ポーズ時間（ミリ秒） |
| Created on | 作成日時 |
| Last updated | 最終更新日時 |
| Status | ステータス |

### 失敗ジョブ一覧テーブル

| 項目名 | 説明 |
|--------|------|
| Id | ジョブID |
| Started at | 開始日時 |
| Finished at | 終了日時 |
| Batch size | バッチサイズ |

## イベント仕様

### 1-失敗ジョブ詳細への遷移

**トリガー**: 失敗ジョブ行クリック

**処理フロー**:
1. 選択されたジョブIDを取得
2. `/admin/background_migrations/:migration_id/batched_jobs/:id` へ遷移
3. バッチジョブ詳細画面（274）を表示

### 2-ページネーション

**トリガー**: ページネーションリンククリック

**処理フロー**:
1. 指定ページ番号でリクエスト
2. 失敗ジョブ一覧を再取得
3. テーブル再描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | batched_background_migrations | SELECT | マイグレーション情報取得 |
| 詳細表示 | batched_background_migration_jobs | SELECT | 失敗ジョブ一覧取得 |

### テーブル別更新項目詳細

本画面は参照のみのため、データベース更新は発生しません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | - | 特定のメッセージなし |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 管理者権限なし | 404エラーページを表示 |
| マイグレーションID不正 | ActiveRecord::RecordNotFound、404エラー |
| データベース接続不正 | 該当データベースへの接続エラー |

## 備考

- 失敗ジョブは`with_status(:failed)`でフィルタリング
- ページネーションはKaminariを使用
- マイグレーション情報の詳細は`_migration_full_information`パーシャルで表示
- 失敗ジョブ情報は`_job`パーシャルで表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マイグレーションとジョブの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | batched_migration.rb | `lib/gitlab/database/background_migration/batched_migration.rb` | has_many :batched_jobsの関連定義 |
| 1-2 | batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | belongs_to :batched_migrationの関連定義、statusスコープ |

**読解のコツ**:
- BatchedMigrationの20行目で`has_many :batched_jobs`を確認
- BatchedJobの33行目で`scope :active`、36行目で`scope :retriable`を確認
- BatchedJobの42-47行目でstate_machine定義を確認

#### Step 2: エントリーポイントを理解する

コントローラのshowアクションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | background_migrations_controller.rb | `app/controllers/admin/background_migrations_controller.rb` | showアクション（25-29行目） |

**主要処理フロー**:
1. **26行目**: マイグレーションをIDで検索
2. **28行目**: 失敗したジョブを取得してページネーション

#### Step 3: ビューを理解する

詳細画面の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/background_migrations/show.html.haml` | 詳細画面テンプレート |

**主要処理フロー**:
- **1-4行目**: パンくずリストとページタイトル設定
- **6行目**: ジョブクラス名とテーブル名の見出し
- **8-25行目**: マイグレーション情報テーブル
- **26-39行目**: 失敗ジョブ一覧（条件付き表示）

### プログラム呼び出し階層図

```
Admin::BackgroundMigrationsController#show
    │
    ├─ support_multiple_databases (around_action)
    │      └─ Gitlab::Database::SharedModel.using_connection
    │
    ├─ batched_migration_class.find(id)
    │      └─ BatchedMigration
    │
    ├─ @migration.batched_jobs.with_status(:failed).page
    │      └─ BatchedJob scope & pagination
    │
    └─ render show.html.haml
           ├─ _migration_full_information パーシャル
           └─ _job パーシャル（失敗ジョブ各行）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───▶ BackgroundMigrationsController#show
(id, database)            │
                          ├─▶ @migration = find(id)
                          │
                          ├─▶ @failed_jobs = batched_jobs.with_status(:failed)
                          │
                          └─▶ render show.html.haml ───▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| batched_migration.rb | `lib/gitlab/database/background_migration/batched_migration.rb` | モデル | マイグレーションデータモデル |
| batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | モデル | ジョブデータモデル |
| background_migrations_controller.rb | `app/controllers/admin/background_migrations_controller.rb` | コントローラ | 詳細表示処理 |
| show.html.haml | `app/views/admin/background_migrations/show.html.haml` | ビュー | 詳細画面テンプレート |
| _migration_full_information.html.haml | `app/views/admin/background_migrations/_migration_full_information.html.haml` | ビュー | マイグレーション情報パーシャル |
| _job.html.haml | `app/views/admin/background_migrations/_job.html.haml` | ビュー | ジョブ行パーシャル |
