# 画面設計書 274-バッチジョブ詳細

## 概要

本ドキュメントは、GitLab管理者画面における「バッチジョブ詳細」画面の設計書です。バックグラウンドマイグレーションの個別ジョブの詳細情報とトランジションログを管理者が確認するための画面仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：バックグラウンドマイグレーションのジョブが失敗した場合、管理者は失敗の原因を特定するために詳細な情報が必要です。本画面では、ジョブの実行パラメータ、試行回数、および状態遷移ログ（トランジションログ）を確認でき、エラークラスやエラーメッセージから原因を特定できます。

**画面へのアクセス方法**：管理者エリア > モニタリング > バックグラウンドマイグレーション > マイグレーション詳細 > 失敗ジョブ一覧から特定のジョブをクリックしてアクセスします。

**主要な操作・処理内容**：
1. バッチジョブの詳細情報表示（ID、Min/Max Value、バッチサイズ、開始日時、終了日時、試行回数、ポーズ時間）
2. トランジションログの一覧表示（ID、作成日時、前ステータス、次ステータス、例外クラス、例外メッセージ）

**画面遷移**：バックグラウンドマイグレーション詳細（273）から遷移。本画面からの遷移先はありません（終端画面）。

**権限による表示制御**：管理者（admin）権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | バックグラウンドジョブ監視 | 主機能 | バッチジョブ詳細の表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /admin/background_migrations/:background_migration_id/batched_jobs/:id
GET /admin/background_migrations/:background_migration_id/batched_jobs/:id?database=main
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| background_migration_id | 入力（URL） | Integer | 必須 | 親マイグレーションID |
| id | 入力（URL） | Integer | 必須 | バッチジョブID |
| database | 入力（URL） | String | - | 対象データベース名 |

## 表示項目

### ジョブ基本情報

| 項目名 | 説明 |
|--------|------|
| ページタイトル | Batched Job (Id: {id}) |
| Id | ジョブID |
| Min Value | 処理対象の最小値 |
| Max Value | 処理対象の最大値 |
| Batch size | バッチサイズ |
| Started at | 開始日時 |
| Finished at | 終了日時 |
| Attempts | 試行回数 |
| Pause time (ms) | ポーズ時間（ミリ秒） |

### トランジションログテーブル

| 項目名 | 説明 |
|--------|------|
| Id | トランジションログID |
| Created At | 作成日時 |
| Previous Status | 前のステータス |
| Next Status | 次のステータス |
| Exception Class | 例外クラス名 |
| Exception Message | 例外メッセージ |

## イベント仕様

本画面は参照のみのため、ユーザー操作によるイベントは発生しません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | batched_background_migration_jobs | SELECT | ジョブ情報取得 |
| 詳細表示 | batched_job_transition_logs | SELECT | トランジションログ取得 |

### テーブル別更新項目詳細

本画面は参照のみのため、データベース更新は発生しません。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | - | 特定のメッセージなし |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 管理者権限なし | 404エラーページを表示 |
| ジョブID不正 | ActiveRecord::RecordNotFound、404エラー |
| データベース接続不正 | 該当データベースへの接続エラー |

## 備考

- トランジションログはジョブの状態遷移履歴を記録
- state_machineの`after_transition`コールバックでトランジションログが自動作成される
- 例外情報は`Gitlab::ErrorTracking.track_exception`でエラートラッキングにも送信される
- MAX_ATTEMPTS（3回）を超えるとジョブは自動リトライされない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ジョブとトランジションログの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | ジョブモデル、has_many :batched_job_transition_logs |

**読解のコツ**:
- 29行目で`has_many :batched_job_transition_logs`を確認
- 42-110行目のstate_machineでトランジションログ作成タイミングを確認
- 91-96行目の`after_transition`でログ作成処理を確認

#### Step 2: エントリーポイントを理解する

コントローラのshowアクションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | batched_jobs_controller.rb | `app/controllers/admin/batched_jobs_controller.rb` | showアクション（10-13行目） |

**主要処理フロー**:
1. **11行目**: ジョブをIDで検索
2. **13行目**: トランジションログを取得

#### Step 3: ビューを理解する

詳細画面の構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/batched_jobs/show.html.haml` | 詳細画面テンプレート |

**主要処理フロー**:
- **1-5行目**: パンくずリストとページタイトル設定
- **7行目**: ジョブID見出し
- **9-21行目**: ジョブ情報テーブル
- **23-36行目**: トランジションログ一覧（条件付き表示）

### プログラム呼び出し階層図

```
Admin::BatchedJobsController#show
    │
    ├─ support_multiple_databases (around_action)
    │      └─ Gitlab::Database::SharedModel.using_connection
    │
    ├─ BatchedJob.find(id)
    │
    ├─ @job.batched_job_transition_logs
    │
    └─ render show.html.haml
           ├─ _job パーシャル
           └─ _transition_log パーシャル（各行）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───▶ BatchedJobsController#show
(id, database)            │
                          ├─▶ @job = BatchedJob.find(id)
                          │
                          ├─▶ @transition_logs = @job.batched_job_transition_logs
                          │
                          └─▶ render show.html.haml ───▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| batched_job.rb | `lib/gitlab/database/background_migration/batched_job.rb` | モデル | ジョブデータモデル |
| batched_job_transition_log.rb | `lib/gitlab/database/background_migration/batched_job_transition_log.rb` | モデル | トランジションログモデル |
| batched_jobs_controller.rb | `app/controllers/admin/batched_jobs_controller.rb` | コントローラ | 詳細表示処理 |
| show.html.haml | `app/views/admin/batched_jobs/show.html.haml` | ビュー | 詳細画面テンプレート |
| _job.html.haml | `app/views/admin/batched_jobs/_job.html.haml` | ビュー | ジョブ情報パーシャル |
| _transition_log.html.haml | `app/views/admin/batched_jobs/_transition_log.html.haml` | ビュー | トランジションログ行パーシャル |
