# 画面設計書 275-初期セットアップ

## 概要

本ドキュメントは、GitLab管理者画面における「初期セットアップ」画面の設計書です。GitLabインスタンスの初回セットアップ時に、管理者（root）アカウントのメールアドレスとパスワードを設定するための画面仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：GitLabを新規インストールした際、rootユーザーには自動生成されたパスワードが設定されています。セキュリティ上の理由から、管理者は初回ログイン前にメールアドレスとパスワードを適切に設定する必要があります。この画面は、そのセットアップを安全かつ簡単に行うためのものです。

**画面へのアクセス方法**：GitLabインスタンスが初期セットアップ状態（rootユーザーが`password_automatically_set`フラグを持つ場合）のときに、root URLへアクセスすると自動的にこの画面にリダイレクトされます。

**主要な操作・処理内容**：
1. ユーザー名の表示（読み取り専用、通常は「root」）
2. メールアドレスの入力
3. 新しいパスワードの入力
4. パスワード確認の入力
5. 設定の保存とログイン画面へのリダイレクト

**画面遷移**：初期セットアップ状態でアクセス時に自動表示。設定完了後はログイン画面へリダイレクトされます。既にセットアップ済みの場合はルートパスにリダイレクトされます。

**権限による表示制御**：この画面は認証なしでアクセス可能です（`skip_before_action :authenticate_user!`）。ただし、初期セットアップ状態でない場合は表示されません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 114 | アプリケーション設定 | 主機能 | 管理者初期セットアップ処理 |

## 画面種別

登録

## URL/ルーティング

```
GET /admin/initial_setup/new
PATCH /admin/initial_setup
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| username | 出力（読み取り専用） | String | - | ユーザー名（通常「root」） |
| email | 入力 | String | 必須 | メールアドレス |
| password | 入力 | String | 必須 | 新しいパスワード |
| password_confirmation | 入力 | String | 必須 | パスワード確認 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| タブタイトル | Administrator Account Setup |
| Username | 管理者ユーザー名（無効化されたフィールド） |
| Email | メールアドレス入力フィールド |
| Password | パスワード入力フィールド |
| Password Confirmation | パスワード確認入力フィールド |
| エラーメッセージ | バリデーションエラー時に表示 |

## イベント仕様

### 1-初期設定の保存

**トリガー**: 「Set up root account」ボタン押下

**処理フロー**:
1. フォームデータのバリデーション実行
2. `Users::UpdateService`を使用してユーザー情報更新
3. `skip_reconfirmation!`でメール確認をスキップ
4. 非プライマリメールアドレスの削除
5. `password_automatically_set`フラグをnullに設定
6. `password_expires_at`をnullに設定
7. 成功時: ログイン画面にリダイレクト、成功メッセージ表示
8. 失敗時: エラーメッセージを表示し、フォームを再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | users | UPDATE | ユーザー情報の更新 |
| 設定保存 | emails | DELETE | 非プライマリメールの削除 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | email | フォーム入力値 | |
| UPDATE | encrypted_password | パスワードのハッシュ値 | Deviseによる暗号化 |
| UPDATE | password_automatically_set | NULL | 自動設定フラグをクリア |
| UPDATE | password_expires_at | NULL | パスワード有効期限をクリア |
| UPDATE | confirmation_token | NULL | skip_reconfirmation!による |
| UPDATE | confirmed_at | 現在日時 | skip_reconfirmation!による |
| UPDATE | updated_at | 現在日時 | |

#### emails

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | user_primary_email?がfalseのレコード | 非プライマリメール削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 成功 | Initial account configured! Please sign in. | 設定成功時（ログイン画面にリダイレクト） |
| MSG002 | 情報 | Initial setup complete! | セットアップ済み状態でアクセス時（ルートにリダイレクト） |
| MSG003 | ガイド | Please use an email address or domain you control. | メールフィールド下に常時表示 |
| MSG004 | エラー | バリデーションエラーメッセージ | 入力エラー時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 初期セットアップ済み | ルートパスにリダイレクト |
| パスワード不一致 | バリデーションエラーを表示 |
| パスワード要件未満 | バリデーションエラーを表示（複雑性要件がある場合） |

## 備考

- `CheckInitialSetup`モジュールを使用して初期セットアップ状態をチェック
- `in_initial_setup_state?`メソッドで状態判定
- 初期メールアドレスは環境変数`GITLAB_ROOT_EMAIL`またはフィクスチャで設定される
- パスワード複雑性要件はEE版で追加される場合がある（`render_if_exists 'shared/password_requirements_list'`）
- レイアウトは`devise`レイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーモデルと初期セットアップの状態判定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | check_initial_setup.rb | `app/controllers/concerns/check_initial_setup.rb` | 初期セットアップ状態の判定ロジック |

**読解のコツ**:
- `in_initial_setup_state?`メソッドで`password_automatically_set`フラグをチェック
- 管理者ユーザーの最後のレコードを取得

#### Step 2: エントリーポイントを理解する

コントローラの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin.rb | `config/routes/admin.rb` | 初期セットアップのルーティング（41行目） |
| 2-2 | initial_setup_controller.rb | `app/controllers/admin/initial_setup_controller.rb` | コントローラの各アクション |

**主要処理フロー**:
1. **7-8行目**: 認証をスキップ
2. **10行目**: before_actionで初期セットアップ状態チェック
3. **18-27行目**: updateアクションでユーザー情報更新
4. **51-55行目**: 非プライマリメールの削除処理

#### Step 3: ビューを理解する

フォーム構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/admin/initial_setup/new.html.haml` | セットアップ画面テンプレート |

**主要処理フロー**:
- **1行目**: タブタイトル設定
- **3行目**: gitlab_ui_form_forによるフォーム生成
- **5-8行目**: エラーメッセージ表示（条件付き）
- **10-12行目**: ユーザー名フィールド（無効化）
- **14-18行目**: メールフィールド
- **20-23行目**: パスワードフィールド
- **25-27行目**: パスワード確認フィールド
- **29-30行目**: 送信ボタン

### プログラム呼び出し階層図

```
Admin::InitialSetupController#new
    │
    ├─ check_initial_setup (before_action)
    │      ├─ in_initial_setup_state?
    │      │      └─ password_automatically_set チェック
    │      └─ @user = User.admins.last
    │
    └─ render new.html.haml

Admin::InitialSetupController#update
    │
    ├─ check_initial_setup (before_action)
    │
    ├─ Users::UpdateService#execute
    │      └─ skip_reconfirmation!
    │
    ├─ clean_up_non_primary_emails
    │      └─ email.destroy（非プライマリ）
    │
    └─ redirect_to new_user_session_path
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力データ ───▶ InitialSetupController#update
(email, password)         │
                          ├─▶ user_params（許可パラメータ抽出）
                          │
                          ├─▶ Users::UpdateService#execute
                          │       │
                          │       ├─▶ user.update
                          │       │
                          │       └─▶ skip_reconfirmation!
                          │
                          ├─▶ clean_up_non_primary_emails
                          │
                          └─▶ redirect / render ───▶ ログイン画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| initial_setup_controller.rb | `app/controllers/admin/initial_setup_controller.rb` | コントローラ | 初期セットアップ処理 |
| check_initial_setup.rb | `app/controllers/concerns/check_initial_setup.rb` | Concern | 初期セットアップ状態チェック |
| new.html.haml | `app/views/admin/initial_setup/new.html.haml` | ビュー | セットアップ画面テンプレート |
| update_service.rb | `app/services/users/update_service.rb` | サービス | ユーザー更新サービス |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
