# 画面設計書 276-ログイン画面（管理者再認証）

## 概要

本ドキュメントは、GitLab管理者画面における「ログイン画面（管理者再認証）」画面の設計書です。管理者モードを有効化するための再認証画面の仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：GitLabでは、管理者権限を持つユーザーが管理者エリアにアクセスする際、セキュリティ強化のため再認証が必要です。これは「管理者モード」と呼ばれ、一時的に管理者権限を有効化します。セッションハイジャックなどの攻撃から管理操作を保護するため、通常のログインとは別に再度パスワード認証を行います。

**画面へのアクセス方法**：管理者権限を持つユーザーが管理者エリア（/admin）にアクセスした際、管理者モードが有効でない場合にこの画面にリダイレクトされます。

**主要な操作・処理内容**：
1. パスワードによる再認証
2. LDAP認証（LDAP有効時）
3. OAuth認証（OmniAuth有効時）
4. 2要素認証（2FA有効時）
5. 管理者モードの有効化

**画面遷移**：管理者エリアへのアクセス試行時にリダイレクト。認証成功後は元のアクセス先（管理者ダッシュボード等）にリダイレクトされます。

**権限による表示制御**：管理者権限（can_access_admin_area?）を持つユーザーのみがアクセス可能です。権限がない場合は404エラーが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | ユーザー登録 | 主機能 | 管理者再認証処理 |

## 画面種別

登録（認証）

## URL/ルーティング

```
GET /admin/session/new
POST /admin/session
DELETE /admin/session
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| password | 入力 | String | 必須 | パスワード |
| otp_attempt | 入力 | String | 条件付き必須 | 2FA有効時のOTPコード |
| device_response | 入力 | String | 条件付き必須 | WebAuthnデバイスレスポンス |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | Enter admin mode |
| パスワード入力フィールド | 再認証用パスワード |
| OTP入力フィールド | 2FA有効時のみ表示 |
| LDAPサーバー選択 | LDAP有効時のみ表示 |
| OmniAuth認証ボタン | OmniAuth有効時のみ表示 |
| エラーメッセージ | 認証失敗時に表示 |

## イベント仕様

### 1-パスワード認証

**トリガー**: パスワード入力後、認証ボタン押下

**処理フロー**:
1. 2FA有効チェック
2. 2FA無効: `current_user_mode.enable_admin_mode!(password:)`を実行
3. 認証成功: 元のアクセス先にリダイレクト、成功メッセージ表示
4. 認証失敗: エラーメッセージを表示し、フォームを再表示

### 2-2要素認証

**トリガー**: 2FA有効ユーザーがパスワード認証後

**処理フロー**:
1. OTPコードまたはWebAuthnレスポンスを検証
2. `valid_otp_attempt?`でOTP検証
3. バックアップコードの場合は`invalidate_otp_backup_code!`で無効化
4. 認証成功: 管理者モード有効化、リダイレクト
5. 認証失敗: エラーメッセージを表示

### 3-LDAP認証

**トリガー**: LDAPタブでの認証ボタン押下

**処理フロー**:
1. LDAPサーバーに対して認証リクエスト
2. 認証成功: 管理者モード有効化
3. 認証失敗: エラーメッセージを表示

### 4-OAuth認証

**トリガー**: OmniAuth認証ボタン押下

**処理フロー**:
1. 外部OAuthプロバイダへリダイレクト
2. コールバック受信後、管理者モード有効化
3. `step_up_auth_scope: 'admin_mode'`でスコープ指定

### 5-管理者モード無効化

**トリガー**: セッション終了またはログアウト

**処理フロー**:
1. `current_user_mode.disable_admin_mode!`を実行
2. OIDCステップアップ認証の場合は`disable_step_up_authentication!`も実行
3. ルートパスにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 2FA認証 | users | UPDATE | OTPバックアップコード使用時の無効化 |
| 管理者モード有効化 | - | セッション更新 | Redisセッションストア更新 |

### テーブル別更新項目詳細

#### users（2FAバックアップコード使用時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | otp_backup_codes | 使用したコードを配列から削除 | invalidate_otp_backup_code! |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 成功 | Admin mode enabled | 管理者モード有効化成功時 |
| MSG002 | 情報 | Admin mode already enabled | 既に管理者モードが有効な場合 |
| MSG003 | 成功 | Admin mode disabled | 管理者モード無効化時 |
| MSG004 | エラー | Invalid login or password | パスワード認証失敗時 |
| MSG005 | エラー | Re-authentication period expired or never requested. Please try again | 再認証期間切れ |
| MSG006 | 情報 | No authentication methods configured. | 認証方法が設定されていない場合 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| 管理者権限なし | 404エラーページを表示 |
| 再認証期間切れ | 新規再認証ページにリダイレクト、警告メッセージ |
| Gitlab::Auth::CurrentUserMode::NotRequestedError | 再認証ページにリダイレクト |

## 備考

- `AuthenticatesWithTwoFactorForAdminMode`モジュールで2FA処理を共通化
- `InternalRedirect`モジュールで安全なリダイレクト処理
- `RendersLdapServers`モジュールでLDAP認証サポート
- 管理者モードの状態は`Gitlab::Auth::CurrentUserMode`クラスで管理
- リダイレクト先から管理者セッション関連のパスは除外（無限ループ防止）
- `omniauth_step_up_auth_for_admin_mode`フィーチャーフラグでOAuth認証を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

管理者モードの状態管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | current_user_mode.rb | `lib/gitlab/auth/current_user_mode.rb` | 管理者モードの状態管理クラス |

**読解のコツ**:
- `admin_mode?`で現在の状態を確認
- `enable_admin_mode!`で有効化処理
- `disable_admin_mode!`で無効化処理
- セッションベースでの状態管理

#### Step 2: エントリーポイントを理解する

コントローラの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin.rb | `config/routes/admin.rb` | 管理者セッションのルーティング（35-37行目） |
| 2-2 | sessions_controller.rb | `app/controllers/admin/sessions_controller.rb` | コントローラの各アクション |

**主要処理フロー**:
1. **8行目**: `user_is_admin!`で管理者権限チェック
2. **12-18行目**: `new`アクションで再認証要求
3. **21-33行目**: `create`アクションで認証処理
4. **35-43行目**: `destroy`アクションで管理者モード無効化

#### Step 3: ビューを理解する

画面構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/admin/sessions/new.html.haml` | 再認証画面テンプレート |

**主要処理フロー**:
- **1-2行目**: ページタイトルとスタイル設定
- **7-8行目**: LDAPまたはフォーム認証の切り替え
- **9-10行目**: パスワード認証フォーム
- **12-15行目**: 認証方法なしのメッセージ
- **17-18行目**: OmniAuth認証ボタン

### プログラム呼び出し階層図

```
Admin::SessionsController#new
    │
    ├─ user_is_admin! (before_action)
    │      └─ current_user.can_access_admin_area?
    │
    ├─ current_user_mode.admin_mode?
    │      └─ 既に有効: redirect_to redirect_path
    │
    └─ current_user_mode.request_admin_mode!
           └─ render new.html.haml

Admin::SessionsController#create
    │
    ├─ two_factor_enabled_for_user?
    │      ├─ Yes: admin_mode_authenticate_with_two_factor
    │      └─ No: current_user_mode.enable_admin_mode!(password:)
    │
    └─ redirect_to redirect_path または render :new
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パスワード入力 ───▶ SessionsController#create
                          │
                          ├─▶ two_factor_enabled_for_user?
                          │       │
                          │       ├─▶ Yes: 2FA認証フロー
                          │       │
                          │       └─▶ No: enable_admin_mode!
                          │
                          ├─▶ 認証成功: redirect_path
                          │
                          └─▶ 認証失敗: render :new ───▶ エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sessions_controller.rb | `app/controllers/admin/sessions_controller.rb` | コントローラ | 管理者再認証処理 |
| current_user_mode.rb | `lib/gitlab/auth/current_user_mode.rb` | ライブラリ | 管理者モード状態管理 |
| authenticates_with_two_factor_for_admin_mode.rb | `app/controllers/concerns/authenticates_with_two_factor_for_admin_mode.rb` | Concern | 2FA認証処理 |
| new.html.haml | `app/views/admin/sessions/new.html.haml` | ビュー | 再認証画面テンプレート |
| _tabs_ldap.html.haml | `app/views/devise/shared/_tabs_ldap.html.haml` | ビュー | LDAP認証タブ |
| _omniauth_box.html.haml | `app/views/devise/shared/_omniauth_box.html.haml` | ビュー | OmniAuth認証ボタン |
| admin.rb | `config/routes/admin.rb` | ルーティング | URL定義 |
