# 画面設計書 28-フォーク一覧

## 概要

本ドキュメントは、GitLabのフォーク一覧画面に関する設計書である。この画面はプロジェクトからフォークされた派生プロジェクトの一覧を表示し、フォークの状況を把握するための機能を提供する。

### 本画面の処理概要

フォーク一覧画面は、特定のプロジェクトからフォークされた全てのプロジェクトを一覧表示する。公開/内部/非公開のフォーク数を表示し、検索やソート機能を提供する。

**業務上の目的・背景**：オープンソースプロジェクトや共有プロジェクトにおいて、どれだけのフォークが存在し、どのような派生プロジェクトが作成されているかを把握することは重要である。この画面により、プロジェクトの影響力や派生作業の状況を確認でき、コミュニティの活動状況を把握することができる。

**画面へのアクセス方法**：
- プロジェクト詳細画面のフォーク数をクリック
- プロジェクトサイドバーから「Forks」を選択
- 直接URL `/:namespace/:project/-/forks` にアクセス

**主要な操作・処理内容**：
1. フォーク一覧の表示 - フォークされたプロジェクトの一覧表示
2. フォーク検索 - キーワードによるフォークの絞り込み
3. ソート - 作成日時、最終更新日時でのソート
4. 新規フォーク作成 - フォーク画面への遷移

**画面遷移**：
- 遷移元：プロジェクト詳細画面、サイドバーナビゲーション
- 遷移先：各フォークプロジェクトの詳細画面、フォーク作成画面

**権限による表示制御**：
- 全ユーザー：自身がアクセス可能なフォークの閲覧
- `fork_project`権限保持者：フォークボタンの表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | プロジェクトフォーク | 主機能 | プロジェクトのフォーク一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/:namespace/:project/-/forks`
- ルーティング: `config/routes/project.rb` - `resources :forks, only: [:index, :new, :create]`
- コントローラ: `Projects::ForksController#index`

## 入出力項目

| 項目名 | 入力/出力 | 必須 | データ型 | 説明 |
|--------|----------|------|----------|------|
| filter_projects | 入力 | - | String | プロジェクト名検索キーワード |
| sort | 入力 | - | String | ソート順（created_at/updated_at） |
| page | 入力 | - | Integer | ページ番号 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 総フォーク数 | Integer | フォークされたプロジェクトの総数 |
| 公開フォーク数 | Integer | 公開可視性のフォーク数 |
| 内部フォーク数 | Integer | 内部可視性のフォーク数 |
| 非公開フォーク数 | Integer | 非公開可視性のフォーク数 |
| フォーク一覧 | List | 各フォークプロジェクトの情報 |
| プロジェクト名 | String | フォークされたプロジェクト名 |
| 名前空間 | String | フォーク先の名前空間 |
| 可視性 | Enum | public/internal/private |
| 最終更新日時 | DateTime | フォークの最終更新日時 |

## イベント仕様

### 1-ページ読み込み

1. `Projects::ForksController#index` が呼び出される
2. `forks_params` でソートパラメータを取得
3. フォーク数のカウント（公開/内部/非公開）
4. `ForkProjectsFinder` でフォークプロジェクトを検索
5. `prepare_projects_for_rendering` でレンダリング準備
6. HTMLまたはJSONでレスポンス

### 2-検索

1. 検索フォームからfilter_projectsパラメータを送信
2. `ForkProjectsFinder` が検索パラメータでフィルタリング
3. 検索結果を表示

### 3-ソート

1. ソートドロップダウンで順序を選択
2. sortパラメータが更新されてページリロード
3. ソートされた結果を表示

### 4-新規フォーク作成

- フォークボタンをクリック
- 遷移先: `/:namespace/:project/-/forks/new`
- 既にフォーク済みの場合は既存フォークへ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | projects | SELECT | フォーク一覧の取得 |
| ページ読み込み | fork_network_members | SELECT | フォーク関係の取得 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | fork_network_members.forked_from_project_id = @project.id | フォーク一覧 |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|------------|--------------|---------|
| 情報 | forks_count | X forks: X public, X internal, and X private | ヘッダー表示 |
| ボタン | go_to_fork | Fork | 未フォーク時 |
| リンク | go_to_your_fork | Go to your fork | フォーク済みの場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| プロジェクトが存在しない | 404エラー |
| コード閲覧権限がない | アクセス拒否 |

## 備考

- フォーク一覧はアクセス権限に基づいてフィルタリングされる
- 非公開フォークは管理者または関係者のみ表示
- ページネーションを使用して大量のフォークを効率的に表示
- JSON形式でも取得可能（API/Ajaxリクエスト用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォーク検索に関連するファインダーを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fork_projects_finder.rb | `app/finders/fork_projects_finder.rb` | フォークプロジェクト検索ロジック |
| 1-2 | fork_network_member.rb | `app/models/fork_network_member.rb` | フォーク関係モデル |

**読解のコツ**: `ForkProjectsFinder#execute`メソッドでフォーク検索の条件を確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | forks_controller.rb | `app/controllers/projects/forks_controller.rb` | indexアクション |

**主要処理フロー**:
1. **20-41行目**: `index` アクション
2. **21行目**: `@sort` パラメータ取得
3. **23-26行目**: フォーク数のカウント（総数、公開、非公開、内部）
4. **28行目**: `load_forks` でフォーク一覧取得
5. **30行目**: `prepare_projects_for_rendering` でレンダリング準備
6. **96-106行目**: `load_forks` メソッド - ForkProjectsFinderの使用

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/forks/index.html.haml` | メインビュー |
| 3-2 | _projects.html.haml | `app/views/projects/forks/_projects.html.haml` | フォーク一覧パーシャル |

**主要処理フロー**:
- **7-10行目（index.html.haml）**: ヘッダーとフォーク数表示
- **12-19行目（index.html.haml）**: 検索フォーム
- **17-19行目（index.html.haml）**: ソートドロップダウン
- **22-28行目（index.html.haml）**: フォークボタン（条件付き）
- **30行目（index.html.haml）**: フォーク一覧パーシャル

### プログラム呼び出し階層図

```
Projects::ForksController#index
    │
    ├─ require_non_empty_project
    │
    ├─ authorize_read_code!
    │
    ├─ フォーク数カウント
    │      ├─ project.forks.size (総数)
    │      ├─ project.forks.public_only.size (公開)
    │      └─ project.forks.public_and_internal_only.size
    │
    ├─ load_forks
    │      └─ ForkProjectsFinder.new(project, params, current_user).execute
    │             └─ includes(:route, :creator, :group, :topics, namespace: [:route, :owner])
    │
    └─ prepare_projects_for_rendering(@forks)
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ ForksController#index ───▶ @forks
    │                     │
    ├─ filter_projects   ├─ ForkProjectsFinder
    │                     │      │
    ├─ sort              │      ├─ 検索フィルタリング
    │                     │      └─ ソート適用
    └─ page              │
                         ├─ ページネーション
                         │
                         └─────────────────▶ HTML/JSON レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| forks_controller.rb | `app/controllers/projects/forks_controller.rb` | コントローラ | リクエストハンドリング |
| index.html.haml | `app/views/projects/forks/index.html.haml` | テンプレート | メインビュー |
| _projects.html.haml | `app/views/projects/forks/_projects.html.haml` | パーシャル | フォーク一覧 |
| fork_projects_finder.rb | `app/finders/fork_projects_finder.rb` | ファインダー | フォーク検索ロジック |
| fork_network_member.rb | `app/models/fork_network_member.rb` | モデル | フォーク関係 |
