# 画面設計書 285-GitHubインポート

## 概要

本ドキュメントは、GitLabのGitHubインポート開始画面の設計を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：GitHubインポート機能は、GitHubからGitLabへプロジェクトを移行するための機能である。本画面は、ユーザーがGitHubアカウントを認証し、インポートを開始するための入口となる画面であり、既存のGitHubプロジェクトをGitLabに移行したい、GitLabへの移行を検討している開発チームのニーズに対応する。

**画面へのアクセス方法**：新規プロジェクト作成画面（`/projects/new`）から「Import project」タブを選択し、「GitHub」を選択する。または直接 `/import/github/new` にアクセスする。

**主要な操作・処理内容**：
1. GitHubとのOAuth認証を行う（管理者がGitHub連携を設定済みの場合）
2. 個人アクセストークン（PAT）を入力して認証する
3. 認証後、リポジトリ選択画面（status画面）に遷移する

**画面遷移**：
- 遷移元：新規プロジェクト作成画面、インポートプロジェクト選択画面
- 遷移先：GitHubインポート状態画面（認証成功時）、新規プロジェクト作成画面（キャンセル時）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- GitHubインポート機能が有効化されている必要がある
- namespace_id が指定された場合、そのネームスペースへのインポート権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | GitHubからのインポート開始 |

## 画面種別

認証 / 入力

## URL/ルーティング

| メソッド | パス | コントローラー#アクション | 説明 |
|----------|------|---------------------------|------|
| GET | `/import/github/new` | `import/github#new` | 認証画面表示 |
| POST | `/import/github/personal_access_token` | `import/github#personal_access_token` | PAT認証 |
| GET | `/import/github/callback` | `import/github#callback` | OAuthコールバック |

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 個人アクセストークン | personal_access_token | String | Yes（PAT認証時） | GitHubの個人アクセストークン |
| ネームスペースID | namespace_id | Integer | No | インポート先ネームスペース |
| CI/CDのみ | ci_cd_only | Boolean | No | CI/CD連携のみフラグ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Authenticate with GitHub」 |
| GitHubアイコン | GitHubロゴの表示 |
| 説明文 | 認証方法の説明 |
| OAuth認証ボタン | 「Authenticate with GitHub」ボタン（OAuth設定時） |
| PAT入力欄 | 個人アクセストークンの入力フィールド |
| 必要スコープ説明 | repo, read:org スコープの説明 |
| 認証ボタン | 「Authenticate」ボタン |
| キャンセルボタン | 「Cancel」ボタン |
| 設定未完了アラート | 管理者設定が必要な場合の案内 |

## イベント仕様

### 1-OAuth認証ボタン押下

**トリガー**：「Authenticate with GitHub」ボタンをクリック（OAuth設定時）

**処理フロー**：
1. セッションに認証状態キーを保存
2. GitHubのOAuth認可ページへリダイレクト
3. ユーザーがGitHub上で認可
4. コールバックURLにリダイレクト
5. アクセストークンを取得してセッションに保存
6. status画面へリダイレクト

### 2-PAT認証ボタン押下

**トリガー**：「Authenticate」ボタンをクリック

**処理フロー**：
1. PATのバリデーション（空でないこと）
2. PATをセッションに保存
3. status画面へリダイレクト
4. status画面でPATの有効性を検証

### 3-キャンセルボタン押下

**トリガー**：「Cancel」ボタンをクリック

**処理フロー**：
1. 新規プロジェクト作成画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認証操作 | - | - | セッションのみ使用、DB更新なし |

### 備考

認証情報はセッションに保存される。データベースへの書き込みはインポート実行時に発生する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | Create and provide your GitHub personal access token. | PAT入力欄の説明 |
| MSG002 | 情報 | Use a classic GitHub personal access token with the following scopes: | スコープ説明 |
| MSG003 | エラー | Personal access token is required. | PAT未入力時 |
| MSG004 | エラー | Invalid credentials | 認証失敗時 |
| MSG005 | エラー | GitHub API rate limit exceeded. Try again after %{reset_time} | レート制限時 |
| MSG006 | エラー | Your GitHub personal access token does not have the required scope to import. | スコープ不足時 |
| MSG007 | 案内 | To import projects from GitHub, ask your GitLab administrator... | OAuth未設定時 |

## 例外処理

| 例外条件 | 画面表示・動作 |
|----------|---------------|
| GitHubインポート無効 | 404エラー |
| OAuth認証失敗 | 「Invalid credentials」メッセージを表示、new画面にリダイレクト |
| レート制限 | レート制限エラーメッセージを表示、new画面にリダイレクト |
| スコープ不足 | スコープ不足エラーメッセージを表示、new画面にリダイレクト |
| OAuth状態不一致 | 「Invalid credentials」メッセージを表示、new画面にリダイレクト |

## 備考

- OAuth認証とPAT認証の両方をサポート
- 必要なPATスコープ：
  - `repo`：公開/非公開リポジトリの一覧表示とインポート
  - `read:org`（オプション）：コラボレーターのインポート、Git LFSファイル対応
- CI/CD連携のみモード（ci_cd_only=true）も利用可能
- Feature Flag `new_project_creation_form` が有効な場合、Vue.jsコンポーネントが使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

認証フローのエントリーポイントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | github_controller.rb | `app/controllers/import/github_controller.rb` | new, callback, personal_access_token アクション |

**主要処理フロー**:
1. **行26-31**: `new` アクションでOAuth/PAT認証の分岐
2. **行34-43**: `callback` アクションでOAuthコールバック処理
3. **行45-48**: `personal_access_token` アクションでPAT保存
4. **行236-242**: `provider_unauthorized` でエラーハンドリング

#### Step 2: ビューテンプレートを理解する

画面表示の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/import/github/new.html.haml` | OAuth/PATフォームの構造 |

**主要要素**（行6-65）:
- Feature Flagによるレンダリング分岐
- Vue.jsマウントポイント `#js-vue-import-github-project-app`
- OAuth認証ボタン
- PAT入力フォーム
- 必要スコープの説明

#### Step 3: OAuth連携を理解する

OAuth認証の実装詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | github_oauth.rb | `app/controllers/concerns/import/github_oauth.rb` | OAuth連携処理 |

#### Step 4: ルーティングを理解する

URLパターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | import.rb | `config/routes/import.rb` | importルーティング定義 |

### プログラム呼び出し階層図

```
Import::GithubController
    │
    ├─ #new
    │      ├─ github_import_configured? チェック
    │      ├─ logged_in_with_provider? チェック
    │      │      └─ OAuth設定あり → go_to_provider_for_permissions
    │      └─ セッションにトークンあり → status_import_url へリダイレクト
    │
    ├─ #callback (OAuthコールバック)
    │      ├─ auth_state 検証
    │      ├─ get_token でアクセストークン取得
    │      └─ セッションに保存 → status_import_url へリダイレクト
    │
    └─ #personal_access_token (PAT認証)
           ├─ PAT をセッションに保存
           └─ status_import_url へリダイレクト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OAuth認証 ───▶ GitHub OAuth Server ───▶ Callback
                    │
                    ▼
             アクセストークン取得
                    │
                    ▼
             セッションに保存 ───▶ status画面

PAT入力 ───▶ personal_access_token アクション
                    │
                    ▼
             セッションに保存 ───▶ status画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/import/github/new.html.haml` | テンプレート | 認証画面のビュー |
| github_controller.rb | `app/controllers/import/github_controller.rb` | コントローラー | GitHubインポートコントローラー |
| github_oauth.rb | `app/controllers/concerns/import/github_oauth.rb` | Concern | OAuth連携処理 |
| import.rb | `config/routes/import.rb` | 設定 | ルーティング定義 |
| import_helper.rb | `app/helpers/import_helper.rb` | ヘルパー | インポートヘルパー |
