# 画面設計書 286-GitHubインポート状態

## 概要

本ドキュメントは、GitLabのGitHubインポート状態画面の設計を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：GitHubインポート状態画面は、ユーザーがGitHubからインポート可能なリポジトリを一覧表示し、インポート対象を選択・実行するための画面である。GitHubからGitLabへの移行作業において、どのリポジトリをインポートするか選択し、インポート進捗を確認するという業務ニーズに対応する。

**画面へのアクセス方法**：GitHubインポート認証画面（new）から認証成功後に自動的に遷移する。または直接 `/import/github/status` にアクセスする（認証済みの場合）。

**主要な操作・処理内容**：
1. GitHubリポジトリの一覧を表示する
2. リポジトリを検索・フィルタリングする
3. インポート先のネームスペースを選択する
4. プロジェクト名を変更する（任意）
5. オプションのインポートステージを選択する
6. 個別リポジトリまたは一括でインポートを開始する
7. インポート進捗をリアルタイムで確認する
8. インポート済みプロジェクトを表示する
9. インポートをキャンセルする

**画面遷移**：
- 遷移元：GitHubインポート認証画面
- 遷移先：GitHubインポート詳細画面、プロジェクト詳細画面（インポート完了時）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- namespace_id 指定時、そのネームスペースへのインポート権限が必要
- ユーザーのネームスペース選択権限（can_select_namespace）に応じた表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | GitHubインポート状態の表示と実行 |

## 画面種別

一覧 / 操作

## URL/ルーティング

| メソッド | パス | コントローラー#アクション | 説明 |
|----------|------|---------------------------|------|
| GET | `/import/github/status` | `import/github#status` | 状態画面表示（HTML） |
| GET | `/import/github/status.json` | `import/github#status` | リポジトリ一覧取得（JSON） |
| POST | `/import/github` | `import/github#create` | インポート開始 |
| GET | `/import/github/realtime_changes.json` | `import/github#realtime_changes` | 進捗更新取得 |
| POST | `/import/github/cancel` | `import/github#cancel` | インポートキャンセル |
| POST | `/import/github/cancel_all` | `import/github#cancel_all` | 全キャンセル |
| GET | `/import/github/counts` | `import/github#counts` | リポジトリ件数取得 |

## 入出力項目

### リポジトリ一覧取得（status.json）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| フィルタ | filter | String | No | リポジトリ名フィルタ |
| ページ（before） | before | String | No | ページネーションカーソル（前） |
| ページ（after） | after | String | No | ページネーションカーソル（後） |
| 関係タイプ | relation_type | String | No | owned/collaborated/organization |
| 組織ログイン名 | organization_login | String | No | 組織リポジトリ取得時 |

### インポート開始（create）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| リポジトリID | repo_id | Integer | Yes | GitHubリポジトリID |
| 新しい名前 | new_name | String | No | インポート後のプロジェクト名 |
| ターゲットネームスペース | target_namespace | String | Yes | インポート先ネームスペースパス |
| オプションステージ | optional_stages | Hash | No | オプションのインポートステージ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Import repositories from GitHub」 |
| GitHubアイコン | GitHubロゴの表示 |
| リポジトリ一覧 | インポート可能なリポジトリリスト |
| インポート済み一覧 | 既にインポートされたプロジェクト |
| 検索ボックス | リポジトリ名でフィルタリング |
| 関係タイプフィルタ | owned/collaborated/organization切り替え |
| ネームスペース選択 | インポート先の選択ドロップダウン |
| プロジェクト名入力 | インポート後の名前指定 |
| インポートボタン | 個別インポート開始ボタン |
| 進捗表示 | インポート中のステータス表示 |
| ページネーション | リポジトリ一覧のページ切り替え |
| オプションステージ | インポートオプションの選択 |

## イベント仕様

### 1-インポートボタン押下

**トリガー**：リポジトリ行の「Import」ボタンをクリック

**処理フロー**：
1. フォームバリデーション
2. `POST /import/github` を呼び出し
3. Import::GithubService.execute を実行
4. 成功時：インポート開始、進捗表示に切り替え
5. 失敗時：エラーメッセージを表示

### 2-リアルタイム進捗更新

**トリガー**：3秒間隔のポーリング

**処理フロー**：
1. `GET /import/github/realtime_changes.json` を呼び出し
2. インポート中プロジェクトの状態を取得
3. UI上の進捗表示を更新
4. 完了/失敗時は「Go to project」リンクを表示

### 3-キャンセル操作

**トリガー**：「Cancel」ボタンをクリック

**処理フロー**：
1. `POST /import/github/cancel` を呼び出し
2. Import::Github::CancelProjectImportService を実行
3. インポートジョブをキャンセル
4. ステータスを更新

### 4-フィルタリング

**トリガー**：検索ボックスに入力または関係タイプ変更

**処理フロー**：
1. フィルタ条件でAPIを再取得
2. リポジトリ一覧を更新

### 5-ページネーション

**トリガー**：ページ切り替えボタンをクリック

**処理フロー**：
1. カーソルベースのページネーション
2. 次/前のページのリポジトリを取得
3. 一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インポート開始 | projects | INSERT | プロジェクトレコード作成 |
| インポート開始 | import_states | INSERT | インポート状態作成 |
| インポート開始 | namespaces | - | ネームスペース検証 |
| インポート進行中 | import_states | UPDATE | 状態更新 |
| インポートキャンセル | import_states | UPDATE | 状態をキャンセルに更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | new_name または GitHubリポジトリ名 | |
| INSERT | path | name から生成 | |
| INSERT | namespace_id | target_namespace から取得 | |
| INSERT | import_type | 'github' | |
| INSERT | import_url | GitHubリポジトリURL | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | (ステータスアイコン表示) | インポート完了時 |
| MSG002 | 進行中 | Importing... | インポート中 |
| MSG003 | エラー | Import failed | インポート失敗時 |
| MSG004 | エラー | Invalid credentials | 認証失敗時（new画面にリダイレクト） |
| MSG005 | エラー | Rate limit exceeded | API制限時 |

## 例外処理

| 例外条件 | 画面表示・動作 |
|----------|---------------|
| 認証トークン無効 | new画面にリダイレクト、エラーメッセージ表示 |
| API制限超過 | レート制限エラー表示 |
| ネームスペースアクセス不可 | 404エラー |
| インポート失敗 | 失敗ステータス表示、詳細画面へのリンク |
| キャンセル失敗 | エラーメッセージ表示 |

## 備考

- ページあたり25件のリポジトリを表示（PAGE_LENGTH = 25）
- リアルタイム更新は3秒間隔（Gitlab::PollingInterval）
- オプションステージ：
  - コラボレーターのインポート
  - Pull Request Eventsのインポート
  - その他のオプションはGitlab::GithubImport::Settingsで定義
- 互換性のないリポジトリは別セクションに表示
- CI/CD連携のみモードもサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | github_controller.rb | `app/controllers/import/github_controller.rb` | status, create, realtime_changes, cancel アクション |

**主要処理フロー**:
1. **行50-67**: `status` アクションでHTML/JSON分岐
2. **行72-79**: `create` アクションでインポート実行
3. **行82-86**: `realtime_changes` でポーリング応答
4. **行101-109**: `cancel` でキャンセル処理

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | status.html.haml | `app/views/import/github/status.html.haml` | 状態画面の構造 |
| 2-2 | _githubish_status.html.haml | `app/views/import/_githubish_status.html.haml` | 共通ステータスパーシャル |

**主要データ属性**（_githubish_status）:
- `provider`: プロバイダ名（github）
- `repos_path`: リポジトリ取得API
- `jobs_path`: 進捗取得API
- `import_path`: インポート実行API
- `cancel_path`: キャンセルAPI
- `optional_stages`: オプションステージ設定

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | github_service.rb | `app/services/import/github_service.rb` | インポート実行サービス |
| 3-2 | cancel_project_import_service.rb | `app/services/import/github/cancel_project_import_service.rb` | キャンセルサービス |

### プログラム呼び出し階層図

```
Import::GithubController#status
    │
    ├─ format.html → 画面表示
    │      └─ _githubish_status パーシャル
    │             └─ Vue.js #import-projects-mount-element
    │
    └─ format.json → API応答
           ├─ serialized_imported_projects（インポート済み）
           ├─ serialized_provider_repos（GitHub repos）
           └─ page_info（ページネーション）

Import::GithubController#create
    │
    └─ Import::GithubService.new.execute
           ├─ Gitlab::GithubImport::ParallelScheduling
           └─ Project.create
                  └─ ImportState.create

Import::GithubController#realtime_changes
    │
    └─ Import::GithubRealtimeRepoSerializer
           └─ already_added_projects の状態を返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GitHub API ───▶ GithubController#status (JSON)
                    │
                    ├─ client_repos_response
                    │      └─ Gitlab::GithubImport::Clients::Proxy
                    │
                    └─ serialized_provider_repos ───▶ Vue.js表示

インポート要求 ───▶ GithubController#create
                    │
                    └─ Import::GithubService.execute
                           │
                           ├─ Project.create (DB)
                           └─ Sidekiq Job登録 ───▶ バックグラウンドインポート

ポーリング ───▶ GithubController#realtime_changes
                    │
                    └─ ImportState取得 ───▶ 進捗表示更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| status.html.haml | `app/views/import/github/status.html.haml` | テンプレート | 状態画面のビュー |
| _githubish_status.html.haml | `app/views/import/_githubish_status.html.haml` | テンプレート | 共通ステータスパーシャル |
| github_controller.rb | `app/controllers/import/github_controller.rb` | コントローラー | GitHubインポートコントローラー |
| github_service.rb | `app/services/import/github_service.rb` | サービス | インポート実行サービス |
| cancel_project_import_service.rb | `app/services/import/github/cancel_project_import_service.rb` | サービス | キャンセルサービス |
| proxy.rb | `lib/gitlab/github_import/clients/proxy.rb` | クライアント | GitHub APIプロキシ |
| settings.rb | `lib/gitlab/github_import/settings.rb` | 設定 | インポートオプション設定 |
