# 画面設計書 288-GitLabインポート状態

## 概要

本ドキュメントは、GitLabのGitLabインポート状態画面の設計を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：GitLabインポート状態画面は、ユーザーが他のGitLabインスタンス（主にGitLab.com）からインポート可能なプロジェクトを一覧表示し、インポート対象を選択・実行するための画面である。他のGitLabインスタンスからの移行作業において、どのプロジェクトをインポートするか選択し、インポート進捗を確認するという業務ニーズに対応する。

**画面へのアクセス方法**：新規プロジェクト作成画面（`/projects/new`）から「Import project」タブを選択し、「GitLab.com」を選択して認証後に自動的に遷移する。

**主要な操作・処理内容**：
1. GitLabインスタンスからのプロジェクト一覧を表示する
2. インポート先のネームスペースを選択する
3. プロジェクト名を変更する（任意）
4. 個別プロジェクトのインポートを開始する
5. インポート進捗をリアルタイムで確認する
6. インポート済みプロジェクトを表示する

**画面遷移**：
- 遷移元：GitLab認証画面、新規プロジェクト作成画面
- 遷移先：プロジェクト詳細画面（インポート完了時）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- ユーザーのネームスペース選択権限（can_select_namespace）に応じた表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | GitLabインポート | 主機能 | GitLabからのインポート状態の表示と実行 |

## 画面種別

一覧 / 操作

## URL/ルーティング

| メソッド | パス | コントローラー#アクション | 説明 |
|----------|------|---------------------------|------|
| GET | `/import/gitlab/status` | （パーシャル使用） | 状態画面表示（HTML） |
| GET | `/import/gitlab/status.json` | （パーシャル使用） | リポジトリ一覧取得（JSON） |
| POST | `/import/gitlab` | （パーシャル使用） | インポート開始 |
| GET | `/import/gitlab/realtime_changes.json` | （パーシャル使用） | 進捗更新取得 |

**注意**：本画面は `_githubish_status` パーシャルを使用しており、プロバイダ名 `gitlab` を指定することでGitHub系のインポートUIを再利用している。

## 入出力項目

### プロジェクト一覧取得（status.json）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| フィルタ | filter | String | No | プロジェクト名フィルタ（本画面では無効） |

### インポート開始

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| リポジトリID | repo_id | Integer | Yes | GitLabプロジェクトID |
| 新しい名前 | new_name | String | No | インポート後のプロジェクト名 |
| ターゲットネームスペース | target_namespace | String | Yes | インポート先ネームスペースパス |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Import projects from GitLab.com」 |
| GitLabアイコン | ハートアイコンの表示 |
| プロジェクト一覧 | インポート可能なプロジェクトリスト |
| インポート済み一覧 | 既にインポートされたプロジェクト |
| ネームスペース選択 | インポート先の選択ドロップダウン |
| プロジェクト名入力 | インポート後の名前指定 |
| インポートボタン | 個別インポート開始ボタン |
| 進捗表示 | インポート中のステータス表示 |

## イベント仕様

### 1-インポートボタン押下

**トリガー**：プロジェクト行の「Import」ボタンをクリック

**処理フロー**：
1. フォームバリデーション
2. `POST /import/gitlab` を呼び出し
3. インポートサービスを実行
4. 成功時：インポート開始、進捗表示に切り替え
5. 失敗時：エラーメッセージを表示

### 2-リアルタイム進捗更新

**トリガー**：3秒間隔のポーリング

**処理フロー**：
1. `GET /import/gitlab/realtime_changes.json` を呼び出し
2. インポート中プロジェクトの状態を取得
3. UI上の進捗表示を更新
4. 完了/失敗時は「Go to project」リンクを表示

### 3-ネームスペース選択

**トリガー**：ネームスペースドロップダウンで選択

**処理フロー**：
1. 選択されたネームスペースをフォームに設定
2. プロジェクト名の重複チェック（GraphQL）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インポート開始 | projects | INSERT | プロジェクトレコード作成 |
| インポート開始 | import_states | INSERT | インポート状態作成 |
| インポート開始 | namespaces | - | ネームスペース検証 |
| インポート進行中 | import_states | UPDATE | 状態更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | new_name または GitLabプロジェクト名 | |
| INSERT | path | name から生成 | |
| INSERT | namespace_id | target_namespace から取得 | |
| INSERT | import_type | 'gitlab' | |
| INSERT | import_url | GitLabプロジェクトURL | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | (ステータスアイコン表示) | インポート完了時 |
| MSG002 | 進行中 | Importing... | インポート中 |
| MSG003 | エラー | Import failed | インポート失敗時 |
| MSG004 | エラー | Invalid credentials | 認証失敗時 |

## 例外処理

| 例外条件 | 画面表示・動作 |
|----------|---------------|
| 認証トークン無効 | 認証画面にリダイレクト、エラーメッセージ表示 |
| ネームスペースアクセス不可 | 404エラー |
| インポート失敗 | 失敗ステータス表示 |
| サーバー接続エラー | エラーメッセージ表示 |

## 備考

- リアルタイム更新は3秒間隔（Gitlab::PollingInterval）
- フィルタリング機能は無効（filterable: false）
- ページネーション機能は無効（paginatable: false）
- `_githubish_status` パーシャルを再利用
- GitLab.comからのインポートはバルクインポート（bulk_imports）も利用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | status.html.haml | `app/views/import/gitlab/status.html.haml` | 状態画面の構造 |
| 1-2 | _githubish_status.html.haml | `app/views/import/_githubish_status.html.haml` | 共通ステータスパーシャル |

**status.html.hamlの構造**（行1-6）:
- `page_title`: 「GitLab.com import」
- ハートアイコン表示
- 「Import projects from GitLab.com」見出し
- `_githubish_status` パーシャルを `provider: 'gitlab'` で呼び出し
- `filterable: false` でフィルタリング無効

**_githubish_statusパーシャルの主要データ属性**:
- `provider`: プロバイダ名（gitlab）
- `repos_path`: プロジェクト取得API
- `jobs_path`: 進捗取得API
- `import_path`: インポート実行API
- `default_target_namespace`: デフォルトのインポート先

#### Step 2: Vue.jsコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.js | `app/assets/javascripts/import_entities/import_projects/index.js` | エントリーポイント |
| 2-2 | import_projects_table.vue | `app/assets/javascripts/import_entities/import_projects/components/import_projects_table.vue` | テーブルコンポーネント |
| 2-3 | store/index.js | `app/assets/javascripts/import_entities/import_projects/store/index.js` | Vuexストア |

**Vue.jsの主要機能**:
- `initStoreFromElement`: データ属性からVuexストアを初期化
- `initPropsFromElement`: データ属性からPropsを初期化
- ポーリングによるリアルタイム更新

#### Step 3: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bulk_imports_controller.rb | `app/controllers/import/bulk_imports_controller.rb` | バルクインポートコントローラー（参考） |

**バルクインポートの関連**:
- GitLab.comからのインポートは bulk_imports も利用可能
- `configure` アクションでトークン設定
- `status` アクションで一覧取得
- `create` アクションでインポート実行
- `realtime_changes` で進捗取得

### プログラム呼び出し階層図

```
/import/gitlab/status (HTML)
    │
    └─ status.html.haml
           │
           └─ _githubish_status パーシャル
                  │
                  └─ #import-projects-mount-element
                         │
                         └─ Vue.js ImportProjectsTable
                                │
                                ├─ プロジェクト一覧表示
                                ├─ インポート実行
                                └─ ポーリング更新

/import/gitlab/status.json
    │
    └─ プロジェクト一覧API
           │
           └─ シリアライズしてJSON応答

/import/gitlab (POST)
    │
    └─ インポートサービス実行
           │
           ├─ Project.create
           └─ ImportState.create

/import/gitlab/realtime_changes.json
    │
    └─ インポート状態取得
           │
           └─ 進捗情報をJSON応答
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GitLab API ───▶ status.json
                    │
                    └─ プロジェクト一覧取得 ───▶ Vue.js表示

インポート要求 ───▶ POST /import/gitlab
                    │
                    └─ インポートサービス
                           │
                           ├─ Project.create (DB)
                           └─ Sidekiq Job登録 ───▶ バックグラウンドインポート

ポーリング ───▶ realtime_changes.json
                    │
                    └─ ImportState取得 ───▶ 進捗表示更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| status.html.haml | `app/views/import/gitlab/status.html.haml` | テンプレート | 状態画面のビュー |
| _githubish_status.html.haml | `app/views/import/_githubish_status.html.haml` | テンプレート | 共通ステータスパーシャル |
| index.js | `app/assets/javascripts/import_entities/import_projects/index.js` | JavaScript | Vue.jsエントリーポイント |
| import_projects_table.vue | `app/assets/javascripts/import_entities/import_projects/components/import_projects_table.vue` | Vue | テーブルコンポーネント |
| store/index.js | `app/assets/javascripts/import_entities/import_projects/store/index.js` | JavaScript | Vuexストア |
| store/actions.js | `app/assets/javascripts/import_entities/import_projects/store/actions.js` | JavaScript | Vuexアクション |
| bulk_imports_controller.rb | `app/controllers/import/bulk_imports_controller.rb` | コントローラー | バルクインポートコントローラー |
