# 画面設計書 289-Giteaインポート

## 概要

本ドキュメントは、GitLabのGiteaインポート開始画面の設計を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：Giteaインポート機能は、GiteaサーバーからGitLabへプロジェクトを移行するための機能である。本画面は、ユーザーがGiteaサーバーのホストURLと個人アクセストークンを入力し、インポートを開始するための入口となる画面であり、Giteaサーバーからの移行を検討している開発チームのニーズに対応する。

**画面へのアクセス方法**：新規プロジェクト作成画面（`/projects/new`）から「Import project」タブを選択し、「Gitea」を選択する。または直接 `/import/gitea/new` にアクセスする。

**主要な操作・処理内容**：
1. GiteaサーバーのホストURLを入力する
2. 個人アクセストークン（PAT）を入力する
3. 認証後、リポジトリ選択画面（status画面）に遷移する

**画面遷移**：
- 遷移元：新規プロジェクト作成画面、インポートプロジェクト選択画面
- 遷移先：Giteaインポート状態画面（認証成功時）、新規プロジェクト作成画面（キャンセル時）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- Giteaインポート機能が有効化されている必要がある
- namespace_id が指定された場合、そのネームスペースへのインポート権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | Giteaからのインポート開始（GitHubインポート機能を継承） |

## 画面種別

認証 / 入力

## URL/ルーティング

| メソッド | パス | コントローラー#アクション | 説明 |
|----------|------|---------------------------|------|
| GET | `/import/gitea/new` | `import/gitea#new` | 認証画面表示 |
| POST | `/import/gitea/personal_access_token` | `import/gitea#personal_access_token` | PAT認証 |

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| GiteaホストURL | gitea_host_url | String | Yes | GiteaサーバーのURL（例: https://gitea.com） |
| 個人アクセストークン | personal_access_token | String | Yes | Giteaの個人アクセストークン |
| ネームスペースID | namespace_id | Integer | No | インポート先ネームスペース |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Gitea import」 |
| Giteaアイコン | Giteaロゴの表示 |
| 説明文 | ホストURLとPATの入力説明 |
| ホストURL入力欄 | GiteaサーバーのURLを入力 |
| PAT入力欄 | 個人アクセストークンの入力フィールド |
| 認証ボタン | 「List your Gitea repositories」ボタン |

## イベント仕様

### 1-認証ボタン押下

**トリガー**：「List your Gitea repositories」ボタンをクリック

**処理フロー**：
1. フォームバリデーション（ホストURLとPATの両方が入力されていること）
2. `POST /import/gitea/personal_access_token` を呼び出し
3. ホストURLとPATをセッションに保存
4. URL検証（ブロックされたURLでないこと）
5. status画面へリダイレクト
6. status画面でPATの有効性を検証

### 2-キャンセル操作

**トリガー**：ブラウザの戻るボタンまたはパンくずリスト

**処理フロー**：
1. 新規プロジェクト作成画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認証操作 | - | - | セッションのみ使用、DB更新なし |

### 備考

認証情報はセッションに保存される。データベースへの書き込みはインポート実行時に発生する。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | To get started, please enter your Gitea host URL and a personal access token. | PAT入力欄の説明 |
| MSG002 | エラー | You need to specify both an access token and a Host URL. | 入力不足時 |
| MSG003 | エラー | Specified URL cannot be used: "%{reason}" | URLブロック時 |

## 例外処理

| 例外条件 | 画面表示・動作 |
|----------|---------------|
| Giteaインポート無効 | 404エラー |
| ホストURLまたはPAT未入力 | エラーメッセージを表示、new画面にリダイレクト |
| ブロックされたURL | エラーメッセージを表示、new画面にリダイレクト |
| ローカルネットワーク禁止 | URLブロックエラー（設定により許可可能） |

## 備考

- GiteaはOAuth認証をサポートしていない（個人アクセストークンのみ）
- ホストURLはHTTPSが推奨
- ローカルリクエストは `allow_local_requests_from_web_hooks_and_services` 設定に依存
- URL検証で `Gitlab::HTTP_V2::UrlBlocker` を使用
- Feature Flag `new_project_creation_form` が有効な場合、Vue.jsコンポーネントが使用される
- GiteaControllerはGithubControllerを継承している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

認証フローのエントリーポイントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gitea_controller.rb | `app/controllers/import/gitea_controller.rb` | new, personal_access_token アクション |
| 1-2 | github_controller.rb | `app/controllers/import/github_controller.rb` | 親クラスの実装 |

**主要処理フロー**:
1. **行10-12**: `new` アクションでセッション確認、認証済みならstatusへリダイレクト
2. **行14-17**: `personal_access_token` アクションでホストURLとPATを保存
3. **行50-53**: `provider_url` でセッションからホストURLを取得
4. **行57-60**: `logged_in_with_provider?` は常にfalse（OAuth非対応）
5. **行62-68**: `provider_auth` でトークンとURLの両方をチェック
6. **行94-107**: `verify_blocked_uri` でURL検証

#### Step 2: ビューテンプレートを理解する

画面表示の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/import/gitea/new.html.haml` | 入力フォームの構造 |

**主要要素**（行1-35）:
- Feature Flagによるレンダリング分岐
- Vue.jsマウントポイント `#js-vue-import-gitea-project-root`
- Giteaアイコン表示
- ホストURL入力フィールド
- PAT入力フィールド
- 「List your Gitea repositories」ボタン

#### Step 3: ルーティングを理解する

URLパターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | import.rb | `config/routes/import.rb` | giteaルーティング定義 |

**ルーティング**（行31-35）:
- `resource :gitea, only: [:create, :new], controller: :gitea`
- `post :personal_access_token`
- `get :status`
- `get :realtime_changes`

### プログラム呼び出し階層図

```
Import::GiteaController (< Import::GithubController)
    │
    ├─ #new
    │      ├─ session[access_token_key] 確認
    │      ├─ provider_url 確認
    │      └─ 両方あり → status_import_url へリダイレクト
    │
    └─ #personal_access_token
           ├─ session[host_key] = params[:gitea_host_url]
           ├─ super (親クラスのPAT保存処理)
           │      └─ session[access_token_key] = params[:personal_access_token]
           └─ verify_blocked_uri
                  │
                  ├─ OK → status_import_url へリダイレクト
                  └─ NG → new画面にエラー表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ホストURL入力 ───▶ personal_access_token アクション
PAT入力                   │
                         ▼
                  session[host_key] に保存
                  session[access_token_key] に保存
                         │
                         ▼
                  verify_blocked_uri
                         │
                         ├─ OK ───▶ status画面
                         └─ NG ───▶ new画面 + エラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/import/gitea/new.html.haml` | テンプレート | 認証画面のビュー |
| gitea_controller.rb | `app/controllers/import/gitea_controller.rb` | コントローラー | Giteaインポートコントローラー |
| github_controller.rb | `app/controllers/import/github_controller.rb` | コントローラー | 親クラス |
| import.rb | `config/routes/import.rb` | 設定 | ルーティング定義 |
| url_blocker.rb | `lib/gitlab/http_v2/url_blocker.rb` | ライブラリ | URL検証 |
