# 画面設計書 291-Bitbucket Serverインポート

## 概要

本ドキュメントは、GitLabにおけるBitbucket Serverからのプロジェクトインポート開始画面の設計を記載したものである。

### 本画面の処理概要

Bitbucket Serverからプロジェクトをインポートするための接続設定画面である。ユーザーはBitbucket ServerのURL、ユーザー名、パスワード/パーソナルアクセストークンを入力し、認証後にリポジトリ一覧を取得できる。

**業務上の目的・背景**：組織がBitbucket Serverで管理しているリポジトリをGitLabに移行する際に利用する。Bitbucket Serverは自己ホスト型のGitリポジトリ管理ツールであり、企業がオンプレミス環境でソースコード管理を行う場合に広く使用されている。GitLabへの移行により、CI/CD機能の統合やDevOpsワークフローの改善が期待できる。

**画面へのアクセス方法**：
1. サイドバーまたはヘッダーから「プロジェクト新規作成」を選択
2. 「Import project」タブを選択
3. 「Bitbucket Server」を選択して本画面にアクセス

**主要な操作・処理内容**：
1. Bitbucket Server URLの入力（例：https://your-bitbucket-server）
2. Bitbucket Serverのユーザー名の入力
3. パスワードまたはパーソナルアクセストークンの入力
4. 「List your Bitbucket Server repositories」ボタンで認証・接続を実行
5. 認証成功後、インポート状態画面へリダイレクト

**画面遷移**：
- 遷移元：プロジェクト新規作成画面（インポート選択）
- 遷移先：Bitbucket Serverインポート状態画面（No.292）

**権限による表示制御**：
- プロジェクト作成権限を持つユーザーのみがアクセス可能
- namespace_idパラメータが指定された場合、そのネームスペースへのインポート権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 107 | Bitbucketインポート | 主機能 | Bitbucket Serverからのインポート開始処理 |

## 画面種別

登録（設定入力）

## URL/ルーティング

```
GET /import/bitbucket_server/new
POST /import/bitbucket_server/configure
```

ルーティング定義: `config/routes/import.rb`
```ruby
resource :bitbucket_server, only: [:create, :new], controller: :bitbucket_server do
  post :configure
  get :status
  get :callback
  get :realtime_changes
end
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Bitbucket Server URL | bitbucket_server_url | URL | 必須 | Bitbucket ServerのベースURL |
| ユーザー名 | bitbucket_server_username | 文字列 | 必須 | Bitbucket Serverのユーザー名 |
| パスワード/PAT | personal_access_token | パスワード | 必須 | パスワードまたはパーソナルアクセストークン |
| ネームスペースID | namespace_id | 整数 | 任意 | インポート先のネームスペースID |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Bitbucket Server Import」 |
| フォームタイトル | 「Import repositories from Bitbucket Server」 |
| フォーム説明 | 「Enter in your Bitbucket Server URL and personal access token below」 |
| Bitbucketアイコン | Bitbucketロゴアイコン |

## イベント仕様

### 1-送信ボタン押下

「List your Bitbucket Server repositories」ボタンを押下すると以下の処理が実行される：

1. フォームバリデーション実行
2. POSTリクエストを`/import/bitbucket_server/configure`に送信
3. コントローラーで以下の処理：
   - セッションにURL、ユーザー名、トークンを保存
   - Bitbucket Serverインポート状態画面へリダイレクト

```ruby
# app/controllers/import/bitbucket_server_controller.rb (行57-63)
def configure
  session[personal_access_token_key] = params[:personal_access_token]
  session[bitbucket_server_username_key] = params[:bitbucket_server_username]
  session[bitbucket_server_url_key] = params[:bitbucket_server_url]

  redirect_to status_import_bitbucket_server_path(namespace_id: params[:namespace_id])
end
```

### 2-Vueフォーム送信（Feature Flag有効時）

Feature Flag `new_project_creation_form` が有効な場合、Vue.jsコンポーネントが使用される：

1. フォーム入力値のバリデーション
2. バリデーション成功時にフォームを送信
3. URL、ユーザー名、トークンの形式チェック

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| configure | - | - | 本画面ではDBへの書き込みは発生しない。セッションへの保存のみ |

### テーブル別更新項目詳細

本画面ではセッションストレージのみ使用し、データベース更新は発生しない。

セッションに保存される値：
- `bitbucket_server_url`: Bitbucket ServerのURL
- `bitbucket_server_username`: ユーザー名
- `bitbucket_server_personal_access_token`: パーソナルアクセストークン

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG001 | エラー | Unable to connect to server: {error} | Bitbucket Server接続エラー時 |
| MSG002 | バリデーション | Please enter a valid Bitbucket Server URL. | URL形式不正時（Vueコンポーネント） |
| MSG003 | バリデーション | Please enter a valid username. | ユーザー名未入力時（Vueコンポーネント） |
| MSG004 | バリデーション | Please enter a valid token. | トークン未入力時（Vueコンポーネント） |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| Bitbucket Server接続エラー | エラーメッセージを表示し、セッションデータをクリアして本画面にリダイレクト |
| インポート機能無効 | 404エラーページを表示 |
| 認証失敗 | エラーメッセージを表示し、再入力を促す |

## 備考

- Feature Flag `new_project_creation_form` によりUIが切り替わる
- Bitbucket Serverは自己ホスト型のため、URLは組織ごとに異なる
- パーソナルアクセストークンはBitbucket Serverの設定画面で発行可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セッションに保存される認証情報とパラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bitbucket_server_controller.rb | `app/controllers/import/bitbucket_server_controller.rb` | セッションキーの定義（行141-151）とcredentialsメソッド（行159-165） |

**読解のコツ**: セッションキーはprivateメソッドとして定義されており、認証情報の管理方法を理解することが重要。

#### Step 2: エントリーポイントを理解する

リクエストを受け付けるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | import.rb | `config/routes/import.rb` | Bitbucket Server関連ルーティング（行43-48） |
| 2-2 | bitbucket_server_controller.rb | `app/controllers/import/bitbucket_server_controller.rb` | newアクション（行30）、configureアクション（行57-63） |

**主要処理フロー**:
1. **行30**: `new`アクション - 初期表示
2. **行57-63**: `configure`アクション - 認証情報をセッションに保存してリダイレクト

#### Step 3: ビューレイヤーを理解する

画面表示の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/import/bitbucket_server/new.html.haml` | Feature Flagによる分岐（行5-31） |
| 3-2 | import_from_bitbucket_server_app.vue | `app/assets/javascripts/import/bitbucket_server/import_from_bitbucket_server_app.vue` | Vueコンポーネントの実装 |

**主要処理フロー**:
- **行5-9**: Feature Flag有効時はVueコンポーネントをマウント
- **行10-31**: Feature Flag無効時は従来のHAMLフォームを表示

#### Step 4: バリデーション・認証処理を理解する

認証情報の検証処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bitbucket_server_controller.rb | `app/controllers/import/bitbucket_server_controller.rb` | bitbucket_authメソッド（行129-135）、接続エラーハンドリング（行175-189） |

### プログラム呼び出し階層図

```
GET /import/bitbucket_server/new
    │
    └─ Import::BitbucketServerController#new
           └─ app/views/import/bitbucket_server/new.html.haml
                  │
                  ├─ [Feature Flag ON]
                  │      └─ import_from_bitbucket_server_app.vue
                  │
                  └─ [Feature Flag OFF]
                         └─ HAMLフォーム直接レンダリング

POST /import/bitbucket_server/configure
    │
    └─ Import::BitbucketServerController#configure
           │
           ├─ セッションに認証情報を保存
           │
           └─ redirect_to status_import_bitbucket_server_path
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URL, Username,     ───▶  BitbucketServerController   ───▶  セッション保存
Personal Access          #configure                        │
Token                                                      │
                                                           ▼
                                                     状態画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bitbucket_server_controller.rb | `app/controllers/import/bitbucket_server_controller.rb` | コントローラー | リクエスト処理・認証管理 |
| new.html.haml | `app/views/import/bitbucket_server/new.html.haml` | テンプレート | 画面表示 |
| import_from_bitbucket_server_app.vue | `app/assets/javascripts/import/bitbucket_server/import_from_bitbucket_server_app.vue` | Vueコンポーネント | 新UIフォーム |
| import.rb | `config/routes/import.rb` | ルーティング | URLルーティング定義 |
| base_controller.rb | `app/controllers/import/base_controller.rb` | コントローラー | インポート系コントローラーの基底クラス |
