# 画面設計書 296-Fogbugzインポート

## 概要

本ドキュメントは、GitLabにおけるFogBugzからのプロジェクトインポート開始画面の設計を記載したものである。

### 本画面の処理概要

FogBugzのURL、メールアドレス、パスワードを入力し、FogBugzと接続してプロジェクト（ケース）をGitLabにインポートするための認証画面である。認証成功後、ユーザーマッピング設定画面へ遷移する。

**業務上の目的・背景**：FogBugzはFog Creek Software（現Glitch）が開発したバグ追跡・プロジェクト管理ツールである。FogBugzからGitLabへの移行時に、既存のケース（Issue）やプロジェクト情報をインポートするために使用する。FogBugzユーザーをGitLabユーザーにマッピングすることで、移行後もコメント作成者等の情報を保持できる。

**画面へのアクセス方法**：
1. サイドバーまたはヘッダーから「プロジェクト新規作成」を選択
2. 「Import project」タブを選択
3. 「FogBugz」を選択して本画面にアクセス

**主要な操作・処理内容**：
1. FogBugz URLの入力（例：https://mycompany.fogbugz.com）
2. FogBugzアカウントのメールアドレス入力
3. FogBugzアカウントのパスワード入力
4. 「Continue to the next step」ボタンで認証・接続を実行
5. 認証成功後、ユーザーマッピング画面へリダイレクト

**画面遷移**：
- 遷移元：プロジェクト新規作成画面（インポート選択）
- 遷移先：Fogbugzユーザーマッピング画面（No.297）

**権限による表示制御**：
- プロジェクト作成権限を持つユーザーのみがアクセス可能
- レート制限が適用される（fogbugz_import）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | FogBugzからのインポート開始処理 |

## 画面種別

登録（設定入力）

## URL/ルーティング

```
GET /import/fogbugz/new
POST /import/fogbugz/callback
```

ルーティング定義: `config/routes/import.rb`
```ruby
resource :fogbugz, only: [:create, :new], controller: :fogbugz do
  get :status
  post :callback
  get :realtime_changes

  get   :new_user_map,    path: :user_map
  post  :create_user_map, path: :user_map
end
```

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| FogBugz URL | uri | URL | 必須 | FogBugzのベースURL |
| メールアドレス | email | 文字列 | 必須 | FogBugzアカウントのメールアドレス |
| パスワード | password | パスワード | 必須 | FogBugzアカウントのパスワード |
| ネームスペースID | namespace_id | 整数 | 任意 | インポート先のネームスペースID |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「FogBugz Import」 |
| FogBugzアイコン | バグアイコン（sprite_icon: 'bug'） |
| フォームタイトル | 「Import projects from FogBugz」 |
| フォーム説明 | 認証情報入力の説明テキスト |

## イベント仕様

### 1-送信ボタン押下

「Continue to the next step」ボタンを押下すると以下の処理が実行される：

```ruby
# app/controllers/import/fogbugz_controller.rb (行18-30)
def callback
  begin
    res = Gitlab::FogbugzImport::Client.new(import_params.to_h.symbolize_keys)
  rescue StandardError
    return redirect_to new_import_fogbugz_path(namespace_id: params[:namespace_id]),
      alert: _('Could not connect to FogBugz, check your URL')
  end
  session[:fogbugz_token] = res.get_token.to_s
  session[:fogbugz_uri] = params[:uri]

  redirect_to new_user_map_import_fogbugz_path(namespace_id: params[:namespace_id])
end
```

### 2-Vueフォーム送信（Feature Flag有効時）

Feature Flag `new_project_creation_form` が有効な場合、Vue.jsコンポーネントが使用される：

1. URL、メールアドレス、パスワードを入力
2. フォーム送信でPOSTリクエストを送信
3. 認証成功後、ユーザーマッピング画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| callback | - | - | 本画面ではDBへの書き込みは発生しない。セッションへの保存のみ |

### テーブル別更新項目詳細

本画面ではセッションストレージのみ使用し、データベース更新は発生しない。

セッションに保存される値：
- `fogbugz_token`: FogBugz APIトークン
- `fogbugz_uri`: FogBugzのURL

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG001 | エラー | Could not connect to FogBugz, check your URL | URL形式エラーまたは接続エラー時 |
| MSG002 | エラー | Specified URL cannot be used: "{reason}" | URLがブロックされている場合 |
| MSG003 | エラー | {authentication_error_message} | FogBugz認証エラー時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| インポート機能無効 | 404エラーページを表示 |
| URL接続エラー | エラーメッセージを表示して再入力を促す |
| 認証エラー（AuthenticationError） | エラーメッセージを表示して本画面へリダイレクト |
| URLブロック（BlockedUrlError） | エラーメッセージを表示して本画面へリダイレクト |
| レート制限超過 | エラーページを表示 |

## 備考

- Feature Flag `new_project_creation_form` によりUIが切り替わる
- URLブロックチェックでローカルネットワークアクセスを制限可能
- レート制限が適用される（fogbugz_import）
- FogBugz APIトークンはパスワードから取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セッションに保存される認証情報を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | セッション変数（行26-27）、client（行97-99） |

**読解のコツ**: FogBugzはトークンベース認証を使用。パスワードからトークンを取得してセッションに保存。

#### Step 2: エントリーポイントを理解する

newアクションとcallbackアクションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | new（行16）、callback（行18-30） |
| 2-2 | import.rb | `config/routes/import.rb` | FogBugz関連ルーティング（行50-57） |

**主要処理フロー**:
1. **行16**: `new`アクション - 初期表示
2. **行18-30**: `callback`アクション - FogBugz認証・トークン取得

#### Step 3: ビューレイヤーを理解する

画面表示の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/import/fogbugz/new.html.haml` | Feature Flagによる分岐 |
| 3-2 | import_from_fogbugz_app.vue | `app/assets/javascripts/import/fogbugz/import_from_fogbugz_app.vue` | Vueコンポーネント |

#### Step 4: セキュリティチェックを理解する

URLブロックとレート制限を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | verify_blocked_uri（行128-141）、レート制限（行9） |

### プログラム呼び出し階層図

```
GET /import/fogbugz/new
    │
    └─ Import::FogbugzController#new
           └─ app/views/import/fogbugz/new.html.haml
                  │
                  ├─ [Feature Flag ON]
                  │      └─ import_from_fogbugz_app.vue
                  │
                  └─ [Feature Flag OFF]
                         └─ HAMLフォーム直接レンダリング

POST /import/fogbugz/callback
    │
    └─ Import::FogbugzController#callback
           │
           ├─ check_rate_limit! (before_action)
           │
           ├─ verify_blocked_uri (before_action)
           │
           ├─ Gitlab::FogbugzImport::Client.new
           │      └─ get_token
           │
           └─ セッションに保存 → redirect_to user_map
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URL, Email,        ───▶  FogbugzImport::Client          ───▶  トークン取得
Password                  #get_token                          │
                                                              ▼
                                                         セッション保存
                                                              │
                                                              ▼
                                                         ユーザーマッピング
                                                         画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/import/fogbugz/new.html.haml` | テンプレート | 初期画面表示 |
| import_from_fogbugz_app.vue | `app/assets/javascripts/import/fogbugz/import_from_fogbugz_app.vue` | Vueコンポーネント | 新UIフォーム |
| import.rb | `config/routes/import.rb` | ルーティング | URLルーティング定義 |
| client.rb | `lib/gitlab/fogbugz_import/client.rb` | ライブラリ | FogBugz APIクライアント |
| base_controller.rb | `app/controllers/import/base_controller.rb` | コントローラー | 基底クラス |
