# 画面設計書 297-Fogbugzユーザーマッピング

## 概要

本ドキュメントは、GitLabにおけるFogBugzからのインポート時のユーザーマッピング設定画面の設計を記載したものである。

### 本画面の処理概要

FogBugzのユーザー情報をGitLabユーザーにマッピングするための設定画面である。FogBugzのケース（Issue）やコメントに含まれるユーザー情報を、インポート後にGitLabユーザーに関連付けるための設定を行う。

**業務上の目的・背景**：FogBugzからGitLabへの移行時、既存のケースやコメントに記録されたFogBugzユーザーを、対応するGitLabユーザーにマッピングすることで、移行後のデータの整合性を保つ。マッピングを設定しない場合は、FogBugzユーザーの名前が説明文に記載される。

**画面へのアクセス方法**：
1. FogBugzインポート画面（No.296）で認証情報を入力
2. 認証成功後、自動的に本画面へリダイレクト

**主要な操作・処理内容**：
1. FogBugzユーザーの一覧を表示
2. 各FogBugzユーザーの名前・メールアドレスを編集（オプション）
3. 各FogBugzユーザーに対応するGitLabユーザーを選択（オプション）
4. 「Continue to the next step」ボタンでマッピングを保存
5. マッピング保存後、FogBugzインポート状態画面へリダイレクト

**画面遷移**：
- 遷移元：FogBugzインポート画面（No.296）
- 遷移先：FogBugzインポート状態画面（No.298）

**権限による表示制御**：
- プロジェクト作成権限を持つユーザーのみがアクセス可能
- FogBugz認証済みのセッションが必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | FogBugzユーザーマッピング設定処理 |

## 画面種別

登録・編集

## URL/ルーティング

```
GET /import/fogbugz/user_map
POST /import/fogbugz/user_map
```

ルーティング定義: `config/routes/import.rb`
```ruby
resource :fogbugz, only: [:create, :new], controller: :fogbugz do
  get :status
  post :callback
  get :realtime_changes

  get   :new_user_map,    path: :user_map
  post  :create_user_map, path: :user_map
end
```

## 入出力項目

### 入力項目（ユーザーマッピング）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ユーザー名 | users[{id}][name] | 文字列 | 必須 | 表示名（FogBugzフルネームがデフォルト） |
| メールアドレス | users[{id}][email] | 文字列 | 任意 | メールアドレス |
| GitLabユーザー | users[{id}][gitlab_user] | 整数 | 任意 | マッピング先のGitLabユーザーID |
| ネームスペースID | namespace_id | 整数 | 任意 | インポート先のネームスペースID |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「User map, FogBugz import」 |
| FogBugzアイコン | バグアイコン（sprite_icon: 'bug'） |
| フォームタイトル | 「Import projects from FogBugz」 |
| マッピング説明 | マッピングの目的と使い方の説明 |
| ユーザーテーブル | FogBugzユーザーの一覧テーブル |

## イベント仕様

### 1-ユーザーマッピング保存

「Continue to the next step」ボタンを押下すると以下の処理が実行される：

```ruby
# app/controllers/import/fogbugz_controller.rb (行34-48)
def create_user_map
  user_map = user_map_params.to_h[:users]

  unless user_map.is_a?(Hash) && user_map.all? { |_k, v| !v[:name].blank? }
    flash.now[:alert] = _('All users must have a name.')

    return render 'new_user_map'
  end

  session[:fogbugz_user_map] = user_map

  flash[:notice] = _('The user map has been saved. Continue by selecting the projects you want to import.')

  redirect_to status_import_fogbugz_path(namespace_id: params[:namespace_id])
end
```

### 2-GitLabユーザー選択

GitLabユーザー選択フィールドは、JavaScript（`.js-gitlab-user`）でユーザー検索コンポーネントを初期化：

```haml
%td
  .js-gitlab-user{ data: { name: "users[#{id}][gitlab_user]" } }
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| create_user_map | - | - | 本画面ではDBへの書き込みは発生しない。セッションへの保存のみ |

### テーブル別更新項目詳細

本画面ではセッションストレージのみ使用し、データベース更新は発生しない。

セッションに保存される値：
- `fogbugz_user_map`: ユーザーマッピング情報（ユーザーID => {name, email, gitlab_user}）

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| MSG001 | エラー | All users must have a name. | いずれかのユーザーの名前が空の場合 |
| MSG002 | 成功 | The user map has been saved. Continue by selecting the projects you want to import. | マッピング保存成功時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|---------|
| FogBugzセッションがない | FogBugzインポート画面（No.296）へリダイレクト（client.valid?チェック） |
| ユーザー名が空 | エラーメッセージを表示して再入力を促す |

## 備考

- マッピングを設定しない場合、FogBugzユーザーの名前がIssue/コメントの説明文に「By {名前}」として記載される
- GitLabユーザーを選択した場合、「By @{username}」形式のリンクが生成され、Issue/コメントが選択ユーザーに関連付けられる
- ユーザーマッピングはオプションで、スキップしてインポート状態画面から直接リンクも可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーマップの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | user_map（行101-109）、user_map_params（行120-122） |

**読解のコツ**: user_mapはFogBugzユーザーID => {name, email, gitlab_user}の形式。セッションに保存済みの値がある場合はマージされる。

#### Step 2: エントリーポイントを理解する

new_user_mapアクションとcreate_user_mapアクションを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | new_user_map（行32）、create_user_map（行34-48） |
| 2-2 | import.rb | `config/routes/import.rb` | ユーザーマップルーティング（行55-56） |

**主要処理フロー**:
1. **行32**: `new_user_map`アクション - マッピング画面表示
2. **行34-48**: `create_user_map`アクション - マッピング保存

#### Step 3: ビューレイヤーを理解する

画面表示の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new_user_map.html.haml | `app/views/import/fogbugz/new_user_map.html.haml` | ユーザーテーブルのレンダリング |

**主要処理フロー**:
- **行26-40**: ユーザーごとにテーブル行を生成
- **行40**: `.js-gitlab-user`でGitLabユーザー選択コンポーネントをマウント

#### Step 4: バリデーション処理を理解する

ユーザー名の必須チェックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | create_user_map内のバリデーション（行37） |

### プログラム呼び出し階層図

```
GET /import/fogbugz/user_map
    │
    └─ Import::FogbugzController#new_user_map
           │
           ├─ user_map (before_action)
           │      └─ client.user_map + session[:fogbugz_user_map]
           │
           └─ app/views/import/fogbugz/new_user_map.html.haml
                  └─ @user_map.each でテーブル行生成

POST /import/fogbugz/user_map
    │
    └─ Import::FogbugzController#create_user_map
           │
           ├─ user_map (before_action)
           │
           ├─ user_map_params.to_h[:users]
           │
           ├─ バリデーション（全ユーザーにnameが必要）
           │
           ├─ session[:fogbugz_user_map] = user_map
           │
           └─ redirect_to status_import_fogbugz_path
```

### データフロー図

```
[入力]                    [処理]                              [出力]

FogBugz Client     ───▶  client.user_map              ───▶  @user_map
                                                              │
                                                              ▼
セッション保存済み ───▶  マージ処理                    ───▶  フォーム初期値
マッピング                                                    │
                                                              ▼
ユーザー入力       ───▶  create_user_map              ───▶  セッション保存
(name, email,            #バリデーション                       │
gitlab_user)                                                  ▼
                                                         状態画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fogbugz_controller.rb | `app/controllers/import/fogbugz_controller.rb` | コントローラー | リクエスト処理 |
| new_user_map.html.haml | `app/views/import/fogbugz/new_user_map.html.haml` | テンプレート | マッピング画面表示 |
| user_select.vue | `app/assets/javascripts/pages/import/fogbugz/new_user_map/components/user_select.vue` | Vueコンポーネント | GitLabユーザー選択 |
| import.rb | `config/routes/import.rb` | ルーティング | URLルーティング定義 |
| client.rb | `lib/gitlab/fogbugz_import/client.rb` | ライブラリ | FogBugz APIクライアント |
