# 画面設計書 3-パスワード変更画面

## 概要

本ドキュメントは、GitLabのパスワード変更画面の設計仕様を記載したものです。パスワードリセットメールのリンクからアクセスし、新しいパスワードを設定する画面です。

### 本画面の処理概要

**業務上の目的・背景**：パスワード変更画面は、パスワードリセット手続きの最終ステップとして、ユーザーが新しいパスワードを設定するための画面を提供します。リセットトークンによる認証を行い、セキュリティを確保しながらパスワードの更新を実現します。パスワード要件の検証により、弱いパスワードの設定を防止し、アカウントセキュリティを維持します。

**画面へのアクセス方法**：
- パスワードリセットメール内のリンクをクリック（トークン付きURL）
- 直接 `/users/password/edit?reset_password_token=xxx` URLにアクセス

**主要な操作・処理内容**：
1. 新しいパスワードの入力
2. パスワード確認の入力
3. パスワード要件の検証（複雑性チェック）
4. パスワードの更新処理
5. 更新完了後のログイン

**画面遷移**：
- 遷移元：パスワードリセットメールのリンク
- 遷移先：ログイン画面（パスワード変更成功時）、パスワードリセット画面（トークン期限切れ時）、メール確認再送画面

**権限による表示制御**：
- 有効なリセットトークンを持つユーザーのみがアクセス可能
- トークンが無効または期限切れの場合はエラーメッセージを表示
- 認証済みユーザーもアクセス可能（ログアウト不要）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | パスワード管理 | 主機能 | 新しいパスワードの設定処理 |

## 画面種別

編集フォーム

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/password/edit` | パスワード変更画面表示 |
| PUT | `/users/password` | パスワード更新処理 |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| リセットトークン | user[reset_password_token] | string | Yes | - | 隠しフィールド（メールリンクから取得） |
| 新しいパスワード | user[password] | string | Yes | 128 | 新しいパスワード |
| パスワード確認 | user[password_confirmation] | string | Yes | 128 | パスワード確認入力 |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| タイトル | 「Change your password」 | 常時表示 |
| 新しいパスワード入力 | パスワード入力欄 | 常時表示 |
| パスワード確認入力 | 確認用パスワード入力欄 | 常時表示 |
| パスワード要件リスト | パスワードの複雑性要件表示 | EE機能有効時 |
| Change your passwordボタン | パスワード変更実行ボタン | 常時表示 |
| 確認メール再送リンク | 確認メール再送画面へのリンク | 常時表示 |
| Sign inリンク | ログイン画面へのリンク | 常時表示 |
| エラーメッセージ | 入力エラー表示領域 | エラー発生時 |

## イベント仕様

### 1-Change your passwordボタン押下

**トリガー**: 「Change your password」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. パスワード複雑性検証
3. リセットトークン検証
4. パスワード一致検証
5. パスワード更新
6. 関連フラグのリセット
7. ログイン画面にリダイレクト

**成功時**: ログイン画面にリダイレクトし、成功メッセージを表示
**失敗時**: エラーメッセージを表示してフォームに戻る

### 2-確認メール再送リンククリック

**トリガー**: 「Request a new one」リンククリック

**処理**: メール確認再送画面（`/users/confirmation/new`）にリダイレクト

### 3-Sign inリンククリック

**トリガー**: 「Sign in」リンククリック

**処理**: ログイン画面（`/users/sign_in`）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パスワード変更成功 | users | UPDATE | パスワードと関連フラグ更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | encrypted_password | bcryptハッシュ化されたパスワード | Devise標準処理 |
| UPDATE | reset_password_token | NULL | トークンクリア |
| UPDATE | reset_password_sent_at | NULL | 送信日時クリア |
| UPDATE | password_automatically_set | false | 自動設定フラグをオフ |
| UPDATE | password_expires_at | NULL | パスワード有効期限クリア |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | 成功 | Your password has been changed successfully. | パスワード変更成功時 |
| MSG002 | エラー | Reset password token is invalid | トークン無効時 |
| MSG003 | エラー | Your password reset token has expired. | トークン期限切れ時 |
| MSG004 | エラー | Password can't be blank | パスワード未入力時 |
| MSG005 | エラー | Password confirmation doesn't match Password | パスワード不一致時 |
| MSG006 | エラー | Password is too short | パスワード短すぎ時 |
| MSG007 | ヒント | Didn't receive a confirmation email? Request a new one | 確認メール未受信時の案内 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| トークン無効 | エラーメッセージを表示してフォームに戻る |
| トークン期限切れ | パスワードリセット画面にリダイレクト（ユーザーのメールアドレスをパラメータで渡す） |
| パスワード不一致 | エラーメッセージを表示してフォームに戻る |
| パスワード要件未満 | エラーメッセージを表示してフォームに戻る |
| 弱いパスワード | 監査ログに記録し、エラーメッセージを表示 |

## 備考

- リセットトークンは隠しフィールドとしてフォームに埋め込まれる
- パスワード複雑性検証はJavaScriptでリアルタイムにフィードバック
- 弱いパスワードの設定試行は監査ログに記録される（EE機能）
- パスワード変更成功時に `password_automatically_set` と `password_expires_at` がリセットされる
- autocomplete="new-password" 属性によりブラウザのパスワード保存機能に対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワード更新に関連するユーザーモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | encrypted_password、reset_password_token、password_automatically_set属性 |

**読解のコツ**: Deviseの `:recoverable` モジュールがパスワードリセット機能を提供する。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | edit/updateアクション |

**主要処理フロー**:
1. **18-37行目**: `edit` アクション - トークン検証とページ表示
2. **40-51行目**: `update` アクション - パスワード更新処理
3. **43-45行目**: 成功時の `password_automatically_set` と `password_expires_at` リセット
4. **47-48行目**: 失敗時の監査ログ記録と弱パスワードトラッキング

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/devise/passwords/edit.html.haml` | フォーム構成、パスワード入力フィールド |

**主要処理フロー**:
- **1行目**: タブタイトル「Change your password」
- **5行目**: リセットトークンの隠しフィールド
- **6-8行目**: 新しいパスワード入力（複雑性検証クラス付き）
- **9行目**: パスワード要件リスト（EE機能）
- **10-12行目**: パスワード確認入力
- **17-20行目**: 確認メール再送リンクとサインインリンク

### プログラム呼び出し階層図

```
PasswordsController#update
    │
    ├─ Devise::PasswordsController#update (super)
    │      ├─ User.reset_password_by_token
    │      │      ├─ find_by_reset_password_token
    │      │      ├─ reset_password_period_valid?
    │      │      └─ reset_password
    │      │             └─ update(password: new_password)
    │      │
    │      └─ sign_in(resource) (if sign_in_after_reset_password)
    │
    ├─ resource.password_automatically_set = false
    │
    ├─ resource.password_expires_at = nil
    │
    └─ log_audit_reset_failure (失敗時)
           └─ track_weak_password_error
```

### データフロー図

```
[入力]                         [処理]                              [出力]

reset_password_token  ───▶ PasswordsController#update ───▶ リダイレクト
user[password]                │
user[password_confirmation]   │
                              ├─ User.reset_password_by_token
                              │      └─ users テーブル SELECT (トークン検証)
                              │
                              └─ reset_password
                                     └─ users テーブル UPDATE
                                        (encrypted_password, reset_password_token,
                                         password_automatically_set, password_expires_at)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワード変更処理の制御 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータとパスワード管理 |
| edit.html.haml | `app/views/devise/passwords/edit.html.haml` | ビュー | パスワード変更画面テンプレート |
| _tab_single.html.haml | `app/views/devise/shared/_tab_single.html.haml` | ビュー | タブタイトル表示パーシャル |
| _error_messages.html.haml | `app/views/devise/shared/_error_messages.html.haml` | ビュー | エラーメッセージ表示パーシャル |
| _sign_in_link.html.haml | `app/views/devise/shared/_sign_in_link.html.haml` | ビュー | ログインリンクパーシャル |
| _password_requirements_list.html.haml | `app/views/shared/_password_requirements_list.html.haml` | ビュー | パスワード要件表示（EE） |
