# 画面設計書 303-インポート履歴

## 概要

本ドキュメントは、GitLabの全インポート履歴一覧表示画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、ユーザーが実行したすべてのプロジェクトインポートの履歴を一覧表示する画面である。GitHub、GitLab、Bitbucket、Gitea、Fogbugz、Manifestなど、複数のインポートソースからのインポート履歴を統合的に確認できる。

**業務上の目的・背景**：GitLabでは複数のインポート方法（GitHub、GitLab、Bitbucket等）が提供されており、ユーザーは異なるタイミングで異なるソースからプロジェクトをインポートすることがある。本画面は、これらすべてのインポート履歴を一元的に管理・確認できるようにすることで、インポート作業の追跡と問題解決を支援する。

**画面へのアクセス方法**：
- 新規プロジェクト作成画面からリンクで遷移
- URLに直接アクセス（`/import/history`）

**主要な操作・処理内容**：
1. 過去のインポート履歴一覧の表示
2. インポートソース別のフィルタリング
3. インポート状態（成功/失敗/処理中）の確認
4. インポート先プロジェクトへのリンク

**画面遷移**：
- 遷移元：新規プロジェクト作成画面、各インポート画面
- 遷移先：インポート先プロジェクト詳細画面

**権限による表示制御**：
- ログインユーザー自身が実行したインポートのみ表示される
- 他のユーザーのインポート履歴は参照不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 110 | バルクインポート | 主機能 | インポート履歴一覧表示 |

## 画面種別

一覧画面

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET | `/import/history` | index | インポート履歴一覧表示 |

## 入出力項目

### 入力項目

本画面には入力項目はない。フィルタリング機能はフロントエンド（Vue.js）で実装される。

## 表示項目

### インポート履歴一覧

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| id | Integer | インポートID |
| source | String | インポートソース（github/gitlab/bitbucket等） |
| destination_project | String | インポート先プロジェクト名 |
| destination_namespace | String | インポート先名前空間 |
| status | String | 状態（pending/started/finished/failed） |
| created_at | DateTime | 作成日時 |
| imported_at | DateTime | インポート完了日時 |

## イベント仕様

### 1-プロジェクトへの遷移

インポート先プロジェクト名をクリックすると、該当プロジェクトの詳細画面に遷移する。

### 2-ソースフィルタリング

ドロップダウンまたはタブでインポートソースを選択すると、該当ソースのインポート履歴のみが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | project_import_data | SELECT | インポートデータ取得 |
| 画面表示 | projects | SELECT | プロジェクト情報取得 |

本画面は参照専用であり、データベースへの更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-303-001 | 通知 | Import history | ページタイトル |
| MSG-303-002 | 情報 | No import history found | インポート履歴がない場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 未ログイン | ログイン画面へリダイレクト |

## 備考

- 本画面はシンプルなVue.jsアプリケーションで構成されている
- GitLabロゴはアセットパスから取得される（`asset_url('gitlab_logo.png')`）
- 複数のインポートソースからの履歴を統合表示する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | インポート関連のメソッド・スコープ |
| 1-2 | project_import_data.rb | `app/models/project_import_data.rb` | インポートデータの保存構造 |

**読解のコツ**: プロジェクトのインポート状態は`import_status`カラムで管理されており、`import_state`関連メソッドで状態遷移を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | history_controller.rb | `app/controllers/import/history_controller.rb` | コントローラー定義 |

**主要処理フロー**:
- **行1-6**: 非常にシンプルなコントローラーで、feature_categoryのみ定義
- ビュー描画はデフォルトのindexアクションで行われる

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/import/history/index.html.haml` | Vue.jsマウントポイント |

**主要処理フロー**:
- **行1-2**: パンくずとページタイトルの設定
- **行4**: Vue.jsアプリのマウント、logoパスをdata属性で渡す

### プログラム呼び出し階層図

```
Import::HistoryController
    │
    └─ #index (GET)
           │
           └─ View: index.html.haml
                  │
                  └─ Vue.js #import-history-mount-element
                         └─ API経由でインポート履歴取得
```

### データフロー図

```
[入力]           [処理]                          [出力]

なし ───▶ Import::HistoryController#index ───▶ HTML描画
                      │
                      ▼
              View: index.html.haml
                      │
                      ▼
              Vue.js アプリマウント
                      │
                      ▼
              API呼び出し（フロントエンド）
                      │
                      ▼
              インポート履歴一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| history_controller.rb | `app/controllers/import/history_controller.rb` | コントローラー | 画面制御 |
| index.html.haml | `app/views/import/history/index.html.haml` | テンプレート | Vue.jsマウント用HTML |
| import.rb | `config/routes/import.rb` | ルーティング | URL定義（行13） |
