# 画面設計書 306-招待辞退

## 概要

本ドキュメントは、GitLabの招待辞退完了画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、プロジェクトまたはグループへの招待を辞退した後に表示される完了画面である。ユーザーが招待を辞退したことを確認し、招待者への通知が行われることを案内する。

**業務上の目的・背景**：招待辞退後に明確なフィードバックをユーザーに提供することで、操作が正常に完了したことを確認できるようにする。また、招待者への通知が行われることを事前に知らせることで、予期しないコミュニケーション上の問題を防ぐ。この画面は特に、未ログイン状態で招待を辞退した場合（メールリンクから直接辞退した場合）に表示される。

**画面へのアクセス方法**：
- 招待確認画面で「Decline」ボタンを押下した後、特定の条件下でこの画面にリダイレクトされる
- 条件：未ログイン かつ 招待が未知のユーザー宛て かつ 招待者が存在する場合

**主要な操作・処理内容**：
1. 辞退完了のメッセージ表示
2. 招待者への通知案内
3. ウィンドウを閉じる案内

**画面遷移**：
- 遷移元：招待確認画面（decline処理後）
- 遷移先：なし（終端画面）

**権限による表示制御**：
- 本画面は特定の条件下でのみ表示される
- ログイン済みユーザーは本画面ではなくダッシュボードにリダイレクトされる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 招待機能 | 主機能 | 招待辞退処理 |

## 画面種別

完了通知画面

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET/POST | `/-/invites/:id/decline` | decline | 招待辞退（この画面は条件付きで表示） |

## 入出力項目

### 入力項目

本画面に入力項目はない。

## 表示項目

### 完了メッセージ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| success_icon | SVG | 成功アイコン（check-circle） |
| title | String | 「You successfully declined the invitation」 |
| notification_message | String | 招待者への通知案内 |
| inviter_name | String | 招待者の名前 |
| close_message | String | ウィンドウを閉じる案内 |

## イベント仕様

本画面には操作可能なイベントはない。ユーザーはブラウザウィンドウを閉じることで操作を完了する。

## データベース更新仕様

本画面自体ではデータベース更新は行われない。辞退処理は招待確認画面のdeclineアクションで既に完了している。

### 前画面（declineアクション）での更新

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 辞退 | members | DELETE | メンバーレコード削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-306-001 | 通知 | Invitation declined | ページタイトル |
| MSG-306-002 | 成功 | You successfully declined the invitation | 常に表示 |
| MSG-306-003 | 情報 | We will notify %{inviter} that you declined their invitation to join GitLab. You will stop receiving reminders. | 常に表示 |
| MSG-306-004 | 案内 | You can now close this window. | 常に表示 |

## 例外処理

本画面は完了通知のみの画面であり、例外処理は発生しない。

## 備考

- この画面はミニマルレイアウト（`layout: 'minimal'`）で表示される
- 成功アイコンとして`check-circle`（サイズ48）が使用される
- 招待者名はサニタイズされて表示される（`sanitize_name`使用）
- この画面の表示条件は厳格であり、以下のすべてを満たす場合のみ表示される：
  1. 未ログイン状態（`!current_user`）
  2. 招待が未知のユーザー宛て（`member.invite_to_unknown_user?`）
  3. 招待者が存在する（`member.created_by`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | member.rb | `app/models/member.rb` | `invite_to_unknown_user?`メソッド、`created_by`関連 |

**読解のコツ**: `invite_to_unknown_user?`はユーザーIDがなく招待トークンがある状態を判定する。`created_by`は招待を作成したユーザーへの参照。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | invites_controller.rb | `app/controllers/invites_controller.rb` | declineアクション内の条件分岐 |

**主要処理フロー**:
1. **行40-41**: `decline`アクションで`member.decline_invite!`実行
2. **行42**: ミニマルレイアウト表示条件の確認
3. **行42**: `!current_user && member.invite_to_unknown_user? && member.created_by`

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | decline.html.haml | `app/views/invites/decline.html.haml` | シンプルな完了画面の構成 |

**主要処理フロー**:
- **行1**: ページタイトル設定
- **行3-4**: レスポンシブレイアウトとアイコン表示
- **行5**: 成功タイトル
- **行6-7**: 招待者への通知案内（`sanitize_name`でサニタイズ）
- **行8-9**: ウィンドウを閉じる案内

### プログラム呼び出し階層図

```
InvitesController#decline (POST)
    │
    ├─ member.decline_invite!
    │      └─ membersテーブルからレコード削除
    │
    └─ 条件分岐
           │
           ├─ !current_user && invite_to_unknown_user? && created_by
           │      └─ render layout: 'minimal' → decline.html.haml
           │
           ├─ current_user
           │      └─ redirect_to dashboard_projects_path
           │
           └─ else
                  └─ redirect_to new_user_session_path
```

### データフロー図

```
[入力]                       [処理]                           [出力]

辞退処理完了後 ───▶ InvitesController#decline ───▶ 条件判定
                              │
                              ▼
                    !current_user?
                              │
              ┌───────────────┴───────────────┐
              │                               │
              ▼                               ▼
          Yes                              No
              │                               │
              ▼                               ▼
    invite_to_unknown_user?          dashboard_projects_path
              │
              ▼
    created_by存在?
              │
              ├─ Yes → decline.html.haml（ミニマルレイアウト）
              │
              └─ No → new_user_session_path
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| invites_controller.rb | `app/controllers/invites_controller.rb` | コントローラー | 画面制御 |
| decline.html.haml | `app/views/invites/decline.html.haml` | テンプレート | 招待辞退完了画面HTML |
| member.rb | `app/models/member.rb` | モデル | メンバー管理 |
| routes.rb | `config/routes.rb` | ルーティング | URL定義（行230） |
| minimal.html.haml | `app/views/layouts/minimal.html.haml` | レイアウト | ミニマルレイアウト |
