# 画面設計書 307-クラスター一覧

## 概要

本ドキュメントは、GitLabのKubernetesクラスター一覧画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、プロジェクトまたはグループに関連付けられたKubernetesクラスターの一覧を表示し、クラスターの管理を行うための画面である。証明書ベースのKubernetes連携（Certificate-based Kubernetes integration）の管理インターフェースを提供する。

**業務上の目的・背景**：GitLabでは、CI/CDパイプラインからKubernetesクラスターへのデプロイを自動化できる。本画面は、プロジェクトやグループに関連付けられたクラスターを一元的に管理し、デプロイ環境の状況を把握するためのインターフェースを提供する。なお、証明書ベースのクラスター連携は非推奨となっており、Kubernetes Agentへの移行が推奨されている。

**画面へのアクセス方法**：
- プロジェクト設定メニュー > インフラストラクチャ > Kubernetesクラスター
- グループ設定メニュー > Kubernetesクラスター
- URLに直接アクセス

**主要な操作・処理内容**：
1. 登録済みクラスターの一覧表示
2. クラスターの状態確認
3. クラスター詳細画面への遷移
4. 新規クラスター接続への遷移
5. 祖先グループからの継承クラスターの確認

**画面遷移**：
- 遷移元：プロジェクト/グループのサイドメニュー
- 遷移先：クラスター詳細画面、クラスター接続画面、ドキュメント

**権限による表示制御**：
- クラスター閲覧権限（`read_cluster`）が必要
- クラスター作成権限（`create_cluster`）がない場合、接続ボタンは非表示
- 証明書ベースクラスターが無効な場合、404エラー

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | Kubernetesクラスター一覧 |

## 画面種別

一覧画面

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET | `/:namespace_id/:project_id/-/clusters` | index | プロジェクトクラスター一覧（HTML） |
| GET | `/:namespace_id/:project_id/-/clusters.json` | index | プロジェクトクラスター一覧（JSON） |
| GET | `/groups/:group_id/-/clusters` | index | グループクラスター一覧（HTML） |
| GET | `/groups/:group_id/-/clusters.json` | index | グループクラスター一覧（JSON） |

## 入出力項目

### 入力項目（クエリパラメータ）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| page | Integer | No | ページ番号（ページネーション） |

## 表示項目

### クラスター一覧

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| name | String | クラスター名 |
| cluster_type | String | クラスター種別（project_type/group_type/instance_type） |
| provider_type | String | プロバイダー種別（user/gcp/aws） |
| status | String | 状態（created/errored等） |
| environment_scope | String | 環境スコープ |
| enabled | Boolean | 有効/無効 |
| kubernetes_namespace | String | Kubernetesネームスペース |

### 祖先クラスター情報

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| has_ancestor_clusters | Boolean | 祖先グループにクラスターがあるか |

## イベント仕様

### 1-クラスター詳細への遷移

クラスター行をクリックすると、該当クラスターの詳細画面（`/:namespace_id/:project_id/-/clusters/:id`）に遷移する。

### 2-新規クラスター接続

「Connect a cluster」ボタン押下時、クラスター接続画面または接続方法のドキュメントに遷移する。

### 3-状態ポーリング

画面表示中は10秒間隔でJSON APIをポーリングし、クラスターの状態を自動更新する。

### 4-ページネーション

ページ番号クリック時、該当ページのクラスター一覧を表示する（1ページ20件）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | clusters | SELECT | クラスター一覧取得 |
| 画面表示 | cluster_projects | SELECT | プロジェクト-クラスター関連取得 |
| 画面表示 | cluster_groups | SELECT | グループ-クラスター関連取得 |

本画面は参照専用であり、データベースへの更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-307-001 | 通知 | Kubernetes Clusters | ページタイトル |
| MSG-307-002 | 情報 | No clusters found | クラスターが存在しない場合 |
| MSG-307-003 | 警告 | Ancestor clusters available | 祖先グループにクラスターがある場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 権限不足 | 404エラー画面を表示 |
| 証明書ベースクラスター無効 | 404エラー画面を表示 |

## 備考

- 証明書ベースのKubernetes連携は非推奨（deprecated）
- Kubernetes Agentへの移行が推奨される
- ポーリング間隔は10秒（`STATUS_POLLING_INTERVAL = 10_000`）
- ページネーションは1ページ20件（Kaminari使用）
- `ClusterAncestorsFinder`で祖先グループのクラスターも含めて取得
- GCP Signup Offerのバナーが表示される場合がある（`render_gcp_signup_offer`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cluster.rb | `app/models/clusters/cluster.rb` | クラスターモデル、状態管理、プロバイダー種別 |

**読解のコツ**: `cluster_type`（project_type/group_type/instance_type）と`provider_type`（user/gcp/aws）の違いを理解する。`status_name`メソッドで状態名を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行17-31**: `index`アクションでHTML/JSON両対応
2. **行145-161**: `cluster_list`メソッドでクラスター取得・ページネーション
3. **行141-142**: `ensure_feature_enabled!`で証明書ベースクラスター有効確認

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/clusters/clusters/index.html.haml` | Vue.jsマウントポイント |

**主要処理フロー**:
- **行5**: `render_gcp_signup_offer`でGCPオファーバナー
- **行8**: Vue.jsアプリのマウント、`js_clusters_list_data`でdata属性設定

#### Step 4: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | clusters_helper.rb | `app/helpers/clusters_helper.rb` | `js_clusters_list_data`メソッド |

### プログラム呼び出し階層図

```
Clusters::ClustersController
    │
    ├─ before_action :authorize_read_cluster!
    │
    ├─ before_action :ensure_feature_enabled!
    │      └─ clusterable.certificate_based_clusters_enabled?
    │
    └─ #index (GET)
           │
           ├─ cluster_list
           │      └─ ClusterAncestorsFinder.new
           │              ├─ finder.execute（クラスター取得）
           │              └─ finder.has_ancestor_clusters?
           │
           ├─ respond_to
           │      ├─ format.html → View: index.html.haml
           │      │
           │      └─ format.json
           │              └─ ClusterSerializer.represent_list
           │
           └─ Gitlab::PollingInterval.set_header（ポーリング設定）
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ページアクセス ───▶ Clusters::ClustersController#index ───▶ クラスター一覧
                              │
                              ▼
                    ensure_feature_enabled!
                              │
                              ▼
                    authorize_read_cluster!
                              │
                              ▼
                    cluster_list
                              │
                              ├─ ClusterAncestorsFinder
                              │      └─ 祖先グループのクラスターも含めて取得
                              │
                              └─ Kaminari.paginate_array
                                     └─ ページネーション（20件/ページ）
                                            │
    ┌──────────────────────────────────────┴──────────────────────────────────────┐
    │                                                                              │
    ▼                                                                              ▼
HTML表示                                                                    JSON応答
    │                                                                              │
    ▼                                                                              ▼
Vue.js アプリ ───▶ API呼び出し（ポーリング） ───▶ 状態更新           ClusterSerializer
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | コントローラー | 画面制御・API提供 |
| index.html.haml | `app/views/clusters/clusters/index.html.haml` | テンプレート | Vue.jsマウント用HTML |
| cluster.rb | `app/models/clusters/cluster.rb` | モデル | クラスター管理 |
| cluster_ancestors_finder.rb | `app/finders/cluster_ancestors_finder.rb` | ファインダー | 祖先クラスター検索 |
| cluster_serializer.rb | `app/serializers/cluster_serializer.rb` | シリアライザー | JSON変換 |
| clusters_helper.rb | `app/helpers/clusters_helper.rb` | ヘルパー | ビューヘルパー |
| routes.rb | `config/routes.rb` | ルーティング | URL定義（行279-303） |
