# 画面設計書 308-クラスター詳細

## 概要

本ドキュメントは、GitLabのKubernetesクラスター詳細画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、登録されたKubernetesクラスターの詳細情報を表示し、設定の編集、Kubernetes Agentへの移行、クラスターの削除などの管理操作を行うための画面である。

**業務上の目的・背景**：GitLabとKubernetesクラスターを連携することで、CI/CDパイプラインからのデプロイを自動化できる。本画面は、登録済みクラスターの詳細設定を確認・編集し、クラスターの状態を監視するためのインターフェースを提供する。また、非推奨の証明書ベース連携からKubernetes Agentへの移行機能も提供する。

**画面へのアクセス方法**：
- クラスター一覧画面からクラスター名をクリック
- URLに直接アクセス

**主要な操作・処理内容**：
1. クラスター基本情報の表示
2. クラスター設定の編集（名前、環境スコープ、ベースドメイン等）
3. Kubernetes API接続情報の管理（ユーザー提供クラスターのみ）
4. クラスターの有効/無効切り替え
5. Kubernetes Agentへの移行
6. クラスターの削除
7. 環境一覧の表示（EE機能）

**画面遷移**：
- 遷移元：クラスター一覧画面
- 遷移先：環境詳細画面、ヘルプドキュメント

**権限による表示制御**：
- クラスター閲覧権限（`read_cluster`）：画面表示に必要
- クラスター管理権限（`admin_cluster`）：編集・削除・移行操作に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | クラスター詳細表示 |

## 画面種別

詳細・編集画面

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET | `/:namespace_id/:project_id/-/clusters/:id` | show | クラスター詳細表示 |
| PATCH/PUT | `/:namespace_id/:project_id/-/clusters/:id` | update | クラスター更新 |
| DELETE | `/:namespace_id/:project_id/-/clusters/:id` | destroy | クラスター削除 |
| GET | `/:namespace_id/:project_id/-/clusters/:id/cluster_status.json` | cluster_status | 状態取得（JSON） |
| DELETE | `/:namespace_id/:project_id/-/clusters/:id/clear_cache` | clear_cache | キャッシュクリア |
| POST | `/:namespace_id/:project_id/-/clusters/:id/migrate` | migrate | Agent移行開始 |
| PUT | `/:namespace_id/:project_id/-/clusters/:id/update_migration` | update_migration | 移行Issue更新 |

## 入出力項目

### 入力項目（パスパラメータ）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| id | Integer | Yes | クラスターID |

### 入力項目（クエリパラメータ）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| tab | String | No | 表示タブ（migrate/details/advanced_settings） |

### 入力項目（更新時）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| enabled | Boolean | No | 有効/無効 |
| environment_scope | String | No | 環境スコープ |
| managed | Boolean | No | GitLab管理フラグ |
| namespace_per_environment | Boolean | No | 環境ごとのネームスペース |
| name | String | No | クラスター名（ユーザー提供のみ） |
| base_domain | String | No | ベースドメイン |
| management_project_id | Integer | No | 管理プロジェクトID |
| platform_kubernetes_attributes[api_url] | String | No | Kubernetes API URL（ユーザー提供のみ） |
| platform_kubernetes_attributes[token] | String | No | サービスアカウントトークン（ユーザー提供のみ） |
| platform_kubernetes_attributes[ca_cert] | String | No | CA証明書（ユーザー提供のみ） |
| platform_kubernetes_attributes[namespace] | String | No | デフォルトネームスペース |

### 入力項目（移行時）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| configuration_project_id | Integer | Yes | 設定プロジェクトID |
| agent_name | String | Yes | エージェント名 |

## 表示項目

### 基本情報

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| name | String | クラスター名 |
| cluster_type | String | クラスター種別（バッジ表示） |
| enabled | Boolean | 有効/無効 |
| environment_scope | String | 環境スコープ |
| provider_type | String | プロバイダー種別 |
| status | String | 接続状態 |
| status_reason | String | 状態の理由 |

### タブ

| タブ名 | 説明 |
|--------|------|
| Migrate | Agent移行設定 |
| Details | クラスター詳細設定 |
| Environments | デプロイ環境一覧（EE） |
| Advanced settings | 高度な設定（削除等） |

## イベント仕様

### 1-クラスター設定更新

「Save changes」ボタン押下時の処理：
1. `PATCH/PUT /:namespace_id/:project_id/-/clusters/:id`にリクエスト送信
2. `Clusters::UpdateService`が実行される
3. 成功時：成功メッセージ表示、ページリロード
4. 失敗時：エラー表示、フォーム再表示

### 2-状態ポーリング

画面表示中は10秒間隔で`/cluster_status.json`をポーリングし、クラスターの接続状態を自動更新する。

### 3-Kubernetes Agent移行

「Migrate」ボタン押下時の処理：
1. `POST /:namespace_id/:project_id/-/clusters/:id/migrate`にリクエスト送信
2. `Clusters::Migration::CreateService`が実行される
3. 成功時：「Migrating cluster - initiated」メッセージ、migrateタブにリダイレクト
4. 失敗時：エラーメッセージ表示

### 4-クラスター削除

「Remove integration」ボタン押下時の処理：
1. `DELETE /:namespace_id/:project_id/-/clusters/:id`にリクエスト送信
2. `Clusters::DestroyService`が実行される
3. クラスター一覧画面へリダイレクト

### 5-キャッシュクリア

「Clear cluster cache」ボタン押下時の処理：
1. `DELETE /:namespace_id/:project_id/-/clusters/:id/clear_cache`にリクエスト送信
2. `cluster.delete_cached_resources!`が実行される
3. 成功メッセージ表示、ページリロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新 | clusters | UPDATE | クラスター設定更新 |
| 設定更新 | cluster_platforms_kubernetes | UPDATE | Kubernetes設定更新 |
| 移行開始 | cluster_agent_migrations | INSERT | 移行レコード作成 |
| 削除 | clusters | DELETE | クラスター削除 |
| キャッシュクリア | kubernetes_namespaces | DELETE | キャッシュ削除 |

### テーブル別更新項目詳細

#### clusters（更新時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enabled | ユーザー指定値 | 有効/無効 |
| UPDATE | environment_scope | ユーザー指定値 | 環境スコープ |
| UPDATE | name | ユーザー指定値 | クラスター名 |
| UPDATE | base_domain | ユーザー指定値 | ベースドメイン |
| UPDATE | management_project_id | ユーザー指定値 | 管理プロジェクト |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-308-001 | 通知 | Kubernetes Cluster | ページタイトル |
| MSG-308-002 | 成功 | Kubernetes cluster was successfully updated. | 更新成功時 |
| MSG-308-003 | 成功 | Cluster cache cleared. | キャッシュクリア成功時 |
| MSG-308-004 | 成功 | Migrating cluster - initiated | 移行開始成功時 |
| MSG-308-005 | エラー | Migrating cluster - failed: "%{error}" | 移行開始失敗時 |
| MSG-308-006 | 成功 | Migration issue updated successfully | 移行Issue更新成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| クラスターが存在しない | 404エラー画面を表示 |
| 権限不足 | 404エラー画面を表示 |
| 更新バリデーションエラー | フォームにエラー表示 |
| プロバイダー作成中の変更 | エラーメッセージ「Cannot modify provider during creation」 |

## 備考

- 証明書ベースのKubernetes連携は非推奨（deprecated）
- Kubernetes Agentへの移行が推奨される
- ポーリング間隔は10秒（`STATUS_POLLING_INTERVAL = 10_000`）
- ユーザー提供クラスター（`provider_type: :user`）のみAPI URL等の編集が可能
- GCP/AWSプロバイダーのクラスターは一部設定のみ編集可能
- `has_rbac_enabled?`でRBAC有効状態を確認

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cluster.rb | `app/models/clusters/cluster.rb` | クラスターモデル、状態管理 |
| 1-2 | kubernetes.rb | `app/models/clusters/platforms/kubernetes.rb` | Kubernetesプラットフォーム設定 |

**読解のコツ**: `provided_by_user?`メソッドでユーザー提供クラスターかどうかを判定。`status_name`で現在の状態を取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | show/update/destroy/migrateアクション |

**主要処理フロー**:
1. **行35-45**: `cluster_status`アクションでJSON状態返却
2. **行47-67**: `update`アクションで設定更新
3. **行70-77**: `destroy`アクションでクラスター削除
4. **行92-113**: `migrate`/`update_migration`アクションで移行処理

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/clusters/clusters/show.html.haml` | タブ構成、data属性設定 |

**主要処理フロー**:
- **行7-18**: data属性で状態情報を設定
- **行24-26**: クラスター名とバッジ表示
- **行30-40**: タブナビゲーション（migrate/details/environments/advanced_settings）

### プログラム呼び出し階層図

```
Clusters::ClustersController
    │
    ├─ before_action :cluster（クラスター取得）
    │
    ├─ before_action :authorize_update_cluster!（更新権限確認）
    │
    ├─ #show (GET)
    │      └─ View: show.html.haml
    │              ├─ _banner.html.haml
    │              ├─ _migrate_tab.html.haml
    │              ├─ _details_tab.html.haml
    │              ├─ _environments_tab.html.haml (EE)
    │              └─ _advanced_settings_tab.html.haml
    │
    ├─ #update (PATCH/PUT)
    │      └─ Clusters::UpdateService#execute
    │
    ├─ #destroy (DELETE)
    │      └─ Clusters::DestroyService#execute
    │
    ├─ #cluster_status (GET)
    │      └─ ClusterSerializer.represent_status
    │
    ├─ #migrate (POST)
    │      └─ Clusters::Migration::CreateService#execute
    │
    └─ #clear_cache (DELETE)
           └─ cluster.delete_cached_resources!
```

### データフロー図

```
[入力]                    [処理]                              [出力]

クラスターID ───▶ Clusters::ClustersController#show ───▶ 詳細画面表示
                              │
                              ▼
                    cluster取得（find）
                              │
                              ▼
                    View: show.html.haml
                              │
    ┌─────────────────────────┼─────────────────────────┐
    │                         │                         │
    ▼                         ▼                         ▼
Migrateタブ              Detailsタブ           Advanced Settingsタブ
    │                         │                         │
    ▼                         ▼                         ▼
移行設定フォーム         設定編集フォーム         削除・キャッシュクリア
                              │
                              ▼
                    Clusters::UpdateService
                              │
                              ▼
                    clusters/cluster_platforms_kubernetes更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusters_controller.rb | `app/controllers/clusters/clusters_controller.rb` | コントローラー | 画面制御・API提供 |
| show.html.haml | `app/views/clusters/clusters/show.html.haml` | テンプレート | 詳細画面HTML |
| _migrate_tab.html.haml | `app/views/clusters/clusters/_migrate_tab.html.haml` | パーシャル | 移行タブ |
| _details_tab.html.haml | `app/views/clusters/clusters/_details_tab.html.haml` | パーシャル | 詳細タブ |
| _advanced_settings_tab.html.haml | `app/views/clusters/clusters/_advanced_settings_tab.html.haml` | パーシャル | 高度な設定タブ |
| cluster.rb | `app/models/clusters/cluster.rb` | モデル | クラスター管理 |
| update_service.rb | `app/services/clusters/update_service.rb` | サービス | 更新処理 |
| destroy_service.rb | `app/services/clusters/destroy_service.rb` | サービス | 削除処理 |
| routes.rb | `config/routes.rb` | ルーティング | URL定義（行280-303） |
