# 画面設計書 309-エージェントダッシュボード一覧

## 概要

本ドキュメントは、GitLabのKubernetesダッシュボード一覧画面（エージェント未選択状態）の設計仕様を定義する。

### 本画面の処理概要

本画面は、Kubernetesダッシュボードにアクセスした際にエージェントが未選択の状態で表示される画面である。ユーザーに対してエージェントの選択方法を案内し、プロジェクト一覧または環境ページへの遷移を促す。

**業務上の目的・背景**：GitLabのKubernetesダッシュボード機能は、接続されたKubernetes Agentを通じてクラスターリソースの可視化と管理を行う。本画面は、ダッシュボードへの初回アクセス時やエージェント未指定時のランディングページとして、ユーザーを適切な操作へ誘導する役割を持つ。

**画面へのアクセス方法**：
- ナビゲーションメニューから「Kubernetes」を選択
- URLに直接アクセス

**主要な操作・処理内容**：
1. エージェント未選択状態の案内表示
2. プロジェクト一覧画面への遷移
3. ヘルプドキュメントへの遷移

**画面遷移**：
- 遷移元：ナビゲーションメニュー
- 遷移先：プロジェクト一覧画面、ヘルプドキュメント

**権限による表示制御**：
- `k8s_dashboard` フィーチャーフラグが有効であること
- ログインは不要（未ログインでも表示可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | Kubernetesダッシュボード |

## 画面種別

空状態画面（Empty State）

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET | `/-/kubernetes` | index | ダッシュボード一覧（エージェント未選択） |

## 入出力項目

### 入力項目

なし（本画面には入力項目はない）

## 表示項目

### 空状態コンポーネント

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| イラスト | SVG | 空状態用イラスト（empty-search-md.svg） |
| タイトル | String | 「No agent selected」 |
| 説明文 | String | エージェント選択方法の案内 |
| 主ボタン | String | 「View projects」 |
| 副ボタン | String | 「Learn more」 |

## イベント仕様

### 1-プロジェクト一覧への遷移

「View projects」ボタン押下時、`dashboard_projects_path`（ダッシュボード > プロジェクト一覧）へ遷移する。

### 2-ヘルプドキュメントへの遷移

「Learn more」ボタン押下時、Kubernetesダッシュボードのヘルプドキュメント（`ci/environments/kubernetes_dashboard.md`）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベースアクセスなし |

本画面は情報表示のみであり、データベースへの更新は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-309-001 | 通知 | Kubernetes Dashboard | ページタイトル・パンくず |
| MSG-309-002 | 通知 | No agent selected | 空状態タイトル |
| MSG-309-003 | 案内 | You can select an agent from a project's environment page. | 説明文 |
| MSG-309-004 | 通知 | View projects | 主ボタンラベル |
| MSG-309-005 | 通知 | Learn more | 副ボタンラベル |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| k8s_dashboardフィーチャーフラグ無効 | 404エラー画面を表示 |

## 備考

- `k8s_dashboard`フィーチャーフラグで機能の有効/無効を制御
- Pajamas EmptyStateComponentを使用したUI実装
- 国際化対応（s_()ヘルパー使用）
- エージェントを選択するには、プロジェクトの環境ページからアクセスする必要がある
- 本画面はエージェント未選択のランディングページとして機能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | agent.rb | `app/models/clusters/agent.rb` | エージェントモデル、接続状態判定 |

**読解のコツ**: `connected?`メソッドでエージェントのアクティブトークン存在確認。`has_access_to?`でプロジェクトアクセス権限を確認。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dashboard_controller.rb | `app/controllers/clusters/agents/dashboard_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行8**: `check_feature_flag!`でフィーチャーフラグ確認
2. **行15**: `index`アクションは空実装（ビューのみ）
3. **行25-27**: `check_feature_flag!`メソッドで`k8s_dashboard`フラグ確認

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/clusters/agents/dashboard/index.html.haml` | 空状態コンポーネント |

**主要処理フロー**:
- **行1-2**: パンくず・ページタイトル設定
- **行4-12**: `Pajamas::EmptyStateComponent`でUIレンダリング

### プログラム呼び出し階層図

```
Clusters::Agents::DashboardController
    │
    ├─ before_action :check_feature_flag!
    │      └─ Feature.enabled?(:k8s_dashboard, current_user)
    │              └─ 無効時: not_found
    │
    └─ #index (GET)
           └─ View: index.html.haml
                   └─ Pajamas::EmptyStateComponent
                           ├─ svg_path: 'illustrations/empty-state/empty-search-md.svg'
                           ├─ title: s_("KubernetesDashboard|No agent selected")
                           ├─ primary_button: → dashboard_projects_path
                           └─ secondary_button: → help_page_path('ci/environments/kubernetes_dashboard.md')
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ページアクセス ───▶ Clusters::Agents::DashboardController#index ───▶ 空状態画面
                              │
                              ▼
                    check_feature_flag!
                              │
                              ├─ フラグ有効 ───▶ View: index.html.haml
                              │                         │
                              │                         ▼
                              │               EmptyStateComponent
                              │                         │
                              │      ┌─────────────────┴─────────────────┐
                              │      ▼                                   ▼
                              │  View projects                     Learn more
                              │      │                                   │
                              │      ▼                                   ▼
                              │  dashboard_projects_path          help_page_path
                              │
                              └─ フラグ無効 ───▶ 404 Not Found
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dashboard_controller.rb | `app/controllers/clusters/agents/dashboard_controller.rb` | コントローラー | 画面制御 |
| index.html.haml | `app/views/clusters/agents/dashboard/index.html.haml` | テンプレート | 空状態HTML |
| agent.rb | `app/models/clusters/agent.rb` | モデル | エージェント管理 |
| routes.rb | `config/routes.rb` | ルーティング | URL定義（行148） |
| empty_state_component.rb | `app/components/pajamas/empty_state_component.rb` | コンポーネント | 空状態UI |
