# 画面設計書 310-エージェントダッシュボード詳細

## 概要

本ドキュメントは、GitLabのKubernetesダッシュボード詳細画面（エージェント選択済み状態）の設計仕様を定義する。

### 本画面の処理概要

本画面は、選択されたKubernetes Agentを通じてクラスターリソースを可視化・管理するためのダッシュボード画面である。Vue.jsアプリケーションとして実装され、KAS（Kubernetes Agent Server）経由でリアルタイムにクラスター情報を取得・表示する。

**業務上の目的・背景**：GitLabのKubernetes Agent（kas）を使用することで、セキュアにKubernetesクラスターと連携できる。本画面は、接続されたエージェントを通じてPod、Deployment、Service等のKubernetesリソースをWebインターフェースから直接確認できるダッシュボードを提供する。

**画面へのアクセス方法**：
- プロジェクトの環境ページからエージェントを選択
- URLに直接アクセス（エージェントIDを含む）

**主要な操作・処理内容**：
1. クラスターリソースの可視化
2. リソース状態の確認
3. ネームスペース別のリソース表示
4. リアルタイム更新（KAS経由）

**画面遷移**：
- 遷移元：環境ページ、エージェントダッシュボード一覧画面
- 遷移先：個別リソース詳細（Vue Router内遷移）

**権限による表示制御**：
- `k8s_dashboard`フィーチャーフラグが有効であること
- ログインが必要
- エージェントに対する`read_cluster_agent`権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | Kubernetesクラスター連携 | 主機能 | Kubernetesダッシュボード詳細 |

## 画面種別

詳細画面（SPA - シングルページアプリケーション）

## URL/ルーティング

| メソッド | パス | アクション | 説明 |
|---------|------|----------|------|
| GET | `/-/kubernetes/:agent_id` | show | ダッシュボード詳細（エージェント選択済み） |
| GET | `/-/kubernetes/:agent_id/*vueroute` | show | Vue Router内ルーティング |

## 入出力項目

### 入力項目（パスパラメータ）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| agent_id | Integer | Yes | エージェントID |
| vueroute | String | No | Vue Router内パス |

## 表示項目

### data属性（Vue.jsへの受け渡し）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| base_path | String | ベースパス（`/-/kubernetes`） |
| agent | JSON | エージェント情報（JSON形式） |
| kas_tunnel_url | String | KASトンネルURL |

### エージェント情報（@agent.to_json）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| id | Integer | エージェントID |
| name | String | エージェント名 |
| project_id | Integer | 所属プロジェクトID |
| created_at | DateTime | 作成日時 |

## イベント仕様

### 1-初期ロード

画面表示時の処理：
1. コントローラーでエージェント取得・権限確認
2. KASクッキー設定（認証用）
3. Vue.jsアプリケーションマウント
4. KAS経由でクラスターリソース取得

### 2-Vue Router内遷移

Vue.jsアプリ内でのルーティングはVue Routerが処理し、サーバーへのリクエストは発生しない。`*vueroute`パターンで全てのサブパスをキャッチする。

### 3-リアルタイム更新

KASトンネル経由でKubernetesクラスターと通信し、リソース情報をリアルタイムで取得・更新する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | cluster_agents | SELECT | エージェント情報取得 |

本画面は参照専用であり、GitLabデータベースへの更新は行わない。Kubernetesクラスターへの操作はKAS経由で行われる。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-310-001 | 通知 | Dashboard | ページタイトル |
| MSG-310-002 | 通知 | Kubernetes Dashboard | 親パンくず |
| MSG-310-003 | 通知 | Agents | パンくず（ダッシュボード一覧へ） |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| k8s_dashboardフィーチャーフラグ無効 | 404エラー画面を表示 |
| エージェントが存在しない | 404エラー画面を表示 |
| read_cluster_agent権限なし | 404エラー画面を表示 |
| 未ログイン | ログイン画面へリダイレクト |

## 備考

- `k8s_dashboard`フィーチャーフラグで機能の有効/無効を制御
- Vue.jsアプリケーション（`.js-kubernetes-app`）として実装
- KASクッキー設定によりKubernetes APIへの認証を行う
- KASトンネルURL（`Gitlab::Kas.tunnel_url`）経由でクラスターと通信
- `KasCookie`モジュールでセキュリティポリシー・クッキー管理
- CSP（Content Security Policy）にKAS URLを追加
- 国際化対応（s_()ヘルパー使用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | agent.rb | `app/models/clusters/agent.rb` | エージェントモデル、トークン管理、接続状態 |
| 1-2 | agent_token.rb | `app/models/clusters/agent_token.rb` | エージェントトークン管理 |

**読解のコツ**: `connected?`メソッド（行57-59）でアクティブトークンの存在を確認。`user_access_authorized_for?`（行79-84）でユーザーアクセス権限を判定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dashboard_controller.rb | `app/controllers/clusters/agents/dashboard_controller.rb` | showアクション、before_action |

**主要処理フロー**:
1. **行8**: `check_feature_flag!`でフィーチャーフラグ確認
2. **行9**: `find_agent`でエージェント取得
3. **行10**: `authorize_read_cluster_agent!`で権限確認
4. **行11**: `set_kas_cookie`でKAS認証クッキー設定
5. **行17**: `show`アクションは空実装（ビューのみ）

#### Step 3: 認証モジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kas_cookie.rb | `app/controllers/concerns/kas_cookie.rb` | KASクッキー設定、CSP設定 |

**主要処理フロー**:
- **行6-16**: CSP設定（connect-srcにKAS URLを追加）
- **行18-27**: `set_kas_cookie`メソッドでセッションベースのクッキー設定

#### Step 4: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/clusters/agents/dashboard/show.html.haml` | Vue.jsマウント、data属性 |

**主要処理フロー**:
- **行1-3**: パンくず・ページタイトル設定
- **行5**: Vue.jsマウントポイント、data属性（agent, kas_tunnel_url）

### プログラム呼び出し階層図

```
Clusters::Agents::DashboardController
    │
    ├─ include KasCookie
    │
    ├─ before_action :check_feature_flag!
    │      └─ Feature.enabled?(:k8s_dashboard, current_user)
    │              └─ 無効時: not_found
    │
    ├─ before_action :find_agent (if: current_user)
    │      └─ Clusters::Agent.find(params[:agent_id])
    │              └─ 存在しない場合: RecordNotFound → 404
    │
    ├─ before_action :authorize_read_cluster_agent! (if: current_user)
    │      └─ can?(current_user, :read_cluster_agent, @agent)
    │              └─ 権限なし: not_found
    │
    ├─ before_action :set_kas_cookie (if: current_user)
    │      └─ KasCookie#set_kas_cookie
    │              ├─ Gitlab::Kas::UserAccess.enabled?
    │              ├─ Gitlab::Session.current.id.public_id
    │              └─ cookies[Gitlab::Kas::COOKIE_KEY] = cookie_data
    │
    └─ #show (GET)
           └─ View: show.html.haml
                   └─ .js-kubernetes-app
                           ├─ data-base-path: kubernetes_dashboard_path
                           ├─ data-agent: @agent.to_json
                           └─ data-kas-tunnel-url: Gitlab::Kas.tunnel_url
```

### データフロー図

```
[入力]                    [処理]                              [出力]

agent_id ───▶ Clusters::Agents::DashboardController#show ───▶ ダッシュボード画面
    │                         │
    │                         ▼
    │               check_feature_flag!
    │                         │
    │                         ▼
    │               find_agent
    │                         │
    │                         ├─ エージェント取得
    │                         │      └─ Clusters::Agent.find
    │                         │
    │                         ▼
    │               authorize_read_cluster_agent!
    │                         │
    │                         ├─ 権限確認
    │                         │      └─ can?(:read_cluster_agent)
    │                         │
    │                         ▼
    │               set_kas_cookie
    │                         │
    │                         ├─ KASクッキー設定
    │                         │      └─ セッションベース認証
    │                         │
    │                         ▼
    │               View: show.html.haml
    │                         │
    │                         ▼
    │               Vue.js Application Mount
    │                         │
    │      ┌─────────────────┴─────────────────┐
    │      ▼                                   ▼
    │  @agent.to_json                   Gitlab::Kas.tunnel_url
    │      │                                   │
    │      └─────────────────┬─────────────────┘
    │                        │
    │                        ▼
    │               Kubernetes Dashboard UI
    │                        │
    │                        ▼
    └──────────────▶ KAS経由でKubernetesクラスターと通信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dashboard_controller.rb | `app/controllers/clusters/agents/dashboard_controller.rb` | コントローラー | 画面制御・認証 |
| show.html.haml | `app/views/clusters/agents/dashboard/show.html.haml` | テンプレート | Vue.jsマウントHTML |
| kas_cookie.rb | `app/controllers/concerns/kas_cookie.rb` | コンサーン | KAS認証・CSP設定 |
| agent.rb | `app/models/clusters/agent.rb` | モデル | エージェント管理 |
| routes.rb | `config/routes.rb` | ルーティング | URL定義（行148-149） |
| kas.rb | `lib/gitlab/kas.rb` | ライブラリ | KAS URL管理 |
