# 画面設計書 313-Jiraブランチ作成

## 概要

本ドキュメントは、GitLabにおけるJira Connectブランチ作成画面の設計仕様を定義するものである。

### 本画面の処理概要

Jiraブランチ作成画面は、Jira CloudからGitLabのリポジトリに新しいブランチを作成するための画面である。Jiraのイシュー画面から直接GitLabにブランチを作成でき、イシューキーとサマリーから自動的にブランチ名を生成する機能を提供する。

**業務上の目的・背景**：開発者がJiraのイシューに取り組む際、対応するブランチをGitLabに作成する作業が頻繁に発生する。この画面により、Jiraから離れることなくブランチを作成でき、かつイシュー情報に基づいた一貫性のあるブランチ命名を自動化できる。これによりワークフローの効率化と命名規則の統一が実現される。

**画面へのアクセス方法**：Jira Cloudのイシュー詳細画面から「Create branch」リンクをクリックすることでアクセスする。GitLab側のURL `/jira_connect/branches/new` に対応する。セルフマネージドインスタンスの場合は `/jira_connect/branches/route` 経由でリダイレクトされる。

**主要な操作・処理内容**：
1. プロジェクト選択 - ブランチを作成するGitLabプロジェクトを選択
2. ソースブランチ選択 - 新しいブランチの元となるブランチを選択
3. ブランチ名入力 - ブランチ名を入力（イシュー情報から自動生成）
4. ブランチ作成 - 新しいブランチを作成

**画面遷移**：
- Jira Cloudのイシュー画面からのアクセス
- ブランチ作成成功後は成功メッセージを表示

**権限による表示制御**：
- GitLabへのログインが必須
- プロジェクトへの書き込み権限が必要（ブランチ作成権限）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 96 | Jira連携 | 主機能 | Jiraからブランチ作成 |
| 19 | ブランチ管理 | 補助機能 | ブランチ作成処理 |

## 画面種別

登録

## URL/ルーティング

- パス: `/jira_connect/branches/new`
- ルートパス: `/jira_connect/branches/route`（セルフマネージド用リダイレクト）
- コントローラ: `JiraConnect::BranchesController#new`
- ルート定義: `config/routes/jira_connect.rb` (15-18行目)

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| issue_key | 入力（URLパラメータ） | String | いいえ | JiraイシューのキーID |
| issue_summary | 入力（URLパラメータ） | String | いいえ | Jiraイシューのサマリー |
| プロジェクト | 入力（フォーム） | Object | はい | ブランチを作成するプロジェクト |
| ソースブランチ | 入力（フォーム） | String | はい | ブランチの元となるブランチ |
| ブランチ名 | 入力（フォーム） | String | はい | 作成するブランチの名前 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ページタイトル | String | イシューキーを含むタイトル、またはデフォルトタイトル |
| 成功メッセージ | EmptyState | ブランチ作成成功時の確認メッセージ |

## イベント仕様

### 1-プロジェクト選択

プロジェクトドロップダウンから対象プロジェクトを選択する。

**処理フロー**：
1. ドロップダウン展開
2. 検索可能なプロジェクト一覧を表示
3. プロジェクト選択
4. 選択されたプロジェクトのブランチ一覧を取得

### 2-ソースブランチ選択

ソースブランチドロップダウンから元となるブランチを選択する。

**処理フロー**：
1. プロジェクトが選択されていることを確認
2. ドロップダウン展開
3. プロジェクトのブランチ一覧を表示
4. ブランチ選択

### 3-ブランチ作成

フォームを送信してブランチを作成する。

**処理フロー**：
1. 入力値のバリデーション
2. GitLab APIを使用してブランチを作成
3. 成功時：成功状態を表示
4. 失敗時：エラーメッセージを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ブランチ作成 | - | API呼び出し | Git操作（DB直接更新なし） |

※ブランチの作成はGitリポジトリに対する操作であり、データベースへの直接的な更新は発生しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Branch created | ブランチ作成成功時（EmptyState表示） |
| 成功 | You can now close this window and create a merge request from the branch in the GitLab repository. | 成功後の説明 |
| エラー | - | ブランチ作成失敗時（APIエラー） |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| 未ログイン | ログイン画面へリダイレクト |
| プロジェクト未選択 | ソースブランチ選択を無効化 |
| ブランチ名重複 | エラーメッセージを表示 |
| 権限不足 | エラーメッセージを表示 |

## 備考

- イシューキーとサマリーからブランチ名を自動生成（`Issue.to_branch_name`メソッドを使用）
- セルフマネージドインスタンスの場合、`/jira_connect/branches/route` からリダイレクトされる
- 成功後は「ウィンドウを閉じてマージリクエストを作成」を案内

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | branches_controller.rb | `app/controllers/jira_connect/branches_controller.rb` | ルーティング、データ準備を理解する |

**主要処理フロー**:
1. **7-9行目**: `new` アクションでVueアプリ用のデータを準備
2. **13-21行目**: `route` アクションでセルフマネージドへのリダイレクトを処理
3. **25-31行目**: `initial_branch_name` メソッドでイシュー情報からブランチ名を生成
4. **33-39行目**: `new_branch_data` メソッドでVueアプリに渡すデータを構築

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/jira_connect/branches/new.html.haml` | Vueアプリのマウント設定を理解する |

**主要処理フロー**:
- **1-2行目**: レイアウト設定とコンテンツ幅の制限
- **5行目**: `@new_branch_data` をVueアプリに渡す

#### Step 3: フロントエンドコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.vue | `app/assets/javascripts/jira_connect/branches/pages/index.vue` | メインページコンポーネントを理解する |
| 3-2 | new_branch_form.vue | `app/assets/javascripts/jira_connect/branches/components/new_branch_form.vue` | ブランチ作成フォームを理解する |
| 3-3 | project_dropdown.vue | `app/assets/javascripts/jira_connect/branches/components/project_dropdown.vue` | プロジェクト選択を理解する |
| 3-4 | source_branch_dropdown.vue | `app/assets/javascripts/jira_connect/branches/components/source_branch_dropdown.vue` | ソースブランチ選択を理解する |

**主要処理フロー**:
- **index.vue 19-22行目**: `inject` でコントローラからのデータを受け取る
- **index.vue 33-37行目**: ブランチ作成成功時の処理

### プログラム呼び出し階層図

```
JiraConnect::BranchesController
    │
    ├─ #new
    │      ├─ authenticate_user!
    │      └─ new_branch_data
    │             └─ initial_branch_name
    │
    └─ #route
           └─ current_jira_installation.proxy?
                  └─ redirect_to (セルフマネージドURL or new)

Vueアプリ (index.vue)
    │
    └─ NewBranchForm
           ├─ ProjectDropdown
           │      └─ プロジェクト検索API
           │
           ├─ SourceBranchDropdown
           │      └─ ブランチ一覧API
           │
           └─ ブランチ作成API
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Jira issue_key       ───▶  branches_controller      ───▶  ブランチ名候補
issue_summary              │                               │
                          │                               ▼
                          ▼                          index.vue
                    Issue.to_branch_name                  │
                                                         ▼
プロジェクト選択     ───▶  NewBranchForm           ───▶  成功/エラー表示
ソースブランチ選択        │
ブランチ名               │
                          ▼
                    GitLab API
                          │
                          ▼
                    Gitリポジトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| branches_controller.rb | `app/controllers/jira_connect/branches_controller.rb` | コントローラ | リクエスト処理、データ準備 |
| new.html.haml | `app/views/jira_connect/branches/new.html.haml` | ビュー | 画面テンプレート |
| index.vue | `app/assets/javascripts/jira_connect/branches/pages/index.vue` | Vue | メインページ |
| new_branch_form.vue | `app/assets/javascripts/jira_connect/branches/components/new_branch_form.vue` | Vue | ブランチ作成フォーム |
| project_dropdown.vue | `app/assets/javascripts/jira_connect/branches/components/project_dropdown.vue` | Vue | プロジェクト選択 |
| source_branch_dropdown.vue | `app/assets/javascripts/jira_connect/branches/components/source_branch_dropdown.vue` | Vue | ソースブランチ選択 |
| jira_connect.rb | `config/routes/jira_connect.rb` | ルーティング | URLルート定義 |
