# 画面設計書 314-OAuthコールバック

## 概要

本ドキュメントは、GitLabにおけるJira Connect OAuthコールバック画面の設計仕様を定義するものである。

### 本画面の処理概要

OAuthコールバック画面は、GitLab for Jira Cloud アプリケーションにおいて、OAuth認証フローのコールバック処理後にユーザーに表示されるランディングページである。この画面はOAuth認証が完了したことをユーザーに通知し、ウィンドウを閉じることを案内する。

**業務上の目的・背景**：Jira CloudとGitLabの連携において、ユーザーはGitLabアカウントでの認証が必要となる。OAuth認証フローでは、認可後にコールバックURLへリダイレクトされる。この画面は、そのリダイレクト先として機能し、認証が完了したことをユーザーに明示的に伝える役割を持つ。Atlassian MarketplaceのGitLab.com for Jira Cloudアプリのインストール・認証フローの一部として使用される。

**画面へのアクセス方法**：OAuth認証フロー完了後、自動的にリダイレクトされる。直接URL `/jira_connect/oauth_callbacks` にアクセスすることも可能だが、通常はOAuth認証フローの一部としてのみ使用される。

**主要な操作・処理内容**：
1. 認証完了メッセージの表示
2. ウィンドウを閉じることの案内

**画面遷移**：
- GitLab OAuth認可画面からのリダイレクト
- この画面からの遷移はなし（ウィンドウを閉じる）

**権限による表示制御**：
- 認証不要（skip_before_action :authenticate_user!）
- 誰でもアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | Jira OAuthコールバック |

## 画面種別

完了/確認

## URL/ルーティング

- パス: `/jira_connect/oauth_callbacks`
- コントローラ: `JiraConnect::OauthCallbacksController#index`
- ルート定義: `config/routes/jira_connect.rb` (40行目)

## 入出力項目

なし（表示のみ）

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| メッセージ | String | 「このウィンドウを閉じることができます。」 |

## イベント仕様

この画面にはユーザー操作によるイベントは存在しない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

この画面ではデータベースへの更新は発生しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | You can close this window. | 常に表示 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| - | 例外処理なし（静的な表示のみ） |

## 備考

- このコントローラの唯一の役割は、ユーザーにウィンドウを閉じられることを伝えること
- 実際のOAuthトークン処理は別のエンドポイントで行われる
- 非常にシンプルな静的ページ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | oauth_callbacks_controller.rb | `app/controllers/jira_connect/oauth_callbacks_controller.rb` | 非常にシンプルなコントローラ構造を理解する |

**主要処理フロー**:
1. **1-6行目**: コントローラの役割がコメントで説明されている
2. **10行目**: `skip_before_action :authenticate_user!` で認証をスキップ
3. **12行目**: `index` アクションは空のメソッド（テンプレートのみレンダリング）

**読解のコツ**: このコントローラはAtlassianのOAuth認証フロー完了後のランディングページとして機能する。実際のトークン処理は行わない。

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/jira_connect/oauth_callbacks/index.html.haml` | 非常にシンプルなテンプレート |

**主要処理フロー**:
- **1行目**: `s_('Integrations|You can close this window.')` で国際化対応されたメッセージを表示

### プログラム呼び出し階層図

```
JiraConnect::OauthCallbacksController
    │
    └─ #index
           │
           └─ index.html.haml (View)
                  │
                  └─ 静的メッセージ表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OAuth認証完了       ───▶  oauth_callbacks_controller ───▶  メッセージ表示
(リダイレクト)             │
                          │
                          └─ 認証処理なし
                             （静的ページのみ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| oauth_callbacks_controller.rb | `app/controllers/jira_connect/oauth_callbacks_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/jira_connect/oauth_callbacks/index.html.haml` | ビュー | 画面テンプレート |
| jira_connect.rb | `config/routes/jira_connect.rb` | ルーティング | URLルート定義 |
