# 画面設計書 315-ヘルプトップ

## 概要

本ドキュメントは、GitLabにおけるヘルプトップページの設計仕様を定義するものである。

### 本画面の処理概要

ヘルプトップページは、GitLabのヘルプドキュメントのエントリーポイントとなる画面である。GitLabの概要説明、ドキュメントインデックス、クイックヘルプへのリンクなどを提供し、ユーザーが必要な情報に素早くアクセスできるようにする。

**業務上の目的・背景**：GitLabは多機能なプラットフォームであり、ユーザーは様々な機能の使い方やベストプラクティスについて学ぶ必要がある。ヘルプトップページは、インスタンス内に組み込まれたドキュメントへのアクセスポイントを提供し、外部のドキュメントサイトに移動することなく必要な情報を得られるようにする。また、管理者がカスタムヘルプテキストを追加できる機能も備える。

**画面へのアクセス方法**：ナビゲーションの「ヘルプ」メニューからアクセス、または直接URL `/help` にアクセスする。

**主要な操作・処理内容**：
1. GitLabの概要説明を表示
2. ドキュメントインデックス（目次）を表示
3. クイックヘルプリンクへのアクセス
4. インスタンス設定情報へのリンク
5. 検索バーやキーボードショートカットへのアクセス

**画面遷移**：
- ナビゲーションメニューからのアクセス
- 各ドキュメントページへの遷移
- インスタンス設定ページへの遷移
- 外部サポートサイトへの遷移

**権限による表示制御**：
- パブリック可視性が制限されていない場合、未ログインでもアクセス可能
- ログイン済みの場合、GitLabバージョン情報を表示
- 商用コンテンツ非表示設定により一部リンクが非表示になる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 142 | ヘルプシステム | 主機能 | ヘルプトップページ表示 |

## 画面種別

トップ/インデックス

## URL/ルーティング

- パス: `/help`
- コントローラ: `HelpController#index`
- ルート定義: `config/routes/help.rb` (3行目)

## 入出力項目

なし（表示のみ）

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| カスタムヘルプテキスト | Markdown | 管理者が設定したカスタムメッセージ |
| GitLabタイトル | String | デフォルトブランドタイトル |
| バージョン情報 | Link | ログイン時のみ表示されるバージョンリンク |
| バージョンチェックバッジ | Component | バージョン確認ステータスバッジ |
| GitLab説明 | Text | GitLabの概要説明 |
| インスタンス設定リンク | Link | インスタンス設定ページへのリンク |
| ドキュメントインデックス | Markdown | doc/index.md から読み込んだ目次 |
| クイックヘルプ | List | サポートサイト、検索バー、ショートカットなどへのリンク |

## イベント仕様

### 1-検索バー起動

「Use the search bar on the top of this page」ボタン押下時。

**処理フロー**：
1. `js-trigger-search-bar` クラスのクリックイベント発火
2. JavaScriptで検索バーをアクティブ化

### 2-ショートカット表示

「Use shortcuts」ボタン押下時。

**処理フロー**：
1. `js-trigger-shortcut` クラスのクリックイベント発火
2. キーボードショートカットモーダルを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | application_settings | SELECT | カスタムヘルプテキストを取得 |

### テーブル別更新項目詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | help_page_text | - | カスタムヘルプテキスト |
| SELECT | help_page_hide_commercial_content | - | 商用コンテンツ非表示フラグ |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 固定メッセージのみ |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ドキュメントファイル不在 | index.mdが存在しない場合、空のインデックスを表示 |
| パブリック可視性制限 | 未ログイン時はログイン画面へリダイレクト |

## 備考

- `help_page_hide_commercial_content` 設定により、プロモーションリンクの表示を制御
- ドキュメントはMarkdown形式でレンダリング
- ドキュメント内の相対リンクは `/help/` プレフィックスに変換される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | help_controller.rb | `app/controllers/help_controller.rb` | 認証スキップ、Markdown処理を理解する |

**主要処理フロー**:
1. **4行目**: パブリック可視性制限がない場合は認証をスキップ
2. **14-23行目**: `index` アクションでドキュメントインデックスを読み込み
3. **20-22行目**: Markdownリンクを `/help/` プレフィックス付きに変換
4. **146-158行目**: `markdown_for` メソッドでMarkdownを読み込み・変換

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/help/index.html.haml` | レイアウト構造、条件分岐を理解する |

**主要処理フロー**:
- **2-5行目**: カスタムヘルプテキストの表示（存在する場合）
- **7-12行目**: タイトルとバージョン情報の表示
- **14-27行目**: GitLabの概要説明（商用コンテンツ非表示設定で制御）
- **29行目**: インスタンス設定リンク
- **32-35行目**: ドキュメントインデックスのMarkdownレンダリング
- **36-50行目**: クイックヘルプリンクカード

#### Step 3: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | help.rb | `config/routes/help.rb` | ヘルプ関連のルート定義を理解する |

**主要処理フロー**:
- **3行目**: `/help` -> `help#index`

### プログラム呼び出し階層図

```
HelpController
    │
    ├─ #index
    │      ├─ markdown_for(path_to_doc('index.md'))
    │      │      ├─ get_markdown_without_frontmatter
    │      │      └─ Gitlab::Help::HugoTransformer.transform
    │      │
    │      └─ リンク変換処理（gsub!）
    │
    └─ index.html.haml (View)
           ├─ Gitlab::CurrentSettings
           │      ├─ help_page_text
           │      └─ help_page_hide_commercial_content
           │
           ├─ markdown(@help_index)
           │
           └─ show_version_check?
                  └─ gitlab_version_check
```

### データフロー図

```
[入力]                    [処理]                         [出力]

doc/index.md         ───▶  HelpController#index      ───▶  ドキュメントインデックス
                          │
application_settings ───▶ │                          ───▶  カスタムヘルプテキスト
                          │
                          ▼
                    index.html.haml
                          │
                          └─ Markdown レンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| help_controller.rb | `app/controllers/help_controller.rb` | コントローラ | リクエスト処理、Markdown読み込み |
| index.html.haml | `app/views/help/index.html.haml` | ビュー | 画面テンプレート |
| help.rb | `config/routes/help.rb` | ルーティング | URLルート定義 |
| index.md | `doc/index.md` | ドキュメント | ドキュメントインデックス |
| hugo_transformer.rb | `lib/gitlab/help/hugo_transformer.rb` | ライブラリ | Markdown変換処理 |
