# 画面設計書 316-ヘルプ記事

## 概要

本ドキュメントは、GitLabにおけるヘルプ記事表示画面の設計仕様を定義するものである。

### 本画面の処理概要

ヘルプ記事画面は、GitLabに組み込まれたドキュメントを個別に表示するための画面である。Markdownファイルとして格納されたドキュメントをHTMLにレンダリングして表示するほか、画像やメディアファイルの配信も行う。

**業務上の目的・背景**：GitLabの各機能には詳細なドキュメントが用意されている。ユーザーが外部のドキュメントサイトにアクセスすることなく、インスタンス内で直接ドキュメントを参照できることで、コンテキスト切り替えのオーバーヘッドを削減し、作業効率を向上させる。また、オフライン環境やネットワーク制限のある環境でもドキュメントにアクセスできる利点がある。

**画面へのアクセス方法**：ヘルプトップページからのリンク、または直接URL `/help/{path}` にアクセスする。

**主要な操作・処理内容**：
1. Markdownドキュメントの表示
2. 画像・メディアファイルの配信
3. 外部ドキュメントサイトへのリダイレクト（設定による）

**画面遷移**：
- ヘルプトップページからの遷移
- ドキュメント内リンクによる他のヘルプ記事への遷移
- 外部ドキュメントサイトへのリダイレクト

**権限による表示制御**：
- パブリック可視性が制限されていない場合、未ログインでもアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 142 | ヘルプシステム | 主機能 | ヘルプ記事表示 |

## 画面種別

詳細/表示

## URL/ルーティング

- パス: `/help/*path`
- コントローラ: `HelpController#show`
- ルート定義: `config/routes/help.rb` (8行目)

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| path | 入力（URLパラメータ） | String | はい | ドキュメントのパス |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ドキュメント本文 | Markdown | レンダリングされたドキュメント内容 |
| ページタイトル | String | パスから生成されたタイトル |

## イベント仕様

この画面にはユーザー操作によるイベントは特になく、静的なドキュメント表示が主な機能である。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | application_settings | SELECT | ドキュメントベースURL設定を取得 |

### テーブル別更新項目詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | help_page_documentation_base_url | - | 外部ドキュメントURL |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 固定メッセージなし |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ファイル不在 | 404エラーページを表示 |
| 不正なフォーマット | 404エラーを返す |
| 外部URLへリダイレクト設定 | ドキュメントサイトへリダイレクト |

## 備考

- 対応フォーマット: markdown, md, html（ドキュメント）、png, gif, jpeg, mp4, mp3（メディア）
- ドキュメントのフロントマター（YAMLヘッダー）は除去される
- `gitlab_docs.enabled` 設定により外部ドキュメントサイトへリダイレクト可能
- `limit-container-width` クラスによりコンテンツ幅が制限される（流体レイアウトでない場合）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | help_controller.rb | `app/controllers/help_controller.rb` | showアクション、フォーマット処理を理解する |

**主要処理フロー**:
1. **25-51行目**: `show` アクションで複数フォーマットに対応
2. **26行目**: パスのサニタイズ（セキュリティ対策）
3. **28-35行目**: ドキュメントフォーマット（markdown, md, html）の処理
4. **38-46行目**: メディアフォーマット（png, gif, jpeg, mp4, mp3）の処理
5. **92-94行目**: 外部ドキュメントサイトへのリダイレクト判定

**読解のコツ**: `respond_to` ブロックでフォーマットごとの処理を分岐している。Markdownファイルは `render_documentation` メソッドで処理される。

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/help/show.html.haml` | シンプルなMarkdownレンダリング |

**主要処理フロー**:
- **1行目**: パスからページタイトルを生成
- **2行目**: 流体レイアウトでない場合にコンテンツ幅を制限
- **4-5行目**: Markdown本文をレンダリング

#### Step 3: Markdown処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | help_controller.rb | `app/controllers/help_controller.rb` | get_markdown_without_frontmatter メソッド |

**主要処理フロー**:
- **12行目**: YAMLフロントマター検出用の正規表現定義
- **79-90行目**: フロントマターを除去してMarkdownを取得
- **157行目**: HugoTransformerでMarkdownを変換

### プログラム呼び出し階層図

```
HelpController#show
    │
    ├─ Rack::Utils.clean_path_info (パスサニタイズ)
    │
    ├─ respond_to
    │      │
    │      ├─ format.any(:markdown, :md, :html)
    │      │      ├─ redirect_to_documentation_website?
    │      │      │      └─ documentation_url
    │      │      │
    │      │      └─ render_documentation
    │      │             ├─ path_to_doc
    │      │             ├─ markdown_for
    │      │             │      ├─ get_markdown_without_frontmatter
    │      │             │      └─ Gitlab::Help::HugoTransformer.transform
    │      │             │
    │      │             └─ render :show
    │      │
    │      └─ format.any(:png, :gif, :jpeg, :mp4, :mp3)
    │             └─ send_file
    │
    └─ format.any
           └─ head :not_found
```

### データフロー図

```
[入力]                    [処理]                         [出力]

/help/{path}         ───▶  HelpController#show       ───▶  HTMLドキュメント
                          │                               ｜
                          ├─ ドキュメントフォーマット    ├─ Markdownレンダリング
                          │      └─ markdown_for          │
                          │                               │
                          ├─ メディアフォーマット        ├─ ファイル配信
                          │      └─ send_file             │
                          │                               │
                          └─ 外部リダイレクト           └─ リダイレクト
                                 └─ redirect_to
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| help_controller.rb | `app/controllers/help_controller.rb` | コントローラ | リクエスト処理、Markdown読み込み |
| show.html.haml | `app/views/help/show.html.haml` | ビュー | 画面テンプレート |
| help.rb | `config/routes/help.rb` | ルーティング | URLルート定義 |
| hugo_transformer.rb | `lib/gitlab/help/hugo_transformer.rb` | ライブラリ | Markdown変換処理 |
| doc/ | `doc/` | ドキュメント | ドキュメントファイル格納ディレクトリ |
