# 画面設計書 317-インスタンス設定

## 概要

本ドキュメントは、GitLabにおけるインスタンス設定画面の設計仕様を定義するものである。

### 本画面の処理概要

インスタンス設定画面は、現在のGitLabインスタンスの構成情報を表示するための画面である。SSH設定、GitLab Pages、サイズ制限、パッケージレジストリ、レート制限、CI/CD制限など、インスタンス固有の設定値を一覧で確認できる。

**業務上の目的・背景**：GitLabインスタンスの管理者やユーザーは、システムの制限値や設定を把握する必要がある。例えば、アップロード可能なファイルサイズの上限、API呼び出しのレート制限、CI/CDジョブのタイムアウト値などを事前に確認することで、適切なシステム利用が可能になる。この画面は、そうした設定情報を集約して表示する。

**画面へのアクセス方法**：ヘルプトップページからの「Check the current instance configuration」リンク、または直接URL `/help/instance_configuration` にアクセスする。

**主要な操作・処理内容**：
1. SSH設定情報の表示（ホスト、ポート、フィンガープリント）
2. GitLab Pages設定の表示
3. サイズ制限の表示（添付ファイル、パッケージ、アーティファクトなど）
4. パッケージレジストリ設定の表示
5. レート制限の表示
6. CI/CD制限の表示
7. AI Gateway設定の表示（EE版のみ）

**画面遷移**：
- ヘルプトップページからの遷移
- この画面からの主要な遷移はなし

**権限による表示制御**：
- パブリック可視性が制限されていない場合、未ログインでもアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 114 | アプリケーション設定 | 主機能 | インスタンス設定情報表示 |

## 画面種別

一覧/情報表示

## URL/ルーティング

- パス: `/help/instance_configuration`
- コントローラ: `HelpController#instance_configuration`
- ルート定義: `config/routes/help.rb` (5行目)

## 入出力項目

なし（表示のみ）

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| SSH Host | String | SSHサーバーのホスト名 |
| SSH Port | Integer | SSHポート番号 |
| SSH Fingerprints | Object | SSHホストキーのフィンガープリント |
| GitLab Pages Domain | String | GitLab Pagesのドメイン |
| Size Limits | Object | 各種サイズ制限 |
| Package Registry Limits | Object | パッケージレジストリの制限 |
| Rate Limits | Object | APIなどのレート制限 |
| CI/CD Limits | Object | CI/CDジョブの制限 |
| AI Gateway | Object | AI Gateway設定（EE版のみ） |
| Table of Contents | List | ページ内目次 |

## イベント仕様

この画面にはユーザー操作によるイベントは存在しない。静的な情報表示のみ。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | application_settings | SELECT | 各種設定値を取得 |

### テーブル別更新項目詳細

#### application_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 各種設定カラム | - | InstanceConfigurationクラスで抽象化 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 固定メッセージのみ |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| パブリック可視性制限 | 未ログイン時はログイン画面へリダイレクト |

## 備考

- 各セクションはパーシャルテンプレートで分離されている
- EE版ではAI Gateway設定セクションが追加される
- 目次（Table of Contents）は動的に生成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | help_controller.rb | `app/controllers/help_controller.rb` | instance_configurationアクションを理解する |

**主要処理フロー**:
1. **60-62行目**: `instance_configuration` アクションでInstanceConfigurationオブジェクトを生成

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | instance_configuration.html.haml | `app/views/help/instance_configuration.html.haml` | 各セクションのパーシャル構成を理解する |

**主要処理フロー**:
- **1行目**: ページタイトル設定
- **8-13行目**: 各設定セクションのパーシャルをレンダリング
- **14行目**: EE版用AI Gatewayセクション（render_if_exists）
- **15-18行目**: 目次の表示
- **21行目**: 設定内容の表示

#### Step 3: パーシャルテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _ssh_info.html.haml | `app/views/help/instance_configuration/_ssh_info.html.haml` | SSH設定情報表示 |
| 3-2 | _gitlab_pages.html.haml | `app/views/help/instance_configuration/_gitlab_pages.html.haml` | GitLab Pages設定表示 |
| 3-3 | _size_limits.html.haml | `app/views/help/instance_configuration/_size_limits.html.haml` | サイズ制限表示 |
| 3-4 | _package_registry.html.haml | `app/views/help/instance_configuration/_package_registry.html.haml` | パッケージレジストリ設定表示 |
| 3-5 | _rate_limits.html.haml | `app/views/help/instance_configuration/_rate_limits.html.haml` | レート制限表示 |
| 3-6 | _ci_cd_limits.html.haml | `app/views/help/instance_configuration/_ci_cd_limits.html.haml` | CI/CD制限表示 |

#### Step 4: データモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | instance_configuration.rb | `lib/instance_configuration.rb` | 設定情報の取得ロジックを理解する |

### プログラム呼び出し階層図

```
HelpController#instance_configuration
    │
    └─ InstanceConfiguration.new
           │
           └─ 各設定情報の取得

instance_configuration.html.haml (View)
    │
    ├─ _ssh_info.html.haml
    │
    ├─ _gitlab_pages.html.haml
    │
    ├─ _size_limits.html.haml
    │
    ├─ _package_registry.html.haml
    │
    ├─ _rate_limits.html.haml
    │
    ├─ _ci_cd_limits.html.haml
    │
    └─ render_if_exists '_ai_gateway' (EE)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト           ───▶  HelpController              ───▶  設定情報ページ
                          │
                          ▼
                    InstanceConfiguration
                          │
                          ▼
                    application_settings
                    gitlab.yml
                    その他設定ソース
                          │
                          ▼
                    パーシャル群
                          │
                          └─ 各設定セクション表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| help_controller.rb | `app/controllers/help_controller.rb` | コントローラ | リクエスト処理 |
| instance_configuration.html.haml | `app/views/help/instance_configuration.html.haml` | ビュー | メインテンプレート |
| _ssh_info.html.haml | `app/views/help/instance_configuration/_ssh_info.html.haml` | パーシャル | SSH設定 |
| _gitlab_pages.html.haml | `app/views/help/instance_configuration/_gitlab_pages.html.haml` | パーシャル | GitLab Pages設定 |
| _size_limits.html.haml | `app/views/help/instance_configuration/_size_limits.html.haml` | パーシャル | サイズ制限 |
| _package_registry.html.haml | `app/views/help/instance_configuration/_package_registry.html.haml` | パーシャル | パッケージレジストリ |
| _rate_limits.html.haml | `app/views/help/instance_configuration/_rate_limits.html.haml` | パーシャル | レート制限 |
| _ci_cd_limits.html.haml | `app/views/help/instance_configuration/_ci_cd_limits.html.haml` | パーシャル | CI/CD制限 |
| instance_configuration.rb | `lib/instance_configuration.rb` | ライブラリ | 設定情報取得 |
| help.rb | `config/routes/help.rb` | ルーティング | URLルート定義 |
