# 画面設計書 318-ドロワー表示

## 概要

本ドキュメントは、GitLabにおけるヘルプドロワー表示画面の設計仕様を定義するものである。

### 本画面の処理概要

ヘルプドロワー表示画面は、コンテキストヘルプをドロワー形式で表示するためのエンドポイントである。画面の一部にサイドパネル（ドロワー）としてヘルプコンテンツを表示するために使用され、ユーザーが現在の作業コンテキストを離れることなくヘルプ情報を参照できる。

**業務上の目的・背景**：従来のヘルプシステムでは、ヘルプページに遷移することで作業コンテキストが失われていた。ドロワー表示により、ユーザーは現在の画面を維持したままサイドパネルでヘルプ情報を確認でき、作業効率が向上する。特に複雑な設定画面や新機能の説明など、即座に参照したい情報に適している。

**画面へのアクセス方法**：通常はJavaScriptから非同期で呼び出される。URL `/help/drawers/{markdown_file}` でアクセス可能だが、通常はUI内のヘルプボタンから呼び出される。

**主要な操作・処理内容**：
1. 指定されたMarkdownファイルを読み込む
2. フロントマターを除去してレンダリング
3. レイアウトなしでHTMLを返す

**画面遷移**：
- 任意の画面からドロワーとして表示
- ドロワーを閉じて元の画面に戻る

**権限による表示制御**：
- パブリック可視性が制限されていない場合、未ログインでもアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 142 | ヘルプシステム | 主機能 | ヘルプドロワー表示 |

## 画面種別

部分表示/ドロワー

## URL/ルーティング

- パス: `/help/drawers/*markdown_file`
- コントローラ: `HelpController#drawers`
- ルート定義: `config/routes/help.rb` (6行目)

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| markdown_file | 入力（URLパラメータ） | String | はい | 表示するMarkdownファイルのパス |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ドキュメント本文 | Markdown | レンダリングされたMarkdownコンテンツ |

## イベント仕様

この画面にはユーザー操作によるイベントは存在しない。非同期で読み込まれた結果を表示するのみ。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

この画面ではデータベースへのアクセスは発生しない。ファイルシステムからドキュメントを読み込む。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| - | - | 固定メッセージなし |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| ファイル不在 | 404エラーを返す（head :not_found） |
| パブリック可視性制限 | 未ログイン時はログイン画面へリダイレクト |

## 備考

- レイアウトなし（`layout: false`）でレンダリングされる
- レスポンスは1日間キャッシュされる
- フロントマター（YAMLヘッダー）を除去してからレンダリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラでのリクエスト処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | help_controller.rb | `app/controllers/help_controller.rb` | drawersアクションを理解する |

**主要処理フロー**:
1. **64-72行目**: `drawers` アクションの処理
2. **65行目**: パスのサニタイズ（セキュリティ対策）
3. **66行目**: Markdownファイルへのフルパスを生成
4. **68-72行目**: ファイル存在確認、レイアウトなしでレンダリングまたは404

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | drawers.html.haml | `app/views/help/drawers.html.haml` | キャッシュとMarkdownレンダリング |

**主要処理フロー**:
- **1行目**: `cache` ヘルパーで1日間キャッシュ
- **2行目**: `get_markdown_without_frontmatter` でフロントマターを除去してレンダリング

#### Step 3: ヘルパーメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | help_controller.rb | `app/controllers/help_controller.rb` | get_markdown_without_frontmatter メソッド |

**主要処理フロー**:
- **78-90行目**: YAMLフロントマターを除去し、titleがあれば見出しとして追加

### プログラム呼び出し階層図

```
HelpController#drawers
    │
    ├─ Rack::Utils.clean_path_info (パスサニタイズ)
    │
    ├─ path_to_doc (フルパス生成)
    │
    ├─ File.exist? (ファイル存在確認)
    │
    └─ render :drawers, formats: :html, layout: false
           │
           └─ drawers.html.haml
                  │
                  ├─ cache(@clean_path, expires_in: 1.day)
                  │
                  └─ markdown get_markdown_without_frontmatter(@path)
                         │
                         └─ フロントマター除去 & Markdownレンダリング
```

### データフロー図

```
[入力]                    [処理]                         [出力]

/help/drawers/{path} ───▶  HelpController#drawers   ───▶  HTML断片
                          │                               （レイアウトなし）
                          ▼
                    doc/{path}.md
                          │
                          ▼
                    get_markdown_without_frontmatter
                          │
                          ▼
                    Markdownレンダリング
                          │
                          ▼
                    キャッシュ (1日)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| help_controller.rb | `app/controllers/help_controller.rb` | コントローラ | リクエスト処理 |
| drawers.html.haml | `app/views/help/drawers.html.haml` | ビュー | 画面テンプレート |
| help.rb | `config/routes/help.rb` | ルーティング | URLルート定義 |
| doc/ | `doc/` | ドキュメント | Markdownファイル格納ディレクトリ |
