# 画面設計書 320-アクセス拒否

## 概要

本ドキュメントは、GitLabにおけるアクセス拒否エラー画面（403エラー）の設計仕様を定義するものである。

### 本画面の処理概要

アクセス拒否画面は、ユーザーがアクセス権限を持たないリソースにアクセスしようとした際に表示されるHTTP 403エラーページである。ユーザーに対してアクセスが拒否されたことを明確に伝え、GitLab管理者への問い合わせを案内する。

**業務上の目的・背景**：セキュリティの観点から、ユーザーには適切な権限がある機能やリソースにのみアクセスを許可する必要がある。権限がないリソースにアクセスしようとした場合、明確で親切なエラーメッセージを表示することで、ユーザーは状況を理解し、適切な対応（管理者への連絡など）を取ることができる。

**画面へのアクセス方法**：ユーザーがアクセス権限を持たないURLにアクセスしようとした場合に自動的に表示される。直接URL `/errors/access_denied` にアクセスすることも可能だが、通常はシステムによるリダイレクトで表示される。

**主要な操作・処理内容**：
1. エラーメッセージの表示
2. 「戻る」ボタンによる前のページへの遷移

**画面遷移**：
- 任意の画面からの自動リダイレクト
- 「Go Back」ボタンで前の画面へ戻る

**権限による表示制御**：
- 権限に関係なく表示可能（エラーページのため）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | アクセス拒否エラー画面表示 |

## 画面種別

エラー/403

## URL/ルーティング

- 表示条件: HTTP 403エラー発生時
- 実際のパス: 任意のパスで権限エラーが発生した場合に表示

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| message | 入力（ローカル変数） | String | いいえ | カスタムエラーメッセージ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| エラー画像 | Image | 403エラー用のイラスト |
| 見出し | String | 「403: You do not have the permission to access this page」 |
| 説明 | String | カスタムメッセージ（あれば）+ 管理者への問い合わせ案内 |
| 戻るボタン | Button | 前のページに戻るボタン（JavaScript必須） |

## イベント仕様

### 1-戻るボタン押下

「Go Back」ボタンを押下すると、ブラウザの履歴を使用して前のページに戻る。

**処理フロー**：
1. ボタン押下を検知
2. `history.back()` を実行
3. 前のページに遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

この画面ではデータベースへのアクセスは発生しない。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| エラー | 403: You do not have the permission to access this page | 常に表示 |
| エラー | Please contact your GitLab administrator to get permission. | 常に表示 |
| エラー | カスタムメッセージ | messageパラメータがある場合 |

## 例外処理

| 状態 | 処理内容 |
|------|----------|
| JavaScript無効 | 「Go Back」ボタンが非表示になる |

## 備考

- `js-go-back` クラスにより、JavaScript無効時はボタンが非表示
- Pajamas UI のButtonComponentを使用
- errorsレイアウトを使用
- フッターにはエラー共通のフッターパーシャルが表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューテンプレートを理解する

エラーページの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | access_denied.html.haml | `app/views/errors/access_denied.html.haml` | エラーページの構成を理解する |

**主要処理フロー**:
1. **1行目**: `local_assigns.fetch(:message, nil)` でカスタムメッセージを取得
2. **2行目**: `content_for(:title, 'Access Denied')` でページタイトル設定
3. **4-5行目**: エラー用のイラスト画像を表示
4. **6-7行目**: 403エラーの見出しを表示
5. **9-12行目**: カスタムメッセージと管理者連絡案内を表示
6. **13-15行目**: 「Go Back」ボタン（JavaScript有効時のみ表示）
7. **16行目**: エラー共通のフッターをレンダリング

#### Step 2: フッターパーシャルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _footer.html.haml | `app/views/errors/_footer.html.haml` | エラーページ共通のフッター |

#### Step 3: 使用されるUIコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ButtonComponent | `app/components/pajamas/button_component.rb` | PajamasのButtonコンポーネント |

### プログラム呼び出し階層図

```
権限エラー発生
    │
    └─ ApplicationController（または各コントローラ）
           │
           ├─ access_denied! / render_403
           │
           └─ errors/access_denied.html.haml
                  │
                  ├─ image_tag (エラーイラスト)
                  │
                  ├─ 見出し・メッセージ表示
                  │
                  ├─ Pajamas::ButtonComponent
                  │      └─ js-go-back (JavaScript制御)
                  │
                  └─ errors/_footer.html.haml
```

### データフロー図

```
[入力]                    [処理]                         [出力]

権限エラー           ───▶  エラーハンドリング         ───▶  403エラーページ
                          │
(message パラメータ) ───▶ │                          ───▶  カスタムメッセージ表示
                          │
                          ▼
                    access_denied.html.haml
                          │
                          └─ 静的なエラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| access_denied.html.haml | `app/views/errors/access_denied.html.haml` | ビュー | エラーページテンプレート |
| _footer.html.haml | `app/views/errors/_footer.html.haml` | パーシャル | エラーページフッター |
| button_component.rb | `app/components/pajamas/button_component.rb` | コンポーネント | ボタンUI |
| error-403-lg.svg | `app/assets/images/illustrations/error/error-403-lg.svg` | 画像 | エラーイラスト |
