# 画面設計書 321-Not Found

## 概要

本ドキュメントは、GitLabの「Not Found (404)」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ユーザーがアクセスしようとしたリソースが存在しない場合、または権限不足でリソースの存在を隠蔽する必要がある場合に表示されるエラー画面です。

**業務上の目的・背景**：ウェブアプリケーションにおいて、ユーザーが存在しないURLにアクセスした際、適切なエラーメッセージを表示し、ユーザーを正しいリソースへ誘導することは重要なユーザビリティの要素です。また、セキュリティ上の理由から、権限不足の場合でも404を返すことでリソースの存在を隠蔽し、不正アクセスのヒントを与えないようにしています。

**画面へのアクセス方法**：
- 存在しないURLへの直接アクセス
- 削除されたリソース（プロジェクト、イシュー等）へのアクセス
- 権限のないリソースへのアクセス（存在を隠蔽する場合）
- ActiveRecord::RecordNotFoundが発生した場合

**主要な操作・処理内容**：
1. エラーイラスト（error-404-lg.svg）の表示
2. 「404: Page not found」というエラータイトルの表示
3. ユーザーへのガイダンスメッセージの表示
4. 検索フォームの提供によるリソース探索の支援
5. ナビゲーションフッター（ホーム、サインアウト/サインイン、ヘルプ）の表示

**画面遷移**：
- 遷移元：任意の画面からのリンク切れ、または存在しないURLへの直接アクセス
- 遷移先：検索結果画面（検索実行時）、ホーム画面、サインイン画面、ヘルプ画面

**権限による表示制御**：
- ログイン状態に応じてフッターの表示が変化
  - ログイン中：「Sign out and sign in with a different account」リンク
  - 未ログイン：「Sign In / Register」リンク

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | ページ未検出エラー画面表示 |
| 102 | グローバル検索 | 補助機能 | 検索フォームからの検索実行 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（各種エラー発生時に表示）
- HTTPステータスコード: 404 Not Found
- レイアウト: `errors`

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| 検索キーワード | search | 入力 | String | - | プロジェクト、イシュー等の検索キーワード |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 404エラー用のSVGイラスト | illustrations/error/error-404-lg.svg |
| エラータイトル | 「404: Page not found」 | 固定文言（i18n対応） |
| ガイダンスメッセージ1 | アドレス確認・ページ移動に関する案内 | 固定文言（i18n対応） |
| ガイダンスメッセージ2 | 管理者への連絡案内 | 固定文言（i18n対応） |
| 検索フォーム | リソース検索用フォーム | - |
| フッターナビゲーション | ホーム、認証、ヘルプへのリンク | 動的生成 |

## イベント仕様

### 1-検索ボタン押下

- **トリガー**: Searchボタンのクリック
- **処理内容**: 入力されたキーワードでグローバル検索を実行
- **遷移先**: `/search?search={入力キーワード}`
- **HTTPメソッド**: GET

### 2-ホームリンククリック

- **トリガー**: フッターの「Home」リンクのクリック
- **処理内容**: ルートパスへ遷移
- **遷移先**: `/`

### 3-サインアウトリンククリック（ログイン時）

- **トリガー**: フッターの「Sign out and sign in with a different account」リンクのクリック
- **処理内容**: 非表示のフォームをsubmitしてサインアウト処理を実行
- **遷移先**: サインアウト後、ログイン画面へリダイレクト
- **HTTPメソッド**: POST

### 4-サインインリンククリック（未ログイン時）

- **トリガー**: フッターの「Sign In / Register」リンクのクリック
- **処理内容**: サインイン画面へ遷移
- **遷移先**: `/users/sign_in?redirect_to_referer=yes`

### 5-ヘルプリンククリック

- **トリガー**: フッターの「Help」リンクのクリック
- **処理内容**: ヘルプページへ遷移
- **遷移先**: `/help`

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 404_title | 404: Page not found | 常時 | エラー |
| 404_address | Make sure the address is correct and the page has not moved. | 常時 | 情報 |
| 404_contact | Please contact your GitLab administrator if you think this is a mistake. | 常時 | 情報 |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 検索キーワード未入力での検索 | 空の検索結果を表示（検索画面側で処理） |

## 備考

- 本画面は静的なエラー画面であり、エラーレイアウト(`layouts/errors`)を使用
- 国際化（i18n）対応済み。各テキストは`s_()`または`_()`で翻訳可能
- 検索フォームのプレースホルダー: "Search for projects, issues, etc."
- セキュリティ上、権限不足(403)の場合でも404として表示されることがある（`access_denied!`メソッドで制御）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的なエラー表示画面のため、特別なデータ構造はありません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_controller.rb | `app/controllers/application_controller.rb` | エラーハンドリングの仕組みを理解する |

**読解のコツ**: `rescue_from`ブロックでどのような例外がキャッチされ、どのようにエラー画面が表示されるかを確認する。

#### Step 2: エントリーポイントを理解する

エラー画面は例外発生時に`render_404`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | `render_404`メソッドの実装を確認 |

**主要処理フロー**:
1. **88-91行目**: `ActiveRecord::RecordNotFound`例外のハンドリング
2. **93-95行目**: `ActionController::UnknownFormat`例外のハンドリング
3. **141-143行目**: `not_found`メソッドの定義
4. **259-266行目**: `render_404`メソッドの実装

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | not_found.html.haml | `app/views/errors/not_found.html.haml` | 画面のHTMLレイアウトを理解する |
| 3-2 | _footer.html.haml | `app/views/errors/_footer.html.haml` | フッターナビゲーションの構造を理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定
- **2-8行目**: エラーコンテナ（イラスト、タイトル、メッセージ）の表示
- **9-14行目**: 検索フォームの表示
- **15行目**: フッターパーシャルの呼び出し

### プログラム呼び出し階層図

```
ApplicationController
    │
    ├─ rescue_from ActiveRecord::RecordNotFound
    │      └─ render_404
    │             └─ render "errors/not_found"
    │                    ├─ errors/not_found.html.haml
    │                    └─ errors/_footer.html.haml
    │
    ├─ rescue_from ActionController::UnknownFormat
    │      └─ render_404
    │
    └─ access_denied!(message = nil, status = nil)
           └─ status == :not_found
                  └─ render "errors/not_found"
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ 404エラー画面
  │                    │
  │                    ├─ RecordNotFound
  │                    ├─ UnknownFormat
  │                    └─ access_denied!(:not_found)
  │
  └──────────────────────▶ render_404
                               │
                               └─▶ errors/not_found.html.haml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| not_found.html.haml | `app/views/errors/not_found.html.haml` | テンプレート | 404エラー画面のメインビュー |
| _footer.html.haml | `app/views/errors/_footer.html.haml` | テンプレート | エラーページ共通フッター |
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | エラーハンドリングロジック |
| error-404-lg.svg | `app/assets/images/illustrations/error/error-404-lg.svg` | 画像 | 404エラー用イラスト |
| errors.scss | `app/assets/stylesheets/pages/errors.scss` | スタイル | エラーページ用CSS（推定） |
