# 画面設計書 322-サービス利用不可

## 概要

本ドキュメントは、GitLabの「サービス利用不可（503）」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、GitLabサービスが一時的に利用できない状態にある場合に表示されるエラー画面です。サーバーの過負荷、メンテナンス中、またはGitalyなどの依存サービスのリソース枯渇時に表示されます。

**業務上の目的・背景**：ウェブサービスにおいて、システムが一時的に利用できない状態をユーザーに適切に通知し、再試行を促すことは重要なユーザビリティの要素です。503エラーは「一時的な障害」を示し、しばらく待ってから再度アクセスすることで解決する可能性があることをユーザーに伝えます。

**画面へのアクセス方法**：
- サーバーの過負荷状態でのアクセス
- メンテナンス中のアクセス
- Gitaly等のリソース枯渇（ResourceExhaustedError）発生時
- 正規表現タイムアウト（Regexp::TimeoutError）発生時
- 外部サービスの応答遅延・障害時

**主要な操作・処理内容**：
1. エラーイラスト（error-503-lg.svg）の表示
2. 「503: We're sorry, GitLab is currently unavailable」というエラータイトルの表示
3. 動的メッセージがある場合はその表示（エラーの詳細情報）
4. 再試行を促すガイダンスメッセージの表示
5. 管理者への連絡案内の表示
6. ナビゲーションフッターの表示

**画面遷移**：
- 遷移元：任意の画面でのサービス障害発生時
- 遷移先：フッターからホーム画面、サインイン画面、ヘルプ画面へ遷移可能

**権限による表示制御**：
- ログイン状態に応じてフッターの表示が変化
  - ログイン中：「Sign out and sign in with a different account」リンク
  - 未ログイン：「Sign In / Register」リンク

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | サービス利用不可エラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（サービス障害発生時に表示）
- HTTPステータスコード: 503 Service Unavailable
- レイアウト: `errors`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 503エラー用のSVGイラスト | illustrations/error/error-503-lg.svg |
| エラータイトル | 「503: We're sorry, GitLab is currently unavailable」 | 固定文言（i18n対応） |
| 動的メッセージ | エラーの詳細情報（存在する場合のみ） | コントローラから渡されるmessage変数 |
| ガイダンスメッセージ1 | ページ再読み込みまたは戻って再試行を促す案内 | 固定文言（i18n対応） |
| ガイダンスメッセージ2 | 管理者への連絡案内 | 固定文言（i18n対応） |
| フッターナビゲーション | ホーム、認証、ヘルプへのリンク | 動的生成 |

## イベント仕様

### 1-ホームリンククリック

- **トリガー**: フッターの「Home」リンクのクリック
- **処理内容**: ルートパスへ遷移
- **遷移先**: `/`

### 2-サインアウトリンククリック（ログイン時）

- **トリガー**: フッターの「Sign out and sign in with a different account」リンクのクリック
- **処理内容**: 非表示のフォームをsubmitしてサインアウト処理を実行
- **遷移先**: サインアウト後、ログイン画面へリダイレクト
- **HTTPメソッド**: POST

### 3-サインインリンククリック（未ログイン時）

- **トリガー**: フッターの「Sign In / Register」リンクのクリック
- **処理内容**: サインイン画面へ遷移
- **遷移先**: `/users/sign_in?redirect_to_referer=yes`

### 4-ヘルプリンククリック

- **トリガー**: フッターの「Help」リンクのクリック
- **処理内容**: ヘルプページへ遷移
- **遷移先**: `/help`

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 503_title | 503: We're sorry, GitLab is currently unavailable | 常時 | エラー |
| 503_retry | Try refreshing the page, or going back and attempting the action again. | 常時 | 情報 |
| 503_contact | Please contact your GitLab administrator if you think this is a mistake. | 常時 | 情報 |
| dynamic_message | （コントローラから渡される動的メッセージ） | messageが存在する場合 | 情報 |

## 例外処理

本画面自体が例外処理の結果として表示される画面です。

| 例外状況 | 対応 |
|---------|------|
| Gitlab::Git::ResourceExhaustedError | render_503でメッセージ付きで表示 |
| Regexp::TimeoutError | head :service_unavailable |

## 備考

- 本画面は静的なエラー画面であり、エラーレイアウト(`layouts/errors`)を使用
- 国際化（i18n）対応済み。各テキストは`s_()`で翻訳可能
- 動的メッセージはオプションであり、コントローラから`message`変数として渡される場合のみ表示
- 404画面と異なり、検索フォームは表示されない（サービス自体が利用不可のため）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面に渡されるデータは`message`変数のみです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_controller.rb | `app/controllers/application_controller.rb` | render_503メソッドの引数を確認 |

**読解のコツ**: `render_503`メソッドがどのような状況で呼び出され、どのようなメッセージが渡されるかを確認する。

#### Step 2: エントリーポイントを理解する

503エラー画面は`render_503`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | `render_503`メソッドと例外ハンドリングを確認 |

**主要処理フロー**:
1. **127-130行目**: `Gitlab::Git::ResourceExhaustedError`例外のハンドリング
2. **132-135行目**: `Regexp::TimeoutError`例外のハンドリング
3. **268-273行目**: `render_503`メソッドの実装

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | service_unavailable.html.haml | `app/views/errors/service_unavailable.html.haml` | 画面のHTMLレイアウトを理解する |
| 3-2 | _footer.html.haml | `app/views/errors/_footer.html.haml` | フッターナビゲーションの構造を理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定
- **2-5行目**: エラーコンテナの開始とイラスト・タイトルの表示
- **6-8行目**: 動的メッセージの条件付き表示
- **9-12行目**: ガイダンスメッセージの表示
- **14行目**: フッターパーシャルの呼び出し

### プログラム呼び出し階層図

```
ApplicationController
    │
    ├─ rescue_from Gitlab::Git::ResourceExhaustedError
    │      └─ render_503(message)
    │             └─ render "errors/service_unavailable"
    │                    ├─ errors/service_unavailable.html.haml
    │                    └─ errors/_footer.html.haml
    │
    └─ rescue_from Regexp::TimeoutError
           └─ head :service_unavailable
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ 503エラー画面
  │                    │
  │                    ├─ ResourceExhaustedError
  │                    │      └─ message付きrender_503
  │                    │
  │                    └─ Regexp::TimeoutError
  │                           └─ headのみ
  │
  └──────────────────────▶ render_503(message = nil)
                               │
                               └─▶ errors/service_unavailable.html.haml
                                         │
                                         └─▶ message存在時: 動的メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| service_unavailable.html.haml | `app/views/errors/service_unavailable.html.haml` | テンプレート | 503エラー画面のメインビュー |
| _footer.html.haml | `app/views/errors/_footer.html.haml` | テンプレート | エラーページ共通フッター |
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | エラーハンドリングロジック |
| error-503-lg.svg | `app/assets/images/illustrations/error/error-503-lg.svg` | 画像 | 503エラー用イラスト |
