# 画面設計書 323-コンフリクト

## 概要

本ドキュメントは、GitLabの「リクエストコンフリクト（409）」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ユーザーのリクエストがサーバー側のリソース状態と競合した場合に表示されるエラー画面です。同時編集やリソースの状態変化により、リクエストが処理できない状況をユーザーに通知します。

**業務上の目的・背景**：ウェブアプリケーションにおいて、複数ユーザーによる同時操作や、リソースの状態が変化した後の古いリクエストが競合することがあります。409コンフリクトエラーは、このような状況をユーザーに適切に伝え、前のページに戻って再操作を促すためのものです。

**画面へのアクセス方法**：
- 同時編集による競合発生時
- リソースの状態が変化した後の操作実行時
- 楽観的ロック（Optimistic Locking）による競合検出時
- アプリケーションロジックで明示的にrender_409が呼び出された場合

**主要な操作・処理内容**：
1. エラーイラスト（error-409-lg.svg）の表示
2. 「409: There was a conflict with your request」というエラータイトルの表示
3. 動的メッセージがある場合はその表示（競合の詳細情報）
4. 管理者への連絡案内の表示
5. 「Go Back」ボタンの表示（JavaScriptで制御）
6. ナビゲーションフッターの表示

**画面遷移**：
- 遷移元：任意の操作での競合発生時
- 遷移先：「Go Back」ボタンで前のページへ戻る、またはフッターからホーム画面、サインイン画面、ヘルプ画面へ遷移可能

**権限による表示制御**：
- ログイン状態に応じてフッターの表示が変化
  - ログイン中：「Sign out and sign in with a different account」リンク
  - 未ログイン：「Sign In / Register」リンク

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | リクエストコンフリクトエラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（競合発生時に表示）
- HTTPステータスコード: 409 Conflict
- レイアウト: `errors`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 409エラー用のSVGイラスト | illustrations/error/error-409-lg.svg |
| エラータイトル | 「409: There was a conflict with your request」 | 固定文言（i18n対応） |
| 動的メッセージ | 競合の詳細情報（存在する場合のみ） | コントローラから渡されるmessage変数 |
| ガイダンスメッセージ | 管理者への連絡案内 | 固定文言（i18n対応） |
| Go Backボタン | 前のページに戻るボタン | JavaScript制御で表示 |
| フッターナビゲーション | ホーム、認証、ヘルプへのリンク | 動的生成 |

## イベント仕様

### 1-Go Backボタン押下

- **トリガー**: 「Go Back」ボタンのクリック
- **処理内容**: JavaScriptでブラウザの履歴を1つ戻る
- **遷移先**: 前のページ（ブラウザ履歴）
- **補足**: ボタンはJavaScriptで表示制御され、`hidden: true`で初期非表示、`.js-go-back`クラスで識別

### 2-ホームリンククリック

- **トリガー**: フッターの「Home」リンクのクリック
- **処理内容**: ルートパスへ遷移
- **遷移先**: `/`

### 3-サインアウトリンククリック（ログイン時）

- **トリガー**: フッターの「Sign out and sign in with a different account」リンクのクリック
- **処理内容**: 非表示のフォームをsubmitしてサインアウト処理を実行
- **遷移先**: サインアウト後、ログイン画面へリダイレクト
- **HTTPメソッド**: POST

### 4-サインインリンククリック（未ログイン時）

- **トリガー**: フッターの「Sign In / Register」リンクのクリック
- **処理内容**: サインイン画面へ遷移
- **遷移先**: `/users/sign_in?redirect_to_referer=yes`

### 5-ヘルプリンククリック

- **トリガー**: フッターの「Help」リンクのクリック
- **処理内容**: ヘルプページへ遷移
- **遷移先**: `/help`

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 409_title | 409: There was a conflict with your request | 常時 | エラー |
| 409_contact | Please contact your GitLab administrator if you think this is a mistake. | 常時 | 情報 |
| dynamic_message | （コントローラから渡される動的メッセージ） | messageが存在する場合 | 情報 |

## 例外処理

本画面自体が例外処理の結果として表示される画面です。

## 備考

- 本画面は静的なエラー画面であり、エラーレイアウト(`layouts/errors`)を使用
- 国際化（i18n）対応済み。各テキストは`s_()`または`_()`で翻訳可能
- 「Go Back」ボタンは初期状態で非表示（`hidden: true`）であり、JavaScriptで表示を制御
- `local_assigns.fetch(:message, nil)`でmessage変数の存在を安全に確認

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面に渡されるデータは`message`変数のみです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | request_conflict.html.haml | `app/views/errors/request_conflict.html.haml` | local_assignsによるmessage取得を確認 |

**読解のコツ**: HAMLテンプレートの1行目で`local_assigns.fetch(:message, nil)`を使用してmessageを安全に取得している点を確認する。

#### Step 2: エントリーポイントを理解する

409エラー画面は`render_409`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | `render_409`メソッドを確認 |

**主要処理フロー**:
1. **275-283行目**: `render_409`メソッドの実装
2. **278行目**: テンプレートとして`errors/request_conflict`を指定
3. **279行目**: localsでmessageを渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | request_conflict.html.haml | `app/views/errors/request_conflict.html.haml` | 画面のHTMLレイアウトを理解する |
| 3-2 | _footer.html.haml | `app/views/errors/_footer.html.haml` | フッターナビゲーションの構造を理解する |

**主要処理フロー**:
- **1行目**: message変数の取得（local_assignsから）
- **2行目**: ページタイトルの設定
- **4-7行目**: エラーコンテナの開始とイラスト・タイトルの表示
- **8-10行目**: 動的メッセージの条件付き表示
- **11-12行目**: ガイダンスメッセージの表示
- **13-15行目**: Go Backボタン（JavaScript制御）
- **16行目**: フッターパーシャルの呼び出し

### プログラム呼び出し階層図

```
ApplicationController
    │
    └─ render_409(message = nil)
           └─ render "errors/request_conflict"
                  ├─ errors/request_conflict.html.haml
                  │      ├─ message条件表示
                  │      └─ Go Backボタン（JS制御）
                  └─ errors/_footer.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ 409エラー画面
  │                    │
  │                    └─ 競合検出
  │                           └─ render_409(message)
  │
  └──────────────────────▶ render_409(message = nil)
                               │
                               └─▶ errors/request_conflict.html.haml
                                         │
                                         ├─▶ message存在時: 動的メッセージ表示
                                         └─▶ JS: Go Backボタン表示制御
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| request_conflict.html.haml | `app/views/errors/request_conflict.html.haml` | テンプレート | 409エラー画面のメインビュー |
| _footer.html.haml | `app/views/errors/_footer.html.haml` | テンプレート | エラーページ共通フッター |
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | エラーハンドリングロジック |
| error-409-lg.svg | `app/assets/images/illustrations/error/error-409-lg.svg` | 画像 | 409エラー用イラスト |
