# 画面設計書 324-Gitエラー

## 概要

本ドキュメントは、GitLabの「Git Resource Not Found（Git未検出）」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、リポジトリ内のブランチやコミットなどのGitリソースにアクセスできない場合に表示されるエラー画面です。リソースが移動・削除された場合や、参照が無効になった場合に表示されます。

**業務上の目的・背景**：GitLabはGitリポジトリを管理するシステムであり、ブランチやコミットへの参照が多数存在します。これらのリソースが削除・移動された場合、または強制プッシュによりコミットが参照できなくなった場合に、ユーザーに適切なエラーメッセージを表示することで、問題の原因を理解しやすくします。

**画面へのアクセス方法**：
- 削除されたブランチへのアクセス
- 存在しないコミットハッシュへのアクセス
- 強制プッシュにより失われたコミットへのアクセス
- リベース後の古いコミット参照へのアクセス
- アプリケーションで明示的にgit_not_found!が呼び出された場合

**主要な操作・処理内容**：
1. エラーイラスト（error-404-lg.svg）の表示
2. 「404: Git resource not found」というエラータイトルの表示
3. リソースが移動された可能性についてのガイダンスメッセージの表示

**画面遷移**：
- 遷移元：ブランチ・コミット参照を含むURLへの直接アクセス、または内部リンクからのアクセス
- 遷移先：なし（フッターなし）

**権限による表示制御**：
- 本画面には特別な権限制御はありません
- フッターが表示されないため、ログイン状態による表示差異はありません

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | Git未検出エラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（Gitリソース未検出時に表示）
- HTTPステータスコード: 404 Not Found
- レイアウト: `errors`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 404エラー用のSVGイラスト | illustrations/error/error-404-lg.svg |
| エラータイトル | 「404: Git resource not found」 | 固定文言（i18n対応） |
| ガイダンスメッセージ | リソースが移動された可能性についての案内 | 固定文言（i18n対応） |

## イベント仕様

本画面にはインタラクティブな要素がありません。フッターも表示されないため、ユーザーはブラウザの「戻る」ボタンまたはURLの直接入力で他のページに遷移する必要があります。

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 404_git_title | 404: Git resource not found | 常時 | エラー |
| 404_git_desc | Application cannot get access to a branch or commit in your repository. It might have been moved | 常時 | 情報 |

## 例外処理

本画面自体が例外処理の結果として表示される画面です。

## 備考

- 本画面はシンプルなエラー表示画面であり、フッターナビゲーションが省略されています
- 国際化（i18n）対応済み。各テキストは`s_()`で翻訳可能
- 404 Not Foundと同じイラスト（error-404-lg.svg）を使用していますが、メッセージがGit固有のものになっています
- 通常の404画面と比較して、検索フォームやフッターがない最小限の構成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的なエラー表示画面のため、特別なデータ構造はありません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_controller.rb | `app/controllers/application_controller.rb` | git_not_found!メソッドを確認 |

**読解のコツ**: `git_not_found!`メソッドがどのような状況で呼び出されるかを確認する。

#### Step 2: エントリーポイントを理解する

Gitリソース未検出画面は`git_not_found!`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | `git_not_found!`メソッドを確認 |

**主要処理フロー**:
1. **248-250行目**: `git_not_found!`メソッドの実装
2. **249行目**: テンプレートとして`errors/git_not_found`を指定、HTMLフォーマット、errorsレイアウト、404ステータス

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | git_not_found.html.haml | `app/views/errors/git_not_found.html.haml` | 画面のHTMLレイアウトを理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定（'Git Resource Not Found'）
- **3-8行目**: エラーコンテナ（イラスト、タイトル、メッセージ）の表示

### プログラム呼び出し階層図

```
コントローラ（各種）
    │
    └─ git_not_found!
           └─ render "errors/git_not_found"
                  └─ errors/git_not_found.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ Gitエラー画面
  │                    │
  │                    └─ Gitリソース未検出
  │                           └─ git_not_found!
  │
  └──────────────────────▶ render "errors/git_not_found"
                               │
                               └─▶ errors/git_not_found.html.haml
                                         │
                                         └─▶ シンプルなエラー表示
                                              （フッターなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| git_not_found.html.haml | `app/views/errors/git_not_found.html.haml` | テンプレート | Gitエラー画面のメインビュー |
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | git_not_found!メソッド |
| error-404-lg.svg | `app/assets/images/illustrations/error/error-404-lg.svg` | 画像 | 404エラー用イラスト（共用） |
