# 画面設計書 325-OmniauthError

## 概要

本ドキュメントは、GitLabの「OAuth認証エラー（422）」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、外部認証プロバイダ（OAuth、SAML等）を使用したサインイン処理が失敗した場合に表示されるエラー画面です。認証プロバイダとの連携エラーや、ユーザーアカウントの問題を通知し、再ログインやパスワードリカバリーへの導線を提供します。

**業務上の目的・背景**：GitLabはGitHub、Google、SAML等の外部認証プロバイダとの連携機能を持っています。これらの外部認証が失敗した場合、ユーザーに適切なエラー情報を提供し、代替手段（ローカルログイン、パスワードリカバリー）への誘導を行うことで、ユーザーがシステムにアクセスできるようにします。

**画面へのアクセス方法**：
- OAuth/SAML認証フローで認証プロバイダから返されたエラー
- ユーザー情報の検証失敗（メール未検証等）
- OmniAuthコールバック処理での`fail_login`呼び出し
- 認証プロバイダのUID不正（Auth0など）

**主要な操作・処理内容**：
1. エラーイラスト（error-422-lg.svg）の表示
2. 「422: Sign-in using {provider} auth failed」というエラータイトルの表示（プロバイダ名を動的表示）
3. エラー詳細メッセージの表示（@error変数から取得）
4. サインインできない場合の案内メッセージの表示
5. 「Sign in」ボタンでログイン画面への遷移
6. 「Recover password」ボタンでパスワードリカバリー画面への遷移

**画面遷移**：
- 遷移元：OmniAuthコールバックコントローラからのリダイレクト
- 遷移先：ログイン画面（Sign in）、パスワードリセット画面（Recover password）

**権限による表示制御**：
- 本画面は認証失敗時に表示されるため、通常は未ログイン状態でのみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 89 | OAuth2クライアント | 主機能 | OAuth認証エラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（OmniAuth認証失敗時に表示）
- HTTPステータスコード: 422 Unprocessable Entity
- レイアウト: `oauth_error`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 422エラー用のSVGイラスト | illustrations/error/error-422-lg.svg |
| エラータイトル | 「422: Sign-in using {provider} auth failed」 | @provider変数から動的生成（i18n対応） |
| エラー詳細 | 認証失敗の詳細メッセージ | @error変数 |
| ガイダンスメッセージ | サインインできない場合の案内 | 固定文言（i18n対応） |
| Sign inボタン | ログイン画面への遷移ボタン | - |
| Recover passwordボタン | パスワードリカバリー画面への遷移ボタン | - |

## イベント仕様

### 1-Sign inボタン押下

- **トリガー**: 「Sign in」ボタンのクリック
- **処理内容**: ログイン画面へ遷移
- **遷移先**: `/users/sign_in`
- **ボタンスタイル**: 確認ボタン（variant: :confirm）

### 2-Recover passwordボタン押下

- **トリガー**: 「Recover password」ボタンのクリック
- **処理内容**: パスワードリカバリー画面へ遷移
- **遷移先**: `/users/password/new`
- **ボタンスタイル**: デフォルト

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 422_title | 422: Sign-in using %{provider} auth failed | 常時 | エラー |
| 422_error | （@errorから取得した動的メッセージ） | 常時 | 情報 |
| 422_recovery | If you are unable to sign in or recover your password, contact a GitLab administrator. | 常時 | 情報 |

## 例外処理

本画面自体がOmniAuth認証失敗の結果として表示される画面です。

## 備考

- 本画面はOmniAuth認証専用のエラー画面であり、`oauth_error`レイアウトを使用
- 国際化（i18n）対応済み。各テキストは`_()`で翻訳可能
- @providerはOAuth認証プロバイダのラベル（例：「GitHub」「Google」）
- @errorはユーザーのバリデーションエラーまたは認証エラーの詳細
- OmniAuthCallbacksControllerの`fail_login`メソッドから呼び出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面に渡されるデータは`@provider`と`@error`変数です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | omniauth_callbacks_controller.rb | `app/controllers/omniauth_callbacks_controller.rb` | fail_loginメソッドで変数がセットされる仕組みを確認 |

**読解のコツ**: `fail_login`メソッドで`@provider`と`@error`がどのように設定されるかを確認する。

#### Step 2: エントリーポイントを理解する

OmniAuth認証エラー画面は`fail_login`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | omniauth_callbacks_controller.rb | `app/controllers/omniauth_callbacks_controller.rb` | `fail_login`メソッドを確認 |

**主要処理フロー**:
1. **343-350行目**: `fail_login`メソッドの実装
2. **344行目**: ログイン失敗のログ記録
3. **346行目**: @providerの設定（プロバイダラベルの取得）
4. **347行目**: @errorの設定（ユーザーのエラーメッセージ）
5. **349行目**: omniauth_errorテンプレートのレンダリング

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | omniauth_error.html.haml | `app/views/errors/omniauth_error.html.haml` | 画面のHTMLレイアウトを理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定（'Auth Error'）
- **3-6行目**: エラーコンテナの開始とイラスト・タイトルの表示
- **7-8行目**: @errorメッセージの表示
- **9-10行目**: ガイダンスメッセージの表示
- **11-17行目**: アクションボタン（Sign in、Recover password）の表示

### プログラム呼び出し階層図

```
OmniAuthCallbacksController
    │
    ├─ sign_in_user_flow
    │      └─ fail_login (認証失敗時)
    │
    └─ fail_login(user)
           ├─ log_failed_login
           ├─ @provider = Provider.label_for(...)
           ├─ @error = user.errors.full_messages.to_sentence
           └─ render 'errors/omniauth_error'
                  └─ errors/omniauth_error.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

OAuthコールバック ───▶ OmniAuthCallbacksController ───▶ OmniAuthError画面
  │                           │
  │                           ├─ 認証成功 → サインイン処理
  │                           │
  │                           └─ 認証失敗 → fail_login
  │                                  │
  │                                  ├─ @provider = プロバイダ名
  │                                  └─ @error = エラーメッセージ
  │
  └──────────────────────▶ render 'errors/omniauth_error'
                               │
                               └─▶ errors/omniauth_error.html.haml
                                         │
                                         ├─▶ プロバイダ名表示
                                         └─▶ エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| omniauth_error.html.haml | `app/views/errors/omniauth_error.html.haml` | テンプレート | OmniAuthエラー画面のメインビュー |
| omniauth_callbacks_controller.rb | `app/controllers/omniauth_callbacks_controller.rb` | ソース | OmniAuth認証コールバック処理 |
| oauth_error.html.haml | `app/views/layouts/oauth_error.html.haml` | レイアウト | OAuthエラー専用レイアウト（推定） |
| error-422-lg.svg | `app/assets/images/illustrations/error/error-422-lg.svg` | 画像 | 422エラー用イラスト |
