# 画面設計書 326-エンコーディングエラー

## 概要

本ドキュメントは、GitLabの「エンコーディングエラー（500）」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ファイルやコンテンツのエンコーディング処理で互換性エラーが発生した場合に表示されるエラー画面です。文字エンコーディングの不整合により、ページの正常な読み込みができない状況をユーザーに通知します。

**業務上の目的・背景**：GitLabはソースコードやテキストファイルを多数扱うシステムであり、様々なエンコーディング（UTF-8、Latin-1等）のファイルが混在することがあります。エンコーディング変換に失敗した場合、ユーザーに適切なエラーメッセージを表示し、問題の原因を理解しやすくします。

**画面へのアクセス方法**：
- 異なるエンコーディングの文字列を結合しようとした場合
- 不正なエンコーディングのファイルを表示しようとした場合
- Encoding::CompatibilityError例外が発生した場合

**主要な操作・処理内容**：
1. エラーイラスト（error-500-lg.svg）の表示
2. 「500: Encoding error」というエラータイトルの表示
3. エンコーディングエラーについてのガイダンスメッセージの表示

**画面遷移**：
- 遷移元：エンコーディングエラーが発生した任意のページ
- 遷移先：なし（フッターなし）

**権限による表示制御**：
- 本画面には特別な権限制御はありません
- フッターが表示されないため、ログイン状態による表示差異はありません

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | エンコーディングエラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（エンコーディングエラー発生時に表示）
- HTTPステータスコード: 500 Internal Server Error
- レイアウト: `errors`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 500エラー用のSVGイラスト | illustrations/error/error-500-lg.svg |
| エラータイトル | 「500: Encoding error」 | 固定文言（i18n対応） |
| ガイダンスメッセージ | エンコーディングエラーについての案内 | 固定文言（i18n対応） |

## イベント仕様

本画面にはインタラクティブな要素がありません。フッターも表示されないため、ユーザーはブラウザの「戻る」ボタンまたはURLの直接入力で他のページに遷移する必要があります。

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 500_enc_title | 500: Encoding error | 常時 | エラー |
| 500_enc_desc | Page cannot be loaded because of an encoding error. | 常時 | 情報 |

## 例外処理

本画面自体が`Encoding::CompatibilityError`例外の結果として表示される画面です。

## 備考

- 本画面はシンプルなエラー表示画面であり、フッターナビゲーションが省略されています
- 国際化（i18n）対応済み。各テキストは`s_()`で翻訳可能
- HTTPステータスコードは500（Internal Server Error）を返す
- 発生頻度は低いが、特殊なエンコーディングのファイルを扱う際に発生する可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的なエラー表示画面のため、特別なデータ構造はありません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application_controller.rb | `app/controllers/application_controller.rb` | rescue_fromによるエンコーディングエラーハンドリングを確認 |

**読解のコツ**: `Encoding::CompatibilityError`がどのようにキャッチされ、エラー画面が表示されるかを確認する。

#### Step 2: エントリーポイントを理解する

エンコーディングエラー画面はrescue_fromブロックから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | `rescue_from Encoding::CompatibilityError`を確認 |

**主要処理フロー**:
1. **83-86行目**: `Encoding::CompatibilityError`例外のハンドリング
2. **84行目**: 例外のログ記録
3. **85行目**: encodingテンプレートのレンダリング（errorsレイアウト、500ステータス）

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | encoding.html.haml | `app/views/errors/encoding.html.haml` | 画面のHTMLレイアウトを理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定（'Encoding Error'）
- **3-8行目**: エラーコンテナ（イラスト、タイトル、メッセージ）の表示

### プログラム呼び出し階層図

```
ApplicationController
    │
    └─ rescue_from Encoding::CompatibilityError
           ├─ log_exception(exception)
           └─ render "errors/encoding"
                  └─ errors/encoding.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ エンコーディングエラー画面
  │                    │
  │                    └─ Encoding::CompatibilityError発生
  │                           │
  │                           ├─ log_exception
  │                           └─ render "errors/encoding"
  │
  └──────────────────────▶ errors/encoding.html.haml
                               │
                               └─▶ シンプルなエラー表示
                                    （フッターなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| encoding.html.haml | `app/views/errors/encoding.html.haml` | テンプレート | エンコーディングエラー画面のメインビュー |
| application_controller.rb | `app/controllers/application_controller.rb` | ソース | 例外ハンドリング |
| error-500-lg.svg | `app/assets/images/illustrations/error/error-500-lg.svg` | 画像 | 500エラー用イラスト |
