# 画面設計書 327-事前条件失敗

## 概要

本ドキュメントは、GitLabの「事前条件失敗（412）」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、リクエストの事前条件が満たされていない場合に表示されるエラー画面です。無効なパラメータが渡された場合や、条件付きリクエストで条件が満たされなかった場合に表示されます。

**業務上の目的・背景**：HTTP 412 Precondition Failedは、クライアントから送信されたリクエストの前提条件がサーバー側で満たされていない場合に返されるステータスコードです。GitLabでは、無効なパラメータが渡された場合にこのエラー画面を表示し、ユーザーに問題を通知します。

**画面へのアクセス方法**：
- 無効なパラメータを含むリクエストの送信
- 条件付きリクエストで条件が満たされなかった場合
- If-Match、If-Unmodified-Since等のヘッダー条件が失敗した場合

**主要な操作・処理内容**：
1. エラーイラスト（error-422-lg.svg）の表示
2. 「412: Precondition failed」というエラータイトルの表示
3. 無効なパラメータについてのガイダンスメッセージの表示

**画面遷移**：
- 遷移元：事前条件が満たされなかった任意のリクエスト
- 遷移先：なし（フッターなし）

**権限による表示制御**：
- 本画面には特別な権限制御はありません
- フッターが表示されないため、ログイン状態による表示差異はありません

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 143 | ヘルスチェック | 主機能 | 事前条件失敗エラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（事前条件失敗時に表示）
- HTTPステータスコード: 412 Precondition Failed
- レイアウト: `errors`

## 入出力項目

本画面には入力項目はありません。

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 422エラー用のSVGイラスト（412でも流用） | illustrations/error/error-422-lg.svg |
| エラータイトル | 「412: Precondition failed」 | 固定文言（i18n対応） |
| ガイダンスメッセージ | 無効なパラメータについての案内 | 固定文言（i18n対応） |

## イベント仕様

本画面にはインタラクティブな要素がありません。フッターも表示されないため、ユーザーはブラウザの「戻る」ボタンまたはURLの直接入力で他のページに遷移する必要があります。

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 412_title | 412: Precondition failed | 常時 | エラー |
| 412_desc | Page cannot be loaded because of invalid parameters. | 常時 | 情報 |

## 例外処理

本画面自体が事前条件失敗の結果として表示される画面です。

## 備考

- 本画面はシンプルなエラー表示画面であり、フッターナビゲーションが省略されています
- 国際化（i18n）対応済み。各テキストは`s_()`で翻訳可能
- 注意：ページタイトルは「Encoding Error」となっているが、これはテンプレートのコピー時のミスと思われる（内容は412用）
- イラストは422エラー用（error-422-lg.svg）を流用している
- altテキストは「412」が設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は静的なエラー表示画面のため、特別なデータ構造はありません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | precondition_failed.html.haml | `app/views/errors/precondition_failed.html.haml` | テンプレートの構造を確認 |

**読解のコツ**: シンプルなエラー表示テンプレートのため、HAMLの基本構造を確認する程度で十分。

#### Step 2: エントリーポイントを理解する

事前条件失敗画面は、コントローラから明示的に呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | 各コントローラ | - | 412ステータスを返す箇所を確認 |

**主要処理フロー**:
- この画面を表示するための標準的なメソッドは確認できませんでした
- 個別のコントローラで必要に応じて直接レンダリングされると推測されます

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | precondition_failed.html.haml | `app/views/errors/precondition_failed.html.haml` | 画面のHTMLレイアウトを理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定（'Encoding Error' - ミスの可能性）
- **3-8行目**: エラーコンテナ（イラスト、タイトル、メッセージ）の表示

### プログラム呼び出し階層図

```
コントローラ（各種）
    │
    └─ render "errors/precondition_failed", status: :precondition_failed
           └─ errors/precondition_failed.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ コントローラ ───▶ 事前条件失敗画面
  │                    │
  │                    └─ 事前条件チェック失敗
  │                           │
  │                           └─ render "errors/precondition_failed"
  │
  └──────────────────────▶ errors/precondition_failed.html.haml
                               │
                               └─▶ シンプルなエラー表示
                                    （フッターなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| precondition_failed.html.haml | `app/views/errors/precondition_failed.html.haml` | テンプレート | 事前条件失敗画面のメインビュー |
| error-422-lg.svg | `app/assets/images/illustrations/error/error-422-lg.svg` | 画像 | 422エラー用イラスト（流用） |
