# 画面設計書 328-通知期限切れ

## 概要

本ドキュメントは、GitLabの「通知期限切れ（Expired link）」エラー画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、メール通知に含まれる購読解除リンクが期限切れまたは無効になった場合に表示されるエラー画面です。ユーザーがイシューやマージリクエストの通知を停止しようとした際、該当のリンクが使用できない状況を通知し、代替手段を案内します。

**業務上の目的・背景**：GitLabは、イシューやマージリクエストの更新をメールで通知する機能を持っています。これらの通知メールには購読解除リンクが含まれていますが、セキュリティ上の理由や時間経過により無効になることがあります。このエラー画面は、無効なリンクにアクセスした場合にユーザーに状況を説明し、検索機能を使って直接アイテムにアクセスして購読解除する方法を案内します。

**画面へのアクセス方法**：
- 期限切れの通知購読解除リンクへのアクセス
- 無効なSentNotification IDへのアクセス
- 購読解除の前提条件が満たされていない場合

**主要な操作・処理内容**：
1. エラーイラスト（status-fail-md.svg）の表示
2. 「Expired link」というエラータイトルの表示
3. リンクが無効になったことの説明メッセージの表示
4. 直接リンクを使用する案内メッセージの表示
5. 検索フォームの提供によるアイテム検索の支援
6. ナビゲーションフッターの表示

**画面遷移**：
- 遷移元：期限切れの通知購読解除リンク
- 遷移先：検索結果画面（検索実行時）、ホーム画面、サインイン画面、ヘルプ画面

**権限による表示制御**：
- ログイン状態に応じてフッターの表示が変化
  - ログイン中：「Sign out and sign in with a different account」リンク
  - 未ログイン：「Sign In / Register」リンク

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 137 | メール通知 | 主機能 | 通知期限切れエラー画面表示 |

## 画面種別

エラー表示

## URL/ルーティング

- 固定URLなし（期限切れリンクアクセス時に表示）
- HTTPステータスコード: 404 Not Found
- レイアウト: `errors`

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| 検索キーワード | search | 入力 | String | - | プロジェクト、イシュー等の検索キーワード |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| エラーイラスト | 失敗状態を示すSVGイラスト | illustrations/status/status-fail-md.svg |
| エラータイトル | 「Expired link」 | 固定文言（i18n対応） |
| ガイダンスメッセージ1 | 「This link is no longer valid.」 | 固定文言（i18n対応） |
| ガイダンスメッセージ2 | 直接リンクを使用する案内 | 固定文言（i18n対応） |
| 検索フォーム | リソース検索用フォーム | - |
| フッターナビゲーション | ホーム、認証、ヘルプへのリンク | 動的生成 |

## イベント仕様

### 1-検索ボタン押下

- **トリガー**: Searchボタンのクリック
- **処理内容**: 入力されたキーワードでグローバル検索を実行
- **遷移先**: `/search?search={入力キーワード}`
- **HTTPメソッド**: GET

### 2-ホームリンククリック

- **トリガー**: フッターの「Home」リンクのクリック
- **処理内容**: ルートパスへ遷移
- **遷移先**: `/`

### 3-サインアウトリンククリック（ログイン時）

- **トリガー**: フッターの「Sign out and sign in with a different account」リンクのクリック
- **処理内容**: 非表示のフォームをsubmitしてサインアウト処理を実行
- **遷移先**: サインアウト後、ログイン画面へリダイレクト
- **HTTPメソッド**: POST

### 4-サインインリンククリック（未ログイン時）

- **トリガー**: フッターの「Sign In / Register」リンクのクリック
- **処理内容**: サインイン画面へ遷移
- **遷移先**: `/users/sign_in?redirect_to_referer=yes`

### 5-ヘルプリンククリック

- **トリガー**: フッターの「Help」リンクのクリック
- **処理内容**: ヘルプページへ遷移
- **遷移先**: `/help`

## データベース更新仕様

### 操作別データベース影響一覧

本画面では、データベースの更新処理は発生しません。表示のみの画面です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| 404_expired_title | Expired link | 常時 | エラー |
| 404_expired_invalid | This link is no longer valid. | 常時 | 情報 |
| 404_expired_direct | Use a direct link to the item to unsubscribe. | 常時 | 情報 |

## 例外処理

本画面自体が例外的な状況（期限切れリンク）の結果として表示される画面です。

## 備考

- 本画面はエラーレイアウト(`layouts/errors`)を使用
- 国際化（i18n）対応済み。各テキストは`s_()`または`_()`で翻訳可能
- 検索フォームのプレースホルダー: "Search for projects, issues, etc."
- 他のエラー画面と異なり、ステータスイラスト（status-fail-md.svg）を使用
- SentNotificationsControllerの`render_expired_link`メソッドから呼び出される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知購読解除の仕組みを理解するために、SentNotificationモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sent_notifications_controller.rb | `app/controllers/sent_notifications_controller.rb` | 購読解除の前提条件と期限切れの判定を確認 |

**読解のコツ**: `unsubscribe_prerequisites_met?`メソッドで何がチェックされているかを確認する。

#### Step 2: エントリーポイントを理解する

期限切れリンク画面は`render_expired_link`メソッドから呼び出されます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sent_notifications_controller.rb | `app/controllers/sent_notifications_controller.rb` | `unsubscribe`アクションと`render_expired_link`メソッドを確認 |

**主要処理フロー**:
1. **16-22行目**: `unsubscribe`アクションの実装
2. **17行目**: 前提条件が満たされない場合にrender_expired_linkを呼び出し
3. **93-95行目**: `render_expired_link`メソッドの実装

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | expired_sent_notification.html.haml | `app/views/errors/expired_sent_notification.html.haml` | 画面のHTMLレイアウトを理解する |
| 3-2 | _footer.html.haml | `app/views/errors/_footer.html.haml` | フッターナビゲーションの構造を理解する |

**主要処理フロー**:
- **1行目**: ページタイトルの設定
- **2-8行目**: エラーコンテナ（イラスト、タイトル、メッセージ）の表示
- **9-14行目**: 検索フォームの表示
- **15行目**: フッターパーシャルの呼び出し

### プログラム呼び出し階層図

```
SentNotificationsController
    │
    └─ unsubscribe
           │
           ├─ unsubscribe_prerequisites_met? が false
           │      └─ render_expired_link
           │             └─ render "errors/expired_sent_notification"
           │                    ├─ errors/expired_sent_notification.html.haml
           │                    └─ errors/_footer.html.haml
           │
           └─ unsubscribe_prerequisites_met? が true
                  └─ 購読解除処理を実行
```

### データフロー図

```
[入力]               [処理]                    [出力]

購読解除リンク ───▶ SentNotificationsController ───▶ 期限切れ画面
  │                           │
  │                           ├─ SentNotification.for(id)
  │                           │
  │                           └─ unsubscribe_prerequisites_met?
  │                                  │
  │                                  ├─ false → render_expired_link
  │                                  │
  │                                  └─ true → 購読解除実行
  │
  └──────────────────────▶ errors/expired_sent_notification.html.haml
                               │
                               └─▶ エラー表示 + 検索フォーム
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| expired_sent_notification.html.haml | `app/views/errors/expired_sent_notification.html.haml` | テンプレート | 期限切れ通知画面のメインビュー |
| _footer.html.haml | `app/views/errors/_footer.html.haml` | テンプレート | エラーページ共通フッター |
| sent_notifications_controller.rb | `app/controllers/sent_notifications_controller.rb` | ソース | 購読解除処理のコントローラ |
| status-fail-md.svg | `app/assets/images/illustrations/status/status-fail-md.svg` | 画像 | 失敗状態用イラスト |
