# 画面設計書 329-不正利用報告

## 概要

本ドキュメントは、GitLabの「不正利用報告（Report abuse）」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、ユーザーが他のユーザーの不正利用（スパム、不適切な行動等）を管理者に報告するためのフォーム画面です。報告内容は管理者に通知され、適切な対応が取られます。

**業務上の目的・背景**：オンラインコミュニティにおいて、スパム投稿、フィッシング、著作権侵害、マルウェア配布などの不正行為が発生する可能性があります。GitLabでは、このような不正行為をユーザーが管理者に報告できる機能を提供し、コミュニティの健全性を維持します。報告されたユーザーは審査チームによるレビューを経て、必要に応じて対処されます。

**画面へのアクセス方法**：
- ユーザープロフィールページからの「Report abuse」リンク
- イシューやマージリクエストの報告メニュー
- コメントの報告機能
- AbuseReportsControllerのadd_categoryアクションを経由

**主要な操作・処理内容**：
1. 報告カテゴリの表示（読み取り専用）
2. 報告対象ユーザー情報の表示（読み取り専用）
3. 報告元URLの表示（読み取り専用）
4. スパムリンクの追加（オプション）
5. スクリーンショットのアップロード（オプション）
6. 報告メッセージの入力
7. 報告の送信

**画面遷移**：
- 遷移元：ユーザープロフィール、イシュー、マージリクエスト等からの報告アクション
- 遷移先：報告成功時はルートパス、キャンセル時は報告元URL

**権限による表示制御**：
- ログイン済みユーザーのみアクセス可能
- 報告対象ユーザーがBAN済みの場合はユーザーページへリダイレクト
- 報告対象ユーザーが削除済みの場合はルートパスへリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 139 | 監査イベント | 主機能 | 不正利用報告作成 |

## 画面種別

登録

## URL/ルーティング

- URL: `/-/abuse_reports` (POST)
- コントローラ: `AbuseReportsController#create`
- レイアウト: デフォルト

## 入出力項目

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| カテゴリ | category | 入力 | String | ○ | 報告カテゴリ（読み取り専用）：spam, offensive, phishing, crypto, credentials, copyright, malware, other |
| ユーザーID | user_id | 入力 | Integer | ○ | 報告対象ユーザーID（隠しフィールド） |
| 報告元URL | reported_from_url | 入力 | String | - | 報告元のURL（読み取り専用） |
| スパムリンク | links_to_spam | 入力 | Array | - | スパムコンテンツへのリンク（複数可） |
| スクリーンショット | screenshot | 入力 | File | - | 証拠となるスクリーンショット（1MB以下の画像） |
| メッセージ | message | 入力 | String | ○ | 報告の詳細説明 |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ページタイトル | 「Report abuse to administrator」 | 固定文言（i18n対応） |
| ページ説明 | 報告フォームの説明文 | 固定文言（i18n対応） |
| カテゴリ | 選択されたカテゴリ | @abuse_report.category |
| ユーザー名 | 報告対象ユーザーの名前とユーザー名 | @abuse_report.user |
| 報告元URL | 報告のきっかけとなったURL | @abuse_report.reported_from_url |

## イベント仕様

### 1-Send reportボタン押下

- **トリガー**: 「Send report」ボタンのクリック
- **処理内容**:
  1. フォームデータをAbuseReportsController#createに送信
  2. AntiAbuse::AbuseReport::CreateServiceでAbuseReportを作成
  3. 作成成功時はnotifyメソッドで管理者に通知
  4. Gitlab::Trackingでイベントを記録
- **遷移先**:
  - 成功時: ルートパス（成功メッセージ付き）
  - 失敗時: 同画面を再表示
- **HTTPメソッド**: POST

### 2-Cancelボタン押下

- **トリガー**: 「Cancel」ボタンのクリック
- **処理内容**: 報告元URLへ遷移
- **遷移先**: @abuse_report.reported_from_url

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Send report押下 | abuse_reports | INSERT | 不正利用報告レコードの作成 |

### テーブル別更新項目詳細

#### abuse_reports

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | reporter_id | current_user.id | 報告者のユーザーID |
| INSERT | user_id | フォームから | 報告対象ユーザーID |
| INSERT | category | フォームから | 報告カテゴリ |
| INSERT | message | フォームから | 報告メッセージ |
| INSERT | reported_from_url | フォームから | 報告元URL |
| INSERT | links_to_spam | フォームから | スパムリンク（配列） |
| INSERT | screenshot | フォームから | スクリーンショット（添付ファイル） |
| INSERT | organization_id | reporter.organization_id | 組織ID |
| INSERT | status | 1 (open) | デフォルトでオープン状態 |

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種別 |
|-------------|--------------|---------|------|
| success | Thank you for your report. A GitLab administrator will look into it shortly. | 報告成功時 | 成功 |
| invalid_user | Cannot create the abuse report. The reported user was invalid. Please try again or contact support. | ユーザーが無効な場合 | エラー |
| deleted_user | Cannot create the abuse report. The user has been deleted. | ユーザーが削除済みの場合 | エラー |
| banned_user | Cannot create the abuse report. This user has been banned. | ユーザーがBAN済みの場合 | エラー |
| already_reported | You have already reported this user | 同じユーザー・カテゴリで既に報告済みの場合 | バリデーションエラー |

## 例外処理

| 例外状況 | 対応 |
|---------|------|
| 報告対象ユーザーが存在しない | ルートパスへリダイレクト（エラーメッセージ付き） |
| 報告対象ユーザーがBAN済み | ユーザーページへリダイレクト（エラーメッセージ付き） |
| バリデーションエラー | フォームを再表示してエラーを表示 |
| スクリーンショットサイズ超過 | バリデーションエラーとして表示（1MB上限） |

## 備考

- 国際化（i18n）対応済み
- スクリーンショットは1MB以下の画像ファイルのみ許可
- リンクは最大20件まで追加可能
- 報告元URLは512文字まで
- フォームはjs-quick-submitクラスにより、Ctrl+Enterでも送信可能
- カテゴリは事前に選択されており、この画面では変更不可
- 報告作成時にGitlab::Trackingでイベントが記録される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

報告データの構造を理解するために、AbuseReportモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | abuse_report.rb | `app/models/abuse_report.rb` | モデルの構造、バリデーション、関連を確認 |

**読解のコツ**:
- `enum :category`でカテゴリの種類を確認
- バリデーションルール（message必須、URL長制限等）を確認
- `links_to_spam`の制限（最大20件）を確認

#### Step 2: エントリーポイントを理解する

報告フォームの表示と処理を行うコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | abuse_reports_controller.rb | `app/controllers/abuse_reports_controller.rb` | add_categoryとcreateアクションを確認 |

**主要処理フロー**:
1. **8-22行目**: `add_category`アクション - カテゴリ選択後にnewテンプレートを表示
2. **25-47行目**: `create`アクション - 報告の作成処理
3. **52-54行目**: `report_params` - 許可されるパラメータ
4. **57-66行目**: `set_user` - ユーザーの存在・BAN状態をチェック

#### Step 3: サービス層を理解する

報告作成のビジネスロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/anti_abuse/abuse_report/create_service.rb` | 報告作成処理を確認 |

**主要処理フロー**:
- **12-17行目**: `execute`メソッド - バリデーションと作成処理
- **22-26行目**: `create_abuse_report` - 実際のレコード作成

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.html.haml | `app/views/abuse_reports/new.html.haml` | フォームのHTMLレイアウトを理解する |

**主要処理フロー**:
- **1-4行目**: ページヘッダーと説明文
- **6行目**: フォーム開始（gitlab_ui_form_for）
- **11行目**: ユーザーID（隠しフィールド）
- **13-26行目**: 各入力フィールド（カテゴリ、ユーザー名、URL、スクリーンショット、メッセージ）
- **42-46行目**: 送信・キャンセルボタン

### プログラム呼び出し階層図

```
AbuseReportsController
    │
    ├─ add_category (GET)
    │      ├─ set_user (before_action)
    │      │      └─ User.find_by(id: params[:user_id])
    │      ├─ AbuseReport.new
    │      ├─ Gitlab::Tracking.event
    │      └─ render :new
    │
    └─ create (POST)
           ├─ AntiAbuse::AbuseReport::CreateService.new.execute
           │      └─ AbuseReport.new + save
           │
           ├─ 成功時
           │      ├─ @abuse_report.notify
           │      │      └─ AbuseReportMailer.notify.deliver_later
           │      ├─ Gitlab::Tracking.event
           │      └─ redirect_to root_path
           │
           └─ 失敗時
                  └─ render :new / redirect_to root_path
```

### データフロー図

```
[入力]               [処理]                    [出力]

カテゴリ選択 ───▶ add_category ───▶ newテンプレート表示
                       │
                       └─▶ @abuse_report (新規オブジェクト)

フォーム送信 ───▶ create ───▶ ルートパスへリダイレクト
  │                  │
  │                  ├─▶ CreateService.execute
  │                  │       │
  │                  │       └─▶ AbuseReport INSERT
  │                  │
  │                  └─▶ AbuseReportMailer.notify
  │                           │
  │                           └─▶ 管理者にメール通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/abuse_reports/new.html.haml` | テンプレート | 報告フォームのメインビュー |
| abuse_reports_controller.rb | `app/controllers/abuse_reports_controller.rb` | ソース | コントローラ |
| abuse_report.rb | `app/models/abuse_report.rb` | ソース | モデル |
| create_service.rb | `app/services/anti_abuse/abuse_report/create_service.rb` | ソース | 作成サービス |
| abuse_report_mailer.rb | `app/mailers/abuse_report_mailer.rb` | ソース | メーラー |
