# 画面設計書 333-OAuth認可完了

## 概要

本ドキュメントは、GitLabにおけるOAuth認可完了画面の設計仕様を定義する。

### 本画面の処理概要

OAuth認可完了画面は、OAuth2.0認可フロー（特にAuthorization Code Grant）において、ユーザーがアプリケーションへのアクセスを承認した後に表示される画面である。認可コードをユーザーに提示する。

**業務上の目的・背景**：OAuth2.0 Authorization Code Grantフローでは、ユーザーの承認後に認可コードが発行される。通常、この認可コードはコールバックURLにリダイレクトして渡されるが、コールバックURLがローカルホストや特殊な形式（例：`urn:ietf:wg:oauth:2.0:oob`）の場合、認可コードを画面に直接表示する必要がある。この画面は、CLIツールやデスクトップアプリケーションなど、ブラウザベースのコールバックが困難な環境での認証フローをサポートするために必要である。

**画面へのアクセス方法**：
1. 外部アプリケーションがGitLab OAuth認可エンドポイントにリダイレクト
2. ユーザーがログイン（必要な場合）
3. 認可画面でアプリケーションを承認
4. リダイレクトURIが`urn:ietf:wg:oauth:2.0:oob`形式の場合、本画面が表示される

**主要な操作・処理内容**：
1. 認可コード（Authorization Code）の表示
2. 認可コードのコピー（手動）
3. 外部アプリケーションへの認可コード入力

**画面遷移**：
- 遷移元：OAuth認可画面（No.9）
- 遷移先：なし（ユーザーは手動で外部アプリに戻る）

**権限による表示制御**：
- ログインユーザーのみアクセス可能
- 認可フロー経由でのみ到達可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | OAuth認可完了画面表示 |
| 76 | ユーザー登録 | 補助機能 | ユーザー認証状態の確認 |

## 画面種別

結果表示

## URL/ルーティング

| メソッド | パス | アクション |
|---------|------|-----------|
| GET | `/oauth/authorize` | `oauth/authorizations#create`（POST後のリダイレクト先） |

※本画面は認可フローの結果として表示され、直接URLアクセスは想定されない。

## 入出力項目

本画面は結果表示専用画面であり、ユーザー入力項目はない。

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| Authorization Code | 出力 | String | - | 認可コード |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| ページタイトル | 固定 | 見出し | "Authorization code:" |
| Authorization Code | params[:code] | コードブロック（モノスペース） | コピー可能なテキスト |

## イベント仕様

### 1-認可コードの手動コピー

**トリガー**: ユーザーが認可コードをテキスト選択

**処理内容**:
1. ユーザーがコードテキストを選択
2. ブラウザの標準コピー機能でクリップボードにコピー
3. 外部アプリケーションにペースト

**補足**: 本画面にはコピーボタンは実装されておらず、ユーザーが手動でテキストを選択してコピーする必要がある。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | oauth_access_grants | SELECT/INSERT | 認可グラントの発行（認可フロー内で） |

### テーブル別更新項目詳細

#### oauth_access_grants

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | token | 生成された認可コード | Doorkeeperにより自動生成 |
| INSERT | resource_owner_id | current_user.id | 認可したユーザー |
| INSERT | application_id | 認可されたアプリケーションのID | - |
| INSERT | scopes | 許可されたスコープ | - |
| INSERT | expires_in | 600（デフォルト10分） | 認可コードの有効期限 |
| INSERT | created_at | Time.current | - |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|-------------|---------------|---------|
| 見出し | - | Authorization code: | 常時表示 |

## 例外処理

| 例外状況 | 処理内容 | 表示/遷移先 |
|---------|---------|------------|
| 認可コードが無効 | 通常は発生しない | - |
| 未認証状態 | ログイン画面へリダイレクト | ログイン画面 |
| セッションタイムアウト | 認可フロー再開始 | OAuth認可画面 |

## 備考

- 認可コードは10分間のみ有効（デフォルト設定）
- 認可コードは1回のみ使用可能（使用後は無効化）
- この画面は `urn:ietf:wg:oauth:2.0:oob` や類似のout-of-band（OOB）リダイレクトURIを使用するアプリケーション向け
- モダンなOAuth実装ではPKCE（Proof Key for Code Exchange）の使用が推奨される
- 画面は最小限のレイアウト（`layout: false` で `minimal` レイアウト）で表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuth認可グラントのデータ構造を理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | doorkeeper.rb | `config/initializers/doorkeeper.rb` | 認可コード有効期限等の設定 |

**読解のコツ**: Doorkeeper gemのデフォルト設定と、GitLabでのカスタマイズ内容を比較して理解する。

#### Step 2: エントリーポイントを理解する

認可コントローラの処理フローを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | authorizations_controller.rb | `app/controllers/oauth/authorizations_controller.rb` | 認可フローの制御 |

**主要処理フロー**:
1. **行24-40**: `new`アクション - 認可リクエストの処理
2. **行26**: `skip_authorization?` - 自動認可判定
3. **行30**: `redirect`テンプレートレンダリング（OOBでない場合）
4. Doorkeeperの`create`アクション - 認可承認後の処理（親クラス）

#### Step 3: ビューテンプレートを理解する

シンプルな結果表示画面。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/doorkeeper/authorizations/show.html.haml` | 認可コード表示画面 |

**主要処理フロー**:
- **行1**: ページヘッダーコンポーネント「Authorization code:」
- **行2-3**: mainロール指定、codeタグ内に認可コード表示

### プログラム呼び出し階層図

```
OAuth認可フロー
    │
    ├─ GET /oauth/authorize (new)
    │      └─ AuthorizationsController#new
    │             ├─ verify_confirmed_email!
    │             ├─ verify_admin_allowed!
    │             └─ pre_auth.authorizable?
    │                    ├─ Yes: render "doorkeeper/authorizations/new" or redirect
    │                    └─ No: render "doorkeeper/authorizations/error"
    │
    └─ POST /oauth/authorize (create)
           └─ Doorkeeper::AuthorizationsController#create
                  ├─ authorization.authorize
                  ├─ 認可コード生成
                  └─ OOBリダイレクト判定
                         ├─ OOB: render "doorkeeper/authorizations/show"
                         └─ 通常: redirect to callback URL
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認可リクエスト ───▶ AuthorizationsController#create
                          │
                          ├─ authorization.authorize
                          │      └─ 認可コード生成
                          │
                          ├─ OOBリダイレクト判定
                          │      └─ redirect_uri == "urn:ietf:wg:oauth:2.0:oob"
                          │
                          └─ render show.html.haml ───▶ 認可コード表示
                                 └─ params[:code]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| authorizations_controller.rb | `app/controllers/oauth/authorizations_controller.rb` | コントローラ | 認可フロー制御 |
| show.html.haml | `app/views/doorkeeper/authorizations/show.html.haml` | テンプレート | 認可コード表示 |
| new.html.haml | `app/views/doorkeeper/authorizations/new.html.haml` | テンプレート | 認可確認画面 |
| redirect.html.haml | `app/views/doorkeeper/authorizations/redirect.html.haml` | テンプレート | リダイレクト画面 |
| doorkeeper.rb | `config/initializers/doorkeeper.rb` | 設定 | Doorkeeper設定 |
| PageHeadingComponent | `app/components/layouts/page_heading_component.rb` | コンポーネント | ページヘッダー |
