# 画面設計書 335-OAuth認可禁止

## 概要

本ドキュメントは、GitLabにおけるOAuth認可禁止画面の設計仕様を定義する。

### 本画面の処理概要

OAuth認可禁止画面は、管理者ユーザーが特定の危険なスコープを持つOAuthアプリケーションへの接続を試みた際に表示されるセキュリティ警告画面である。

**業務上の目的・背景**：GitLabインスタンスの管理者は、システム全体に影響を与える強力な権限を持つ。管理者がOAuthアプリケーションを認可すると、そのアプリケーションは管理者権限でAPIにアクセスできるようになる。これはセキュリティリスクとなるため、GitLabでは`disable_admin_oauth_scopes`設定を有効にすることで、管理者が特定の危険なスコープ（api、read_api、read_repository、write_repository、write_registry、read_registry、sudo）を持つアプリケーションを認可することを禁止できる。本画面は、この制限が適用された際にユーザーに明確な説明を提供するために必要である。

**画面へのアクセス方法**：
1. 管理者ユーザーがGitLabにログイン
2. 危険なスコープを持つOAuthアプリケーションの認可を試みる
3. `disable_admin_oauth_scopes`設定が有効な場合、本画面が表示される

**主要な操作・処理内容**：
1. 禁止理由の確認
2. 禁止されているスコープ一覧の確認
3. 設定変更方法の確認（APIを使用）

**画面遷移**：
- 遷移元：OAuth認可エンドポイントへのアクセス
- 遷移先：なし（認可はブロックされる）

**権限による表示制御**：
- 管理者ユーザーのみに表示される
- `disable_admin_oauth_scopes`設定が有効な場合のみ表示される
- 一般ユーザーには本画面は表示されない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | OAuth認可禁止画面表示 |
| 114 | アプリケーション設定 | 補助機能 | disable_admin_oauth_scopes設定 |

## 画面種別

エラー/警告表示

## URL/ルーティング

| メソッド | パス | アクション |
|---------|------|-----------|
| GET | `/oauth/authorize` | `oauth/authorizations#new`（禁止条件該当時にレンダリング） |

## 入出力項目

本画面は警告表示専用画面であり、ユーザー入力項目はない。

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|-------------|---------|------|
| ページタイトル | 固定 | 見出し | "Forbidden" |
| 警告アイコン | sprite_icon | SVGアイコン | warning-solid |
| 禁止メッセージ | 固定 | 段落テキスト | 禁止されているスコープと設定変更方法 |

## イベント仕様

本画面にはユーザー操作可能なイベントはない。警告情報の表示のみ。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | - | - | データベース更新なし |

本画面は警告表示のみであり、データベースへの書き込みは行わない。

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 | 表示条件 |
|------|-------------|---------------|---------|
| 見出し | - | Forbidden | 常時表示 |
| 警告 | - | Administrators are not permitted to connect applications with these scopes: `api`, `read_api`, `read_repository`, `write_repository`, `write_registry`, `read_registry`, and `sudo`. To permit this, change the `disable_admin_oauth_scopes` setting using the API. | 常時表示 |

### 禁止されるスコープ一覧

| スコープ | 説明 |
|---------|------|
| api | フルAPIアクセス |
| read_api | APIの読み取りアクセス |
| read_repository | リポジトリの読み取りアクセス |
| write_repository | リポジトリの書き込みアクセス |
| write_registry | コンテナレジストリの書き込みアクセス |
| read_registry | コンテナレジストリの読み取りアクセス |
| sudo | sudoスコープ（他ユーザーとしてのアクション実行） |

## 例外処理

本画面自体がエラー/禁止状態を表す画面であり、追加の例外処理は不要。

## 備考

- 本画面は管理者アカウントのセキュリティを保護するための機能
- `disable_admin_oauth_scopes`設定はAPIを通じてのみ変更可能（UI経由では変更不可）
- trustedとマークされたアプリケーションはこの制限の対象外
- 管理者モード（Admin Mode）が有効な場合でも、この制限は適用される
- 警告アイコン（warning-solid）が表示され、視覚的に注意を促す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定とスコープの関係を理解。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gitlab/auth.rb | `lib/gitlab/auth.rb` | スコープ定義（API_SCOPES, REPOSITORY_SCOPES等） |
| 1-2 | current_settings.rb | `app/models/application_setting.rb` | disable_admin_oauth_scopes設定 |

**読解のコツ**: Gitlab::Authモジュールで定義されているスコープ定数（API_SCOPE, READ_API_SCOPE, ADMIN_SCOPES, REPOSITORY_SCOPES, REGISTRY_SCOPES）を理解することで、禁止判定ロジックが明確になる。

#### Step 2: エントリーポイントを理解する

禁止判定のロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | authorizations_controller.rb | `app/controllers/oauth/authorizations_controller.rb` | verify_admin_allowed!、disallow_connect?、dangerous_scopes? |

**主要処理フロー**:
1. **行14**: `verify_admin_allowed!` がbefore_actionで呼ばれる
2. **行150-152**: `verify_admin_allowed!` - disallow_connect?判定
3. **行154-157**: `disallow_connect?` - 管理者かつ設定有効かつ危険スコープの場合true
4. **行159-165**: `dangerous_scopes?` - アプリケーションが危険なスコープを持つか判定

#### Step 3: ビューテンプレートを理解する

警告表示画面。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | forbidden.html.haml | `app/views/doorkeeper/authorizations/forbidden.html.haml` | 禁止画面テンプレート |

**主要処理フロー**:
- **行1**: ページヘッダー「Forbidden」
- **行2-5**: mainロール、段落内に警告アイコンとメッセージ
- **行5**: html_safeでcodeタグを含むメッセージを表示

### プログラム呼び出し階層図

```
GET /oauth/authorize
    │
    └─ AuthorizationsController#new
           │
           └─ verify_admin_allowed! (before_action)
                  │
                  └─ disallow_connect?
                         │
                         ├─ current_user.admin? ─────────────────────┐
                         │                                           │
                         ├─ Gitlab::CurrentSettings.disable_admin_oauth_scopes
                         │                                           │
                         └─ dangerous_scopes?                        │
                                │                                    │
                                ├─ doorkeeper_application&.includes_scope?
                                │      ├─ API_SCOPE
                                │      ├─ READ_API_SCOPE
                                │      ├─ ADMIN_SCOPES
                                │      ├─ REPOSITORY_SCOPES
                                │      └─ REGISTRY_SCOPES
                                │
                                └─ !doorkeeper_application&.trusted?
                                       │
                                       └─ すべてtrue → render "forbidden"
```

### データフロー図

```
[入力]                    [処理]                         [出力]

認可リクエスト ───▶ AuthorizationsController#new
    │                      │
    │                      ├─ current_user.admin?
    │                      │      └─ 管理者判定
    │                      │
    │                      ├─ Gitlab::CurrentSettings.disable_admin_oauth_scopes
    │                      │      └─ 設定値取得
    │                      │
    │                      ├─ doorkeeper_application.includes_scope?(危険スコープ)
    │                      │      └─ スコープ判定
    │                      │
    │                      ├─ !doorkeeper_application.trusted?
    │                      │      └─ 信頼済みアプリでないことを確認
    │                      │
    │                      └─ 全条件一致
    │                             └─ render "forbidden" ───▶ forbidden.html.haml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| authorizations_controller.rb | `app/controllers/oauth/authorizations_controller.rb` | コントローラ | 禁止判定ロジック |
| forbidden.html.haml | `app/views/doorkeeper/authorizations/forbidden.html.haml` | テンプレート | 禁止画面表示 |
| auth.rb | `lib/gitlab/auth.rb` | ライブラリ | スコープ定義 |
| application_setting.rb | `app/models/application_setting.rb` | モデル | 設定管理 |
| PageHeadingComponent | `app/components/layouts/page_heading_component.rb` | コンポーネント | ページヘッダー |
| sprite_icon | ヘルパー | ヘルパー | SVGアイコン表示 |
