# 画面設計書 4-ユーザー登録画面

## 概要

本ドキュメントは、GitLabのユーザー登録画面の設計仕様を記載したものです。新規ユーザーがアカウントを作成するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー登録画面は、新規ユーザーがGitLabシステムにアカウントを作成するための入口を提供します。セルフサービスでのアカウント作成を可能にすることで、管理者の負担を軽減しながらユーザー数を拡大できます。また、招待メール経由での登録や、OAuthプロバイダーを使用したソーシャルログインにも対応しており、ユーザーの利便性を高めています。スパム対策としてreCAPTCHAやInvisible Captchaを実装し、悪意のある大量登録を防止しています。

**画面へのアクセス方法**：
- ログイン画面の「Register now」リンクをクリック
- 直接 `/users/sign_up` URLにアクセス
- 招待メール内のリンクをクリック（招待メールアドレスが事前入力される）

**主要な操作・処理内容**：
1. 姓名の入力
2. ユーザー名の入力と利用可能性チェック
3. メールアドレスの入力
4. パスワードの入力と複雑性検証
5. reCAPTCHA/Invisible Captchaの完了
6. 利用規約への同意
7. アカウント作成処理
8. OAuthプロバイダーを使用した登録（任意）

**画面遷移**：
- 遷移元：ログイン画面、招待メール、直接アクセス
- 遷移先：メール確認待ち画面（メール確認が必要な場合）、ダッシュボード（即時ログイン許可の場合）、承認待ち画面（管理者承認が必要な場合）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- サインアップが無効化されている場合はアクセス不可
- 招待経由の場合はメールアドレスが事前入力され編集不可
- 管理者承認が必要な設定の場合は承認待ち状態でアカウントが作成される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | ユーザー登録 | 主機能 | 新規ユーザーアカウントの作成処理 |
| 137 | メール通知 | 補助機能 | 登録確認メールの送信 |

## 画面種別

登録フォーム

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/sign_up` | ユーザー登録画面表示 |
| POST | `/users` | ユーザー登録処理 |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 名 | new_user[first_name] | string | Yes | 127 | ユーザーの名（MAX_NAME_LENGTH） |
| 姓 | new_user[last_name] | string | Yes | 127 | ユーザーの姓（MAX_NAME_LENGTH） |
| ユーザー名 | new_user[username] | string | Yes | 255 | 一意のユーザー名 |
| メールアドレス | new_user[email] | string | Yes | 255 | メールアドレス（招待時は固定） |
| パスワード | new_user[password] | string | Yes | 128 | パスワード |
| reCAPTCHA | - | token | 条件付き | - | reCAPTCHA有効時に必要 |
| Invisible Captcha | - | hidden | - | - | スパム対策用隠しフィールド |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| 姓名入力フォーム | 姓名入力欄（2カラム） | 常時表示 |
| ユーザー名入力 | ユーザー名入力欄（利用可能性リアルタイムチェック） | 常時表示 |
| メールアドレス入力 | メールアドレス入力欄 | 招待以外 |
| メールアドレス表示 | 招待されたメールアドレス（固定表示） | 招待時 |
| パスワード入力 | パスワード入力欄 | 常時表示 |
| パスワード要件リスト | パスワードの複雑性要件表示 | EE機能有効時 |
| reCAPTCHA | ボット対策用ウィジェット | reCAPTCHA設定時 |
| 利用規約同意文言 | 利用規約へのリンク付き同意文言 | 常時表示 |
| Continueボタン | 登録実行ボタン | 常時表示 |
| OAuthボタン群 | 外部認証プロバイダボタン | OAuth設定時 |
| Sign inリンク | ログイン画面へのリンク | 常時表示 |

## イベント仕様

### 1-Continueボタン押下

**トリガー**: 「Continue」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. Invisible Captcha検証
3. reCAPTCHA検証（設定時）
4. レート制限チェック
5. 姓名の空白チェック
6. ユーザー名の利用可能性チェック
7. パスワード複雑性検証
8. ユーザーレコード作成
9. 利用規約への同意記録（設定時）
10. システムフック実行
11. 確認メール送信（または即時ログイン）

**成功時**:
- メール確認が必要な場合: メール確認待ち画面にリダイレクト
- ソフト確認の場合: ダッシュボードにリダイレクト
- 管理者承認が必要な場合: ログイン画面に戻り承認待ちメッセージを表示

**失敗時**: エラーメッセージを表示してフォームに戻る

### 2-ユーザー名入力

**トリガー**: ユーザー名フィールドへの入力

**処理フロー**:
1. 入力形式の検証（英数字、アンダースコア、ハイフン）
2. 最大長チェック（255文字）
3. APIによる利用可能性チェック（非同期）
4. 結果表示（利用可能/利用不可/確認中）

### 3-OAuthボタン押下

**トリガー**: OAuthプロバイダボタンクリック

**処理フロー**:
1. OAuthプロバイダの認可エンドポイントにリダイレクト
2. ユーザーが外部サービスで認証・認可
3. コールバックURLで認証コードを受信
4. アクセストークン取得
5. ユーザー情報取得
6. アカウント作成またはリンク

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ユーザー登録成功 | users | INSERT | ユーザーレコード作成 |
| ユーザー登録成功 | emails | INSERT | プライマリメール作成 |
| ユーザー登録成功 | user_preferences | INSERT | ユーザー設定初期化 |
| ユーザー登録成功 | namespaces | INSERT | 個人名前空間作成 |
| 利用規約同意 | term_agreements | INSERT | 利用規約同意記録 |
| 招待承諾 | members | UPDATE | 招待ステータス更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | username | 入力値 | 一意制約 |
| INSERT | email | 入力値 | 一意制約 |
| INSERT | name | first_name + " " + last_name | 表示名 |
| INSERT | encrypted_password | bcryptハッシュ | - |
| INSERT | state | active または blocked_pending_approval | 設定による |
| INSERT | confirmation_token | Deviseトークン | メール確認用 |
| INSERT | confirmation_sent_at | 現在時刻 | - |
| INSERT | organization_id | デフォルト組織ID | - |
| INSERT | preferred_language | ブラウザ言語または設定言語 | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | 成功 | A message with a confirmation link has been sent... | 登録成功時（メール確認必要） |
| MSG002 | 成功 | Your account is pending approval from your GitLab administrator | 承認待ち時 |
| MSG003 | エラー | Email has already been taken | メールアドレス重複時 |
| MSG004 | エラー | Username has already been taken | ユーザー名重複時 |
| MSG005 | エラー | Password is too short | パスワード短すぎ時 |
| MSG006 | エラー | There was an error with the reCAPTCHA | reCAPTCHA失敗時 |
| MSG007 | エラー | First name cannot be blank | 名が空白時 |
| MSG008 | エラー | Last name cannot be blank | 姓が空白時 |
| MSG009 | エラー | Sign-ups are currently disabled | サインアップ無効時 |
| MSG010 | 説明 | We recommend a work email address. | メールアドレス入力の説明 |
| MSG011 | 検証中 | Checking username availability... | ユーザー名検証中 |
| MSG012 | 成功 | Username is available. | ユーザー名利用可能時 |
| MSG013 | エラー | Username is already taken. | ユーザー名利用不可時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| サインアップ無効 | ログイン画面にリダイレクトしエラーメッセージを表示 |
| メールアドレス重複 | エラーメッセージを表示してフォームに戻る |
| ユーザー名重複 | エラーメッセージを表示してフォームに戻る |
| レート制限超過 | エラーメッセージを表示してフォームに戻る |
| reCAPTCHA失敗 | エラーメッセージを表示してフォームに戻る |
| 招待期限切れ | エラーメッセージを表示してログイン画面にリダイレクト |

## 備考

- Invisible Captchaは管理者設定で有効化される
- ユーザー名の利用可能性チェックはデバウンス処理でAPI呼び出し回数を制限
- 招待経由の登録では確認メールがスキップされる場合がある
- 管理者承認設定が有効な場合、ユーザーは `blocked_pending_approval` 状態で作成される
- 利用規約が設定されている場合、登録時に自動的に同意が記録される
- OAuthプロバイダーでの登録時も利用規約への同意が必要
- 絵文字ブロック（js-block-emoji）により姓名での絵文字入力を防止

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザー登録に関連するモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseモジュール、バリデーション、状態管理 |

**読解のコツ**: `BLOCKED_PENDING_APPROVAL_STATE` 定数（53行目）が承認待ち状態を定義する。

#### Step 2: エントリーポイントを理解する

コントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | registrations_controller.rb | `app/controllers/registrations_controller.rb` | new/createアクション、before_actionフィルター |

**主要処理フロー**:
1. **20-21行目**: `check_captcha` - reCAPTCHA検証
2. **21行目**: `ensure_first_name_and_last_name_not_empty` - 姓名検証
3. **25-28行目**: レート制限と招待メール設定
4. **29行目**: `ensure_signup_enabled` - サインアップ有効性確認
5. **40-59行目**: `create` アクション - ユーザー作成処理
6. **107-113行目**: `after_successful_create_hook` - 登録後フック処理

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/registrations/new.html.haml` | 全体構成 |
| 3-2 | _signup_box_form.html.haml | `app/views/devise/registrations/_signup_box_form.html.haml` | フォーム詳細 |

**主要処理フロー**:
- **_signup_box_form.html.haml 20-42行目**: 姓名入力フィールド
- **_signup_box_form.html.haml 43-56行目**: ユーザー名入力と検証
- **_signup_box_form.html.haml 57-70行目**: メールアドレス入力
- **_signup_box_form.html.haml 71-73行目**: パスワード入力

### プログラム呼び出し階層図

```
RegistrationsController#create
    │
    ├─ check_captcha (prepend_before_action)
    │      └─ verify_recaptcha
    │
    ├─ ensure_first_name_and_last_name_not_empty (before_action)
    │
    ├─ ensure_signup_enabled (before_action)
    │      └─ Gitlab::CurrentSettings.signup_enabled?
    │
    ├─ set_resource_fields
    │      └─ resource.state = BLOCKED_PENDING_APPROVAL_STATE (条件付き)
    │
    ├─ Devise::RegistrationsController#create (super)
    │      ├─ Users::RegistrationsBuildService.execute
    │      │      └─ User.new(params)
    │      │
    │      └─ resource.save
    │             └─ users テーブル INSERT
    │
    └─ after_successful_create_hook
           ├─ accept_pending_invitations
           ├─ persist_accepted_terms_if_required
           ├─ execute_system_hooks
           │      └─ SystemHooksService.execute_hooks_for
           │
           ├─ notify_new_instance_access_request (承認待ち時)
           │      └─ NotificationService.new_instance_access_request
           │
           └─ track_successful_user_creation
```

### データフロー図

```
[入力]                         [処理]                              [出力]

new_user[first_name]  ───▶ RegistrationsController#create ───▶ リダイレクト
new_user[last_name]          │
new_user[username]           ├─ Users::RegistrationsBuildService
new_user[email]              │      └─ User.new(params)
new_user[password]           │
                             ├─ resource.save
                             │      └─ users テーブル INSERT
                             │         namespaces テーブル INSERT
                             │         emails テーブル INSERT
                             │
                             └─ DeviseMailer.confirmation_instructions
                                    └─ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| registrations_controller.rb | `app/controllers/registrations_controller.rb` | コントローラー | ユーザー登録処理の制御 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータと認証ロジック |
| new.html.haml | `app/views/devise/registrations/new.html.haml` | ビュー | ユーザー登録画面テンプレート |
| _signup_box_form.html.haml | `app/views/devise/registrations/_signup_box_form.html.haml` | ビュー | 登録フォームパーシャル |
| registrations_build_service.rb | `app/services/users/registrations_build_service.rb` | サービス | ユーザービルドロジック |
| _omniauth_provider_button.html.haml | `app/views/devise/shared/_omniauth_provider_button.html.haml` | ビュー | OAuthボタンパーシャル |
| _terms_of_service_notice.html.haml | `app/views/devise/shared/_terms_of_service_notice.html.haml` | ビュー | 利用規約同意文言パーシャル |
