# 画面設計書 44-ネットワークグラフ

## 概要

本ドキュメントは、GitLabのネットワークグラフ（Repository graph）画面の設計仕様を記載したものである。

### 本画面の処理概要

ネットワークグラフ画面は、リポジトリのブランチとコミットの関係を視覚的なグラフ形式で表示する画面である。ブランチの分岐・マージの履歴を直感的に把握できる。

**業務上の目的・背景**：複数のブランチが存在する開発プロジェクトにおいて、ブランチ間の関係やマージ履歴を視覚的に理解することは、プロジェクトの状態把握やリリース計画の策定において重要である。本画面は、Gitの複雑なブランチ構造を分かりやすいグラフ形式で表示し、開発者がリポジトリの履歴を効率的に追跡できるようにする。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能
1. リポジトリメニューから「Graph」を選択
2. 直接URL（`/:namespace/:project/-/network/:ref`）を指定

**主要な操作・処理内容**：
1. ブランチ/タグ/コミットのネットワークグラフ表示
2. ブランチ/タグの切り替え（リファレンスセレクター）
3. 特定コミットへのジャンプ（検索機能）
4. 矢印キーによるグラフのナビゲーション
5. コミットノードをクリックしてコミット詳細へ遷移

**画面遷移**：
- 遷移元: ファイルツリー、ブランチ一覧、コミット一覧
- 遷移先: コミット詳細

**権限による表示制御**：
- リポジトリ閲覧権限（`read_code`）が必要
- 未ログインユーザーは、フィーチャーフラグ有効時にデフォルトブランチ以外へのアクセスで認証が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | リポジトリグラフ | 主機能 | ブランチ・コミットのグラフ表示 |

## 画面種別

一覧・グラフ

## URL/ルーティング

```
GET /:namespace/:project/-/network/:id
GET /:namespace/:project/-/network/:id (format: json)
```

## 入出力項目

| 項目名 | I/O | 型 | 必須 | 説明 |
|--------|-----|-----|------|------|
| id | 入力 | String | 必須 | リファレンス（ブランチ/タグ/コミットSHA） |
| filter_ref | 入力 | String | 任意 | フィルタリングするリファレンス |
| extended_sha1 | 入力 | String | 任意 | ジャンプ先コミットSHA |
| ref_type | 入力 | String | 任意 | リファレンスタイプ（branch/tag） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ページタイトル | String | "Repository graph" |
| リファレンスセレクター | Dropdown | ブランチ/タグ切り替え |
| 検索フォーム | Input | コミットSHA検索 |
| ネットワークグラフ | Canvas/SVG | ブランチ・コミットのグラフ |
| コミットノード | Object | 各コミットの視覚表現 |
| ブランチライン | Object | ブランチの視覚表現 |

## イベント仕様

### 1-リファレンスセレクター変更

1. 選択されたブランチ/タグの値を取得
2. `project_network_path`に新しいrefでリダイレクト
3. グラフデータをJSON形式で再取得

### 2-コミットSHA検索

1. 入力されたSHAを`extended_sha1`パラメータとして送信
2. 該当コミットが存在する場合、そのコミットを中心にグラフを表示
3. 存在しない場合、フラッシュメッセージで通知

### 3-矢印キーナビゲーション

- 上下左右の矢印キーでグラフ内を移動
- `tabindex="0"`でフォーカス可能な要素として設定

### 4-コミットノードクリック

コミット詳細画面（`commit_url`テンプレート）へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| グラフ表示 | なし | SELECT | Gitリポジトリからの読み取りのみ |

### テーブル別更新項目詳細

本画面ではデータベースへの書き込み操作は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| MSG-001 | エラー | "Git revision '{sha}' does not exist." | 指定されたコミットが見つからない場合 |
| MSG-002 | 情報 | "You can move around the graph by using the arrow keys." | 画面の説明として常時表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| リファレンスが存在しない | 404 Not Foundを返却 |
| コミットが見つからない | フラッシュメッセージを表示 |
| 権限不足 | 403 Forbiddenを返却 |
| 未ログインで非デフォルトブランチ | 認証要求（フィーチャーフラグ有効時） |

## 備考

- グラフデータはJSON形式で非同期取得される
- `Network::Graph`クラスがグラフデータを生成
- コミットURLはプレースホルダー（`%s`）を含むテンプレートとして提供される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ネットワークグラフのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | graph.rb | `lib/network/graph.rb` | グラフデータの構造 |
| 1-2 | commit.rb | `lib/network/commit.rb` | グラフ内のコミット表現 |

**読解のコツ**: `Network::Graph`はGitリポジトリからコミット情報を取得し、グラフ描画用のデータ構造に変換する。

#### Step 2: エントリーポイントを理解する

コントローラーの`show`アクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | network_controller.rb | `app/controllers/projects/network_controller.rb` | showアクション |

**主要処理フロー**:
1. **行7-11**: before_action（権限チェック、変数割り当て）
2. **行16**: `authenticate_user!`（条件付き認証）
3. **行18-22**: URL/データ準備
4. **行31-33**: JSONレスポンス用グラフ生成

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/network/show.html.haml` | メインビュー |

**主要処理フロー**:
- **行5-8**: ページヘッダーと説明
- **行11-15**: リファレンスセレクターと検索フォーム
- **行17-19**: グラフ描画領域（data属性でURL/設定を渡す）

### プログラム呼び出し階層図

```
NetworkController#show
    │
    ├─ before_action :assign_ref_vars
    │      └─ ExtractsPath#assign_ref_vars
    │
    ├─ before_action :assign_options
    │      └─ params.permit(:filter_ref, :extended_sha1)
    │
    ├─ before_action :assign_commit
    │      └─ @repo.commit(@options[:extended_sha1])
    │
    ├─ HTML Response
    │      └─ render "show"
    │
    └─ JSON Response
           └─ Network::Graph.new(project, @ref, @commit, filter_ref)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ref (branch/tag) ───▶ NetworkController#show ───▶ HTML Response
                           │
                           ├─▶ ExtractsPath (ref解析)
                           │
                           └─▶ Network::Graph.new()
                                   │
                                   └─▶ JSON (グラフデータ)
                                          │
                                          └─▶ JavaScript (描画)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| network_controller.rb | `app/controllers/projects/network_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/network/show.html.haml` | テンプレート | メインビュー |
| graph.rb | `lib/network/graph.rb` | ライブラリ | グラフデータ生成 |
| commit.rb | `lib/network/commit.rb` | ライブラリ | コミットデータ |
| repository.rb | `config/routes/repository.rb` | ルーティング | URL定義 |
| network.js | `app/assets/javascripts/network/` | JavaScript | グラフ描画 |
