# 画面設計書 45-貢献者グラフ

## 概要

本ドキュメントは、GitLabの貢献者グラフ（Contributor analytics）画面の設計仕様を記載したものである。

### 本画面の処理概要

貢献者グラフ画面は、リポジトリへの貢献者の統計情報を視覚的なグラフ形式で表示する画面である。各貢献者のコミット数、追加・削除行数などの統計情報を時系列で確認できる。

**業務上の目的・背景**：オープンソースプロジェクトやチーム開発において、各メンバーの貢献度を可視化することは、プロジェクト管理やパフォーマンス評価において重要である。本画面は、リポジトリへの貢献状況を統計的に分析し、開発活動の傾向を把握できるようにする。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能
1. リポジトリメニューから「Contributors」を選択
2. 直接URL（`/:namespace/:project/-/graphs/:ref`）を指定

**主要な操作・処理内容**：
1. 貢献者ごとのコミット統計表示
2. 時系列でのコミット活動グラフ表示
3. ブランチ/タグの切り替え
4. 貢献者一覧へのコミット一覧リンク

**画面遷移**：
- 遷移元: ファイルツリー、リポジトリメニュー
- 遷移先: コミット一覧

**権限による表示制御**：
- リポジトリグラフ閲覧権限（`read_repository_graphs`）が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 125 | コントリビューションアナリティクス | 主機能 | リポジトリ貢献者統計の表示 |

## 画面種別

一覧・グラフ

## URL/ルーティング

```
GET /:namespace/:project/-/graphs/:id
GET /:namespace/:project/-/graphs/:id (format: json)
GET /:namespace/:project/-/graphs/:id/charts
GET /:namespace/:project/-/graphs/:id/commits
GET /:namespace/:project/-/graphs/:id/languages
GET /:namespace/:project/-/graphs/:id/ci
```

## 入出力項目

| 項目名 | I/O | 型 | 必須 | 説明 |
|--------|-----|-----|------|------|
| id | 入力 | String | 必須 | リファレンス（ブランチ/タグ） |
| ref_type | 入力 | String | 任意 | リファレンスタイプ（branch/tag） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ページタイトル | String | "Contributor analytics" |
| 貢献者統計グラフ | Chart | コミット活動の時系列グラフ |
| 貢献者一覧 | Array | 各貢献者の統計情報 |
| 貢献者名 | String | 貢献者の名前/メールアドレス |
| コミット数 | Integer | 貢献者のコミット数 |
| コミット日 | Date | コミット日（ISO8601形式） |

## イベント仕様

### 1-ブランチ/タグセレクター変更

1. 選択されたブランチ/タグの値を取得
2. 新しいrefで画面をリロード
3. グラフデータをJSON形式で再取得

### 2-貢献者リンククリック

該当貢献者によるコミット一覧画面へ遷移する。

### 3-グラフデータ取得（非同期）

JavaScriptコンポーネント（`#js-contributors-graph`）がJSON形式でグラフデータを取得し、描画する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| グラフ表示 | なし | SELECT | Gitリポジトリからの読み取りのみ |

### テーブル別更新項目詳細

本画面ではデータベースへの書き込み操作は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| - | - | - | 特定のメッセージなし |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| リファレンスが存在しない | 404 Not Foundを返却 |
| 権限不足 | 403 Forbiddenを返却 |

## 備考

- 最大6000件のコミット（`MAX_COMMITS`）を取得対象とする
- マージコミットは統計から除外（`skip_merges: true`）
- 使用量追跡が有効（`track_event`でSnowplow/Redis HLLに記録）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

貢献者統計のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | commits.rb | `lib/gitlab/graphs/commits.rb` | コミット統計の集計 |

**読解のコツ**: `Gitlab::Graphs::Commits`がコミット一覧から統計データを生成する。

#### Step 2: エントリーポイントを理解する

コントローラーの`show`アクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | graphs_controller.rb | `app/controllers/projects/graphs_controller.rb` | showアクション |

**主要処理フロー**:
1. **行8-10**: before_action（権限チェック、変数割り当て）
2. **行26-44**: showアクション（HTML/JSON対応）
3. **行32-40**: JSONレスポンス（コミットログ生成）

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/graphs/show.html.haml` | メインビュー |

**主要処理フロー**:
- **行5**: ページヘッダー表示
- **行7**: JavaScriptコンポーネント`#js-contributors-graph`のマウント

### プログラム呼び出し階層図

```
GraphsController#show
    │
    ├─ before_action :assign_ref_vars
    │      └─ ExtractsPath#assign_ref_vars
    │
    ├─ before_action :authorize_read_repository_graphs!
    │
    ├─ HTML Response
    │      └─ render "show"
    │             └─ #js-contributors-graph (Vue component)
    │
    └─ JSON Response
           └─ repository.commits(ref, limit: MAX_COMMITS)
                  └─ commit log data
```

### データフロー図

```
[入力]               [処理]                    [出力]

ref (branch/tag) ───▶ GraphsController#show ───▶ HTML Response
                           │
                           └─▶ repository.commits()
                                   │
                                   └─▶ JSON (log data)
                                          │
                                          └─▶ JavaScript (グラフ描画)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| graphs_controller.rb | `app/controllers/projects/graphs_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/graphs/show.html.haml` | テンプレート | メインビュー |
| commits.rb | `lib/gitlab/graphs/commits.rb` | ライブラリ | コミット統計 |
| repository.rb | `config/routes/repository.rb` | ルーティング | URL定義 |
| contributors/ | `app/assets/javascripts/pages/projects/graphs/show/` | JavaScript | グラフ描画 |
