# 画面設計書 46-ファイル検索

## 概要

本ドキュメントは、GitLabのファイル検索（Find file）画面の設計仕様を記載したものである。

### 本画面の処理概要

ファイル検索画面は、リポジトリ内のファイルをパス名で検索する画面である。ファイル名やパスの一部を入力すると、リアルタイムで検索結果が表示され、目的のファイルに素早くアクセスできる。

**業務上の目的・背景**：大規模なリポジトリにおいて、特定のファイルを効率的に見つけることは開発作業の生産性に直結する。本画面は、ファジー検索機能を提供し、開発者がファイル名の一部からでも目的のファイルを迅速に特定できるようにする。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能
1. リポジトリ表示中にキーボードショートカット「t」を押下
2. ファイルツリー画面の「Find file」ボタンをクリック
3. 直接URL（`/:namespace/:project/-/find_file/:ref`）を指定

**主要な操作・処理内容**：
1. ファイルパスによるファジー検索
2. 検索結果のリアルタイム表示
3. ファイル選択によるファイル表示画面への遷移
4. ブランチ/タグの切り替え

**画面遷移**：
- 遷移元: ファイルツリー、キーボードショートカット
- 遷移先: ファイル表示

**権限による表示制御**：
- リポジトリ閲覧権限（`read_code`）が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 103 | プロジェクト内検索 | 主機能 | リポジトリ内ファイル検索 |

## 画面種別

検索

## URL/ルーティング

```
GET /:namespace/:project/-/find_file/:id
GET /:namespace/:project/-/files/:id (JSON)
```

## 入出力項目

| 項目名 | I/O | 型 | 必須 | 説明 |
|--------|-----|-----|------|------|
| id | 入力 | String | 必須 | リファレンス（ブランチ/タグ/コミットSHA） |
| ref_type | 入力 | String | 任意 | リファレンスタイプ（branch/tag） |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ブランチセレクター | Dropdown | ブランチ/タグ切り替え |
| パンくずリスト | Breadcrumb | プロジェクト名 |
| 検索入力フォーム | Input | ファイルパス検索入力 |
| 検索結果一覧 | Table | マッチしたファイル一覧 |
| 空状態メッセージ | Text | 検索結果がない場合の表示 |

## イベント仕様

### 1-検索入力

1. 入力テキストを取得
2. JavaScriptでファジーマッチングを実行
3. マッチしたファイルを結果テーブルに表示
4. 結果がない場合は空状態メッセージを表示

### 2-ファイルクリック

ファイル表示画面（`blob_url_template`を使用）へ遷移する。

### 3-ブランチセレクター変更

1. 選択されたブランチ/タグの値を取得
2. 新しいrefで画面をリロード
3. ファイル一覧をJSON形式で再取得

### 4-ページ読み込み

1. コントローラーの`list`アクションでファイル一覧（JSON）を取得
2. JavaScriptでファイル一覧をキャッシュ
3. 検索入力に応じてフィルタリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイル検索 | なし | SELECT | Gitリポジトリからの読み取りのみ |

### テーブル別更新項目詳細

本画面ではデータベースへの書き込み操作は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| MSG-001 | 情報 | "There are no matching files" | 検索結果がない場合 |
| MSG-002 | 情報 | "Try using a different search term to find the file you are looking for." | 検索結果がない場合（説明） |
| MSG-003 | プレースホルダー | "Find by path" | 検索入力フォーム |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| コミットが存在しない | 404 Not Foundを返却 |
| リファレンスが存在しない | 404 Not Foundを返却 |
| 権限不足 | 403 Forbiddenを返却 |

## 備考

- ファイル一覧は`@repo.ls_files(@commit.id)`で取得
- 検索はクライアントサイドでJavaScriptにより実行
- `js-file-finder`クラスでJavaScriptコンポーネントが初期化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイル一覧のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repository.rb | `app/models/repository.rb` | ls_filesメソッド |

**読解のコツ**: `ls_files`はGitリポジトリのファイル一覧を配列として返す。

#### Step 2: エントリーポイントを理解する

コントローラーの`show`と`list`アクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | find_file_controller.rb | `app/controllers/projects/find_file_controller.rb` | showアクション、listアクション |

**主要処理フロー**:
1. **行9-11**: before_action（権限チェック、変数割り当て）
2. **行16-23**: showアクション（HTML表示）
3. **行26-31**: listアクション（JSON応答）

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/find_file/show.html.haml` | メインビュー |

**主要処理フロー**:
- **行7**: data属性でURL/設定をJavaScriptに渡す
- **行9-10**: ブランチセレクター
- **行11-16**: パンくずリストと検索入力
- **行18-29**: 検索結果テーブルと空状態表示

### プログラム呼び出し階層図

```
FindFileController#show
    │
    ├─ before_action :assign_ref_vars
    │      └─ ExtractsPath#assign_ref_vars
    │
    └─ render "show"
           └─ .js-file-finder (JavaScript component)
                  │
                  └─ FindFileController#list (AJAX)
                         └─ @repo.ls_files(@commit.id)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ref (branch/tag) ───▶ FindFileController#show ───▶ HTML Response
                           │
                           └─▶ JavaScript (AJAX)
                                   │
                                   └─▶ FindFileController#list
                                          │
                                          └─▶ JSON (file paths)
                                                 │
                                                 └─▶ Client-side filter
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| find_file_controller.rb | `app/controllers/projects/find_file_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/find_file/show.html.haml` | テンプレート | メインビュー |
| repository.rb | `app/models/repository.rb` | モデル | ファイル一覧取得 |
| repository.rb | `config/routes/repository.rb` | ルーティング | URL定義 |
| file_finder.js | `app/assets/javascripts/` | JavaScript | 検索処理 |
