# 画面設計書 47-課題一覧

## 概要

本ドキュメントは、GitLabの課題一覧（Issues）画面の設計仕様を記載したものである。

### 本画面の処理概要

課題一覧画面は、プロジェクトに登録されている課題（Issue）を一覧表示する画面である。課題の検索、フィルタリング、ソート、一括操作などの機能を提供し、課題管理の中心となる画面である。

**業務上の目的・背景**：ソフトウェア開発やプロジェクト管理において、タスクやバグの追跡は重要な作業である。本画面は、チームメンバーがプロジェクトの課題状況を把握し、効率的に作業を管理できるようにするための中核機能を提供する。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能
1. プロジェクトメニューから「Issues」を選択
2. ダッシュボードの課題一覧から遷移
3. 直接URL（`/:namespace/:project/-/issues`）を指定

**主要な操作・処理内容**：
1. 課題の一覧表示（ページネーション対応）
2. 検索・フィルタリング（ステータス、担当者、ラベル、マイルストーン等）
3. ソート（作成日、更新日、期限等）
4. 一括更新（ステータス変更、担当者割り当て等）
5. 課題のエクスポート（CSV）
6. 課題のインポート（CSV）
7. 新規課題作成への遷移

**画面遷移**：
- 遷移元: プロジェクトトップ、ダッシュボード
- 遷移先: 課題詳細、課題新規作成、課題ボード

**権限による表示制御**：
- 課題閲覧には`read_issue`権限が必要
- 課題作成には`create_issue`権限が必要
- インポート/エクスポートには`import_issues`/適切な権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | イシュー作成 | 主機能 | プロジェクトの課題一覧表示 |
| 40 | ラベル管理 | 補助機能 | ラベルによるフィルタリング |
| 41 | マイルストーン管理 | 補助機能 | マイルストーンによるフィルタリング |

## 画面種別

一覧

## URL/ルーティング

```
GET /:namespace/:project/-/issues
GET /:namespace/:project/-/issues (format: atom)
GET /:namespace/:project/-/issues (format: ics) - calendar
POST /:namespace/:project/-/issues/bulk_update
POST /:namespace/:project/-/issues/import_csv
POST /:namespace/:project/-/issues/export_csv
GET /:namespace/:project/-/issues/service_desk
```

## 入出力項目

| 項目名 | I/O | 型 | 必須 | 説明 |
|--------|-----|-----|------|------|
| state | 入力 | String | 任意 | 課題状態フィルター（opened/closed/all） |
| scope | 入力 | String | 任意 | スコープ（created_by_me/assigned_to_me/all） |
| search | 入力 | String | 任意 | 検索キーワード |
| label_name | 入力 | Array | 任意 | ラベルフィルター |
| milestone_title | 入力 | String | 任意 | マイルストーンフィルター |
| assignee_id | 入力 | Integer | 任意 | 担当者フィルター |
| author_id | 入力 | Integer | 任意 | 作成者フィルター |
| sort | 入力 | String | 任意 | ソート順 |
| page | 入力 | Integer | 任意 | ページ番号 |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 課題タイトル | String | 課題のタイトル（リンク） |
| 課題番号 | Integer | 課題の参照番号（#xxx） |
| ステータス | String | Open/Closed |
| ラベル | Array | 付与されたラベル |
| マイルストーン | String | 関連するマイルストーン |
| 担当者 | Array | 担当者アバター・名前 |
| 作成者 | User | 課題作成者 |
| 作成日時 | DateTime | 作成日時 |
| 更新日時 | DateTime | 最終更新日時 |
| 期限 | Date | 期限日 |
| コメント数 | Integer | コメント数 |
| 重み | Integer | 課題の重み（EE機能） |

## イベント仕様

### 1-新規課題作成ボタン押下

課題新規作成画面（`/:namespace/:project/-/issues/new`）へ遷移する。

### 2-フィルター適用

1. 選択されたフィルター条件を取得
2. URLパラメータを更新
3. 課題一覧を再取得・表示

### 3-ソート変更

1. 選択されたソート条件を取得
2. URLパラメータを更新
3. 課題一覧を再取得・表示

### 4-一括更新

1. 対象課題を選択
2. 更新内容を選択（ステータス、担当者、ラベル等）
3. `bulk_update`エンドポイントへPOST
4. 結果に応じて一覧を更新

### 5-CSVエクスポート

1. 現在のフィルター条件でエクスポートをリクエスト
2. `IssuableExportCsvWorker`でバックグラウンド処理
3. 完了後、メールでCSVファイルを送信

### 6-CSVインポート

1. CSVファイルを選択
2. `import_csv`エンドポイントへPOST
3. `Issues::PrepareImportCsvService`で処理
4. 結果をフラッシュメッセージで表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | issues | SELECT | 課題一覧の取得 |
| 一括更新 | issues | UPDATE | 複数課題の更新 |
| CSVインポート | issues | INSERT | 新規課題の作成 |

### テーブル別更新項目詳細

#### issues（一括更新時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state_id | 選択されたステータス | Open/Closed |
| UPDATE | assignee_ids | 選択された担当者 | 複数可 |
| UPDATE | milestone_id | 選択されたマイルストーン | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| MSG-001 | 成功 | "Your CSV export has started. It will be emailed to {email} when complete." | CSVエクスポート開始時 |
| MSG-002 | 成功 | インポート成功メッセージ | CSVインポート成功時 |
| MSG-003 | エラー | インポートエラーメッセージ | CSVインポート失敗時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 権限不足 | 403 Forbiddenを返却 |
| プロジェクトが存在しない | 404 Not Foundを返却 |
| 検索レート制限超過 | レート制限エラーを返却 |

## 備考

- Work Items機能が有効な場合、Work Items一覧画面にリダイレクトされる
- Jiraインポート機能との連携に対応
- ATOMフィードとiCalendarフィードに対応
- `Issue::TYPES_FOR_LIST`で表示対象の課題タイプを制限

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

課題（Issue）モデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | 課題のデータ構造、スコープ |
| 1-2 | issues_finder.rb | `app/finders/issues_finder.rb` | 課題検索のロジック |

**読解のコツ**: `Issue`モデルは多くのAssociationを持つ。`Issuable`モジュールで共通機能を提供。

#### Step 2: エントリーポイントを理解する

コントローラーの`index`アクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues_controller.rb | `app/controllers/projects/issues_controller.rb` | indexアクション |

**主要処理フロー**:
1. **行29**: `check_issues_available!` - 課題機能の有効確認
2. **行33-38**: `set_issuables_index` - 一覧データの取得
3. **行89-101**: indexアクション

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/issues/index.html.haml` | メインビュー |

**主要処理フロー**:
- **行12-15**: Jiraインポート状態表示
- **行17**: Work Itemsコンポーネント（`#js-work-items`）

### プログラム呼び出し階層図

```
IssuesController#index
    │
    ├─ before_action :check_issues_available!
    │
    ├─ before_action :set_issuables_index
    │      └─ IssuableCollections#set_issuables_index
    │             └─ IssuesFinder.new().execute
    │
    ├─ redirect_index_to_work_items (条件付き)
    │      └─ redirect_to project_work_items_path
    │
    └─ render "index"
           └─ #js-work-items (Vue component)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Filter params ───▶ IssuesController#index ───▶ HTML/Atom Response
                           │
                           ├─▶ IssuesFinder#execute
                           │       └─▶ Issue Collection
                           │
                           └─▶ Pagination
                                   └─▶ Paginated Issues
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| issues_controller.rb | `app/controllers/projects/issues_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/projects/issues/index.html.haml` | テンプレート | メインビュー |
| issue.rb | `app/models/issue.rb` | モデル | 課題データ構造 |
| issues_finder.rb | `app/finders/issues_finder.rb` | Finder | 検索ロジック |
| issues.rb | `config/routes/issues.rb` | ルーティング | URL定義 |
| issuable_collections.rb | `app/controllers/concerns/issuable_collections.rb` | Concern | 共通処理 |
