# 画面設計書 48-課題新規作成

## 概要

本ドキュメントは、GitLabの課題新規作成（New Issue）画面の設計仕様を記載したものである。

### 本画面の処理概要

課題新規作成画面は、プロジェクトに新しい課題（Issue）を作成するための画面である。タイトル、説明、担当者、ラベル、マイルストーン等の情報を入力し、課題を登録できる。

**業務上の目的・背景**：ソフトウェア開発やプロジェクト管理において、新しいタスクやバグを素早く登録することは、チームの生産性に直結する。本画面は、必要な情報を効率的に入力でき、テンプレート機能やMRからのディスカッション解決など、高度な機能も提供する。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能
1. 課題一覧画面の「New Issue」ボタンをクリック
2. マージリクエストの「Resolve in issue」リンクをクリック
3. キーボードショートカット
4. 直接URL（`/:namespace/:project/-/issues/new`）を指定

**主要な操作・処理内容**：
1. 課題タイトルの入力
2. 課題説明の入力（Markdown対応）
3. 担当者の選択
4. ラベルの選択
5. マイルストーンの選択
6. 期限の設定
7. 課題タイプの選択（Issue/Incident等）
8. 機密フラグの設定
9. テンプレートの適用
10. 関連課題のリンク

**画面遷移**：
- 遷移元: 課題一覧、マージリクエスト詳細、プロジェクトトップ
- 遷移先: 課題詳細（作成成功時）

**権限による表示制御**：
- 課題作成権限（`create_issue`）が必要
- 機密課題の作成には`reporter`以上のロールが必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | イシュー作成 | 主機能 | 新規課題の作成処理 |
| 149 | イシュー/MRテンプレート | 補助機能 | イシューテンプレートの適用 |

## 画面種別

登録

## URL/ルーティング

```
GET /:namespace/:project/-/issues/new
POST /:namespace/:project/-/issues
```

## 入出力項目

| 項目名 | I/O | 型 | 必須 | 説明 |
|--------|-----|-----|------|------|
| issue[title] | 入力 | String | 必須 | 課題タイトル |
| issue[description] | 入力 | Text | 任意 | 課題説明（Markdown） |
| issue[assignee_ids] | 入力 | Array | 任意 | 担当者ID配列 |
| issue[label_ids] | 入力 | Array | 任意 | ラベルID配列 |
| issue[milestone_id] | 入力 | Integer | 任意 | マイルストーンID |
| issue[due_date] | 入力 | Date | 任意 | 期限日 |
| issue[confidential] | 入力 | Boolean | 任意 | 機密フラグ |
| issue[issue_type] | 入力 | String | 任意 | 課題タイプ |
| merge_request_to_resolve_discussions_of | 入力 | Integer | 任意 | 解決対象MRのIID |
| discussion_to_resolve | 入力 | String | 任意 | 解決対象ディスカッションID |
| add_related_issue | 入力 | Integer | 任意 | 関連課題ID |

## 表示項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイトル入力 | Input | 課題タイトル入力フォーム |
| 説明入力 | Textarea | Markdown対応説明入力 |
| テンプレートセレクター | Dropdown | イシューテンプレート選択 |
| タイプセレクター | Dropdown | 課題タイプ選択 |
| 担当者セレクター | Dropdown | 担当者選択（複数可） |
| ラベルセレクター | Dropdown | ラベル選択（複数可） |
| マイルストーンセレクター | Dropdown | マイルストーン選択 |
| 期限ピッカー | DatePicker | 期限日選択 |
| 機密チェックボックス | Checkbox | 機密フラグ設定 |
| 解決ディスカッション表示 | Text | MRからの解決対象ディスカッション |
| 関連課題表示 | Link | 関連付ける課題 |

## イベント仕様

### 1-作成ボタン押下

1. 入力値のバリデーション
2. `Issues::CreateService`を実行
3. 成功時：課題詳細画面へリダイレクト
4. スパムチェックでブロックされた場合：CAPTCHA表示
5. 失敗時：エラーメッセージを表示し、フォームを再表示

### 2-テンプレート選択

1. 選択されたテンプレートを取得
2. タイトル・説明フィールドにテンプレート内容を適用

### 3-プレビュータブ

Markdown形式の説明文をHTMLプレビュー表示に切り替え。

### 4-ディスカッション解決リンク経由

1. MR情報とディスカッション情報を取得
2. 解決対象ディスカッションを表示
3. 課題作成後、ディスカッションを自動的に解決済みに設定

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 課題作成 | issues | INSERT | 新規課題レコード作成 |
| ラベル付与 | label_links | INSERT | ラベル関連付け |
| 担当者設定 | issue_assignees | INSERT | 担当者関連付け |
| 関連課題リンク | issue_links | INSERT | 課題間リンク作成 |

### テーブル別更新項目詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | 入力値 | 必須 |
| INSERT | description | 入力値 | 任意 |
| INSERT | author_id | current_user.id | 作成者 |
| INSERT | project_id | プロジェクトID | |
| INSERT | namespace_id | プロジェクトnamespace_id | |
| INSERT | milestone_id | 選択値 | 任意 |
| INSERT | due_date | 選択値 | 任意 |
| INSERT | confidential | チェック状態 | デフォルトfalse |
| INSERT | work_item_type_id | 選択タイプに対応するID | |
| INSERT | state_id | 1 (open) | デフォルト |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|-----------|----------|
| MSG-001 | 成功 | "Resolved 1 discussion." | 単一ディスカッション解決時 |
| MSG-002 | 成功 | "Resolved all discussions." | 全ディスカッション解決時 |
| MSG-003 | エラー | バリデーションエラー | 入力値不正時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 権限不足 | 403 Forbiddenを返却、またはログイン画面へリダイレクト |
| スパム検出 | CAPTCHA表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 課題作成後、`store_uri`でリダイレクト先を保存（ログイン後に戻る用）
- `Issues::BuildService`でデフォルト値や関連情報を設定
- Work Items機能が有効な場合、Work Item作成画面が使用される可能性あり
- Observability連携（metrics/logs/tracing）パラメータに対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

課題（Issue）モデルと関連するパラメータを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | 課題のデータ構造、バリデーション |

**読解のコツ**: `validates`でバリデーションルールを確認。`belongs_to`/`has_many`で関連を把握。

#### Step 2: エントリーポイントを理解する

コントローラーの`new`と`create`アクションが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues_controller.rb | `app/controllers/projects/issues_controller.rb` | new/createアクション |

**主要処理フロー**:
1. **行44**: `authorize_create_issue!` - 権限チェック
2. **行108-131**: newアクション - フォーム初期化
3. **行166-198**: createアクション - 課題作成処理

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build_service.rb | `app/services/issues/build_service.rb` | フォーム初期値設定 |
| 3-2 | create_service.rb | `app/services/issues/create_service.rb` | 課題作成処理 |

#### Step 4: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.html.haml | `app/views/projects/issues/new.html.haml` | メインビュー |

**主要処理フロー**:
- **行10-20**: 隠しパラメータ（title, description, issue_type等）
- **行22**: Work Itemsコンポーネント

### プログラム呼び出し階層図

```
IssuesController#new
    │
    ├─ before_action :authenticate_user!
    │
    ├─ before_action :authorize_create_issue!
    │
    └─ Issues::BuildService.new().execute
           │
           └─ @issue (初期化されたIssueオブジェクト)

IssuesController#create
    │
    ├─ Issues::CreateService.new().execute
    │      │
    │      ├─ Issue.create
    │      ├─ LabelLinks.create (if labels)
    │      ├─ IssueAssignees.create (if assignees)
    │      └─ IssueLinks.create (if related)
    │
    └─ redirect_to project_issue_path (成功時)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Form params ───▶ IssuesController#create ───▶ Redirect
                       │
                       ├─▶ Issues::CreateService
                       │       │
                       │       ├─▶ Issue.new
                       │       ├─▶ Validation
                       │       ├─▶ Spam check
                       │       └─▶ Issue.save
                       │
                       └─▶ Result (success/error)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| issues_controller.rb | `app/controllers/projects/issues_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/projects/issues/new.html.haml` | テンプレート | メインビュー |
| issue.rb | `app/models/issue.rb` | モデル | 課題データ構造 |
| build_service.rb | `app/services/issues/build_service.rb` | サービス | フォーム初期化 |
| create_service.rb | `app/services/issues/create_service.rb` | サービス | 課題作成処理 |
| issues.rb | `config/routes/issues.rb` | ルーティング | URL定義 |
