# 画面設計書 5-アカウントロック解除画面

## 概要

本ドキュメントは、GitLabのアカウントロック解除画面の設計仕様を記載したものです。ログイン失敗回数超過によりロックされたアカウントの解除手続きを開始する画面です。

### 本画面の処理概要

**業務上の目的・背景**：アカウントロック解除画面は、ブルートフォース攻撃対策としてロックされたアカウントを、正当なユーザーが自身で解除できるようにする機能を提供します。一定回数以上のログイン失敗でアカウントがロックされた場合、ユーザーはこの画面からメールアドレスを入力し、ロック解除用のリンクが記載されたメールを受け取ることができます。これにより、管理者の介入なしにアカウントの回復が可能となります。

**画面へのアクセス方法**：
- ログイン画面でアカウントロックエラーが表示された際のリンクをクリック
- 直接 `/users/unlock/new` URLにアクセス

**主要な操作・処理内容**：
1. 登録済みメールアドレスの入力
2. ロック解除メールの送信要求
3. 送信完了メッセージの表示

**画面遷移**：
- 遷移元：ログイン画面（アカウントロック時）
- 遷移先：ログイン画面（メール送信後）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- 認証済みユーザーがアクセスした場合はダッシュボードにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | ユーザー登録 | 主機能 | ロックされたアカウントの解除要求処理 |

## 画面種別

入力フォーム

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/unlock/new` | ロック解除画面表示 |
| POST | `/users/unlock` | ロック解除メール送信 |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| メールアドレス | user[email] | string | Yes | 255 | 登録済みメールアドレス |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| タイトル | 「Resend unlock instructions」 | 常時表示 |
| メール入力フォーム | メールアドレス入力欄 | 常時表示 |
| Resend unlock instructionsボタン | ロック解除メール送信ボタン | 常時表示 |
| Sign inリンク | ログイン画面へのリンク | 常時表示 |
| エラーメッセージ | 入力エラー表示領域 | エラー発生時 |

## イベント仕様

### 1-Resend unlock instructionsボタン押下

**トリガー**: 「Resend unlock instructions」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. メールアドレスでユーザー検索
3. アカウントロック状態確認
4. ロック解除トークン生成
5. ロック解除メール送信
6. ログイン画面にリダイレクト

**成功時**: ログイン画面にリダイレクトし、メール送信完了メッセージを表示
**失敗時**: エラーメッセージを表示してフォームに戻る

### 2-Sign inリンククリック

**トリガー**: 「Sign in」リンククリック

**処理**: ログイン画面（`/users/sign_in`）にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ロック解除要求送信 | users | UPDATE | ロック解除トークン設定 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | unlock_token | ハッシュ化されたトークン | Devise token generator使用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | 情報 | If your account exists, you will receive an email with instructions on how to unlock it in a few minutes. | ロック解除要求成功時（パラノイドモード） |
| MSG002 | エラー | Email can't be blank | メールアドレス未入力時 |
| MSG003 | エラー | Email is invalid | メールアドレス形式不正時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| メールアドレス未登録 | セキュリティ上、成功時と同じメッセージを表示（ユーザー列挙攻撃防止） |
| アカウント未ロック | セキュリティ上、成功時と同じメッセージを表示 |
| メール送信失敗 | システムエラーとしてログに記録、ユーザーには成功メッセージを表示 |

## 備考

- Deviseの `lockable` モジュールにより実装
- セキュリティ上、アカウントの存在有無やロック状態に関わらず同じメッセージを表示する
- ロック解除トークンの有効期限はDevise設定で定義
- メール内のリンクをクリックするとアカウントが即座にロック解除される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アカウントロックに関連するユーザーモデルの属性を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseの`:lockable`モジュール、locked_at、unlock_token属性 |

**読解のコツ**: `devise :lockable` によりアカウントロック機能が有効化される（119行目）。

#### Step 2: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/devise/unlocks/new.html.haml` | フォーム構成 |

**主要処理フロー**:
- **1行目**: タブタイトル「Resend unlock instructions」
- **2行目**: `gitlab_ui_form_for` でフォーム生成
- **5-7行目**: メールアドレス入力フィールド
- **9-10行目**: 送信ボタン
- **12行目**: サインインリンク

### プログラム呼び出し階層図

```
Devise::UnlocksController#create
    │
    ├─ User.send_unlock_instructions(email: params[:email])
    │      ├─ find_by_email
    │      ├─ generate_unlock_token!
    │      └─ DeviseMailer.unlock_instructions
    │
    └─ redirect_to after_sending_unlock_instructions_path
```

### データフロー図

```
[入力]                    [処理]                              [出力]

user[email]      ───▶ UnlocksController#create ───▶ リダイレクト
                        │
                        ├─ User.find_by_email ───▶ users テーブル SELECT
                        │
                        ├─ generate_unlock_token! ───▶ users テーブル UPDATE
                        │      (unlock_token)
                        │
                        └─ DeviseMailer.unlock_instructions ───▶ メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/devise/unlocks/new.html.haml` | ビュー | ロック解除画面テンプレート |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータとロック管理 |
| _tab_single.html.haml | `app/views/devise/shared/_tab_single.html.haml` | ビュー | タブタイトルパーシャル |
| _error_messages.html.haml | `app/views/devise/shared/_error_messages.html.haml` | ビュー | エラーメッセージパーシャル |
| _sign_in_link.html.haml | `app/views/devise/shared/_sign_in_link.html.haml` | ビュー | ログインリンクパーシャル |
