# 画面設計書 54-マイルストーン詳細

## 概要

本ドキュメントは、GitLabにおけるプロジェクトマイルストーン詳細画面に関する設計書です。マイルストーンの情報、進捗状況、関連する課題・マージリクエストを表示し、管理するための画面仕様を定義します。

### 本画面の処理概要

**業務上の目的・背景**：マイルストーン詳細画面は、特定のマイルストーンに関する包括的な情報を提供します。マイルストーンに紐づく課題やマージリクエストの進捗を一覧で確認し、全体の完了状況を把握することができます。開発チームがスプリントの進捗確認やリリース準備状況の確認を行う際に使用されます。

**画面へのアクセス方法**：マイルストーン一覧画面からマイルストーン名をクリック、または直接URL `/:namespace/:project/-/milestones/:id` にアクセスします。課題やマージリクエストからのリンクでもアクセス可能です。

**主要な操作・処理内容**：
1. マイルストーン基本情報の閲覧（タイトル、説明、期間）
2. 進捗状況の確認（完了率、バーンダウンチャート）
3. 関連課題一覧の閲覧・操作（Issues タブ）
4. 関連マージリクエスト一覧の閲覧（Merge requests タブ）
5. 参加者一覧の閲覧（Participants タブ）
6. マイルストーンのクローズ・再オープン
7. マイルストーンの編集（編集画面への遷移）
8. マイルストーンの削除

**画面遷移**：
- 遷移元：マイルストーン一覧画面、課題詳細画面、マージリクエスト詳細画面、ダッシュボード
- 遷移先：マイルストーン編集画面、課題詳細画面、マージリクエスト詳細画面、マイルストーン一覧画面

**権限による表示制御**：
- `read_milestone`権限：マイルストーンの閲覧が可能
- `admin_milestone`権限：編集・削除・クローズ操作が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | マイルストーン管理 | 主機能 | マイルストーンの詳細表示 |
| 36 | イシュー作成 | 補助機能 | 関連課題の表示 |
| 28 | マージリクエスト作成 | 補助機能 | 関連MRの表示 |

## 画面種別

詳細画面

## URL/ルーティング

```
GET /:namespace/:project/-/milestones/:id
```

コントローラー: `Projects::MilestonesController#show`

## 入出力項目

### URLパラメータ

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| id | Integer | ○ | マイルストーンのIID |

## 表示項目

### ヘッダー部

| 項目名 | 説明 |
|--------|------|
| マイルストーン名 | タイトル |
| 状態バッジ | Open/Closed |
| 期間表示 | 開始日〜終了日 |
| 進捗バー | 完了課題の割合 |
| アクションボタン | 編集、クローズ/再オープン、削除、昇格 |

### 説明セクション

| 項目名 | 説明 |
|--------|------|
| Description | マイルストーンの説明（Markdownレンダリング） |

### バーンダウンチャート（EE機能）

| 項目名 | 説明 |
|--------|------|
| Burndown Chart | 残作業量の推移グラフ |
| Burnup Chart | 完了作業量の推移グラフ |

### タブ

| タブ名 | 説明 |
|--------|------|
| Issues | 関連課題一覧 |
| Merge requests | 関連マージリクエスト一覧 |
| Participants | 参加者（担当者）一覧 |
| Labels | 使用されているラベル一覧 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| Start date | 開始日 |
| Due date | 終了日 |
| 進捗情報 | 完了/未完了の課題数 |
| 時間追跡 | 見積もり時間と実績時間 |

## イベント仕様

### 1-Closeボタン押下

マイルストーンをクローズします。状態が`active`から`closed`に変更されます。

### 2-Reopenボタン押下

クローズされたマイルストーンを再オープンします。状態が`closed`から`active`に変更されます。

### 3-Editボタン押下

マイルストーン編集画面（`/:namespace/:project/-/milestones/:id/edit`）に遷移します。

### 4-Deleteボタン押下

確認モーダルを表示後、マイルストーンを削除します。削除後はマイルストーン一覧画面に遷移します。

### 5-タブ切り替え

選択したタブに応じて、Issues/Merge requests/Participants/Labelsの内容を表示します。タブ切り替えはAJAXで非同期に読み込まれます。

### 6-Promoteボタン押下

プロジェクトマイルストーンをグループマイルストーンに昇格させます（権限がある場合のみ表示）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | milestones | SELECT | マイルストーン情報取得 |
| 詳細表示 | issues | SELECT | 関連課題取得 |
| 詳細表示 | merge_requests | SELECT | 関連MR取得 |
| Close/Reopen | milestones | UPDATE | state更新 |
| Delete | milestones | DELETE | マイルストーン削除 |

### テーブル別更新項目詳細

#### milestones（Close/Reopen時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | 'closed' or 'active' | 状態変更 |
| UPDATE | updated_at | 現在時刻 | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|---------|
| 成功 | All issues for this milestone are closed. You may close this milestone now. | 全課題完了時 |
| 成功 | Milestone was successfully deleted | 削除成功時 |
| エラー | Unable to close milestone | クローズ失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| マイルストーンが存在しない | 404ページを表示 |
| 閲覧権限がない | 403エラーを返却 |
| 編集権限がない | アクションボタンを非表示 |

## 備考

- タブコンテンツは非同期で読み込まれ、初回アクセス時はIssuesタブがデフォルト表示されます
- バーンダウン/バーンアップチャートはGitLab EE（有料版）の機能です
- 全ての課題がクローズされると、マイルストーンをクローズすることを促すアラートが表示されます
- 説明フィールドはMarkdownレンダリングされ、コードブロックや画像等が適切に表示されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マイルストーンのモデルと関連データを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | milestone.rb | `app/models/milestone.rb` | 状態管理、関連付け |
| 1-2 | milestoneish.rb | `app/models/concerns/milestoneish.rb` | 統計情報メソッド |

**読解のコツ**: Milestoneモデルはstate_machineで状態管理を行い、issues/merge_requestsとの関連を持ちます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | milestones_controller.rb | `app/controllers/projects/milestones_controller.rb` | showアクション |

**主要処理フロー**:
1. **L55-59**: showアクションでマイルストーンを表示
2. **L10**: before_actionでマイルストーンを取得

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/milestones/show.html.haml` | 詳細画面レイアウト |
| 3-2 | _header.html.haml | `app/views/shared/milestones/_header.html.haml` | ヘッダー部分 |
| 3-3 | _tabs.html.haml | `app/views/shared/milestones/_tabs.html.haml` | タブ構成 |
| 3-4 | _sidebar.html.haml | `app/views/shared/milestones/_sidebar.html.haml` | サイドバー |

**主要処理フロー**:
- **show.html.haml L8-12**: add_page_startup_api_callでタブAPIを事前読み込み
- **show.html.haml L10-16**: 全課題完了時のアラート表示
- **show.html.haml L17-24**: 各パーシャルのレンダリング

### プログラム呼び出し階層図

```
Projects::MilestonesController#show
    │
    ├─ @milestone = @project.milestones.find_by!(iid: params[:id])
    │
    └─ app/views/projects/milestones/show.html.haml
           ├─ shared/milestones/_header
           │      └─ アクションボタン（Edit, Close, Delete）
           │
           ├─ shared/milestones/_description
           │      └─ Markdownレンダリング
           │
           ├─ shared/milestones/_burndown (EE)
           │
           ├─ shared/milestones/_tabs
           │      ├─ Issues タブ
           │      ├─ Merge requests タブ
           │      ├─ Participants タブ
           │      └─ Labels タブ
           │
           └─ shared/milestones/_sidebar
                  └─ 日付、進捗情報
```

### データフロー図

```
[入力]                       [処理]                          [出力]

URL (/:id) ───▶ MilestonesController#show
                        │
                        ▼
               @milestone = find_by!(iid:)
                        │
                        ▼
               show.html.haml ───▶ HTML応答
                        │
                        ├─ ヘッダー（タイトル、状態、アクション）
                        ├─ 説明（Markdownレンダリング）
                        ├─ タブ（Issues/MRs/Participants/Labels）
                        └─ サイドバー（日付、進捗）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| milestones_controller.rb | `app/controllers/projects/milestones_controller.rb` | コントローラー | showアクション |
| milestone.rb | `app/models/milestone.rb` | モデル | マイルストーンのデータモデル |
| milestoneish.rb | `app/models/concerns/milestoneish.rb` | Concern | 統計情報メソッド |
| show.html.haml | `app/views/projects/milestones/show.html.haml` | テンプレート | 詳細画面 |
| _header.html.haml | `app/views/shared/milestones/_header.html.haml` | 部分テンプレート | ヘッダー |
| _description.html.haml | `app/views/shared/milestones/_description.html.haml` | 部分テンプレート | 説明 |
| _tabs.html.haml | `app/views/shared/milestones/_tabs.html.haml` | 部分テンプレート | タブ |
| _sidebar.html.haml | `app/views/shared/milestones/_sidebar.html.haml` | 部分テンプレート | サイドバー |
| milestone_actions.rb | `app/controllers/concerns/milestone_actions.rb` | Concern | issues/merge_requestsアクション |
